/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.proc;

import org.cthul.matchers.diagnose.TypesafeQuickDiagnoseMatcherBase;
import org.cthul.matchers.exceptions.IsThrowable;
import org.cthul.proc.Proc;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class Raises
extends TypesafeQuickDiagnoseMatcherBase<Proc> {
    private final Matcher<? super Throwable> exceptionMatcher;

    public Raises(Matcher<? super Throwable> matcher) {
        super(Proc.class);
        this.exceptionMatcher = matcher;
    }

    public void describeTo(Description description) {
        description.appendText("throws ");
        this.exceptionMatcher.describeTo(description);
    }

    @Override
    protected boolean matchesSafely(Proc proc) {
        if (proc.hasResult()) {
            return false;
        }
        return this.exceptionMatcher.matches((Object)proc.getException());
    }

    @Override
    protected void describeMismatchSafely(Proc proc, Description mismatchDescription) {
        if (proc.hasResult()) {
            mismatchDescription.appendText("threw no exception");
        } else {
            this.exceptionMatcher.describeMismatch((Object)proc.getException(), mismatchDescription);
        }
    }

    @Override
    protected boolean matchesSafely(Proc proc, Description mismatchDescription) {
        if (proc.hasResult()) {
            mismatchDescription.appendText("threw no exception");
            return false;
        }
        return Raises.quickMatch(this.exceptionMatcher, proc.getException(), mismatchDescription);
    }

    @Factory
    public static Matcher<Proc> raises(Matcher<? super Throwable> throwableMatcher) {
        return new Raises(throwableMatcher);
    }

    @Factory
    public static Matcher<Proc> raises(Class<? extends Throwable> clazz) {
        return Raises.raises(IsThrowable.throwable(clazz));
    }

    @Factory
    public static Matcher<Proc> raises(String regex) {
        return Raises.raises(IsThrowable.throwable(regex));
    }

    @Factory
    public static Matcher<Proc> raises(Class<? extends Throwable> clazz, String regex) {
        return Raises.raises(IsThrowable.throwable(clazz, regex));
    }

    @Factory
    public static Matcher<Proc> raises(Class<? extends Throwable> clazz, Matcher<? super Throwable> matcher) {
        return Raises.raises(IsThrowable.throwable(clazz, matcher));
    }

    @Factory
    public static Matcher<Proc> raisesException() {
        return Raises.raises(IsThrowable.exception());
    }

    @Factory
    public static Matcher<Proc> raisesException(Matcher<? super Exception> matcher) {
        return Raises.raises(IsThrowable.exception(matcher));
    }

    @Factory
    public static Matcher<Proc> raisesException(Class<? extends Exception> clazz) {
        return new Raises(IsThrowable.exception(clazz));
    }

    @Factory
    public static Matcher<Proc> raisesException(String regex) {
        return new Raises(IsThrowable.exception(regex));
    }

    @Factory
    public static Matcher<Proc> raisesException(Class<? extends Exception> clazz, String regex) {
        return new Raises(IsThrowable.exception(clazz, regex));
    }
}

