/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.proc;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.cthul.matchers.diagnose.TypesafeQuickDiagnoseMatcherBase;
import org.cthul.proc.Proc;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsAnything;
import org.hamcrest.core.IsEqual;

public class Returns
extends TypesafeQuickDiagnoseMatcherBase<Proc> {
    private final Matcher<?> resultMatcher;

    public Returns(Matcher<?> resultMatcher) {
        super(Proc.class);
        this.resultMatcher = resultMatcher;
    }

    public void describeTo(Description description) {
        description.appendText("returns ").appendDescriptionOf(this.resultMatcher);
    }

    @Override
    protected boolean matchesSafely(Proc proc) {
        if (!proc.hasResult()) {
            return false;
        }
        return this.resultMatcher.matches(proc.getResult());
    }

    @Override
    protected void describeMismatchSafely(Proc proc, Description mismatch) {
        if (!proc.hasResult()) {
            mismatch.appendText("threw ").appendValue((Object)proc.getException());
            StringWriter sw = new StringWriter();
            proc.getException().printStackTrace(new PrintWriter(sw));
            mismatch.appendText(" ").appendText(sw.toString());
        } else {
            mismatch.appendText("returned ");
            this.resultMatcher.describeMismatch(proc.getResult(), mismatch);
        }
    }

    @Override
    protected boolean matchesSafely(Proc proc, Description mismatch) {
        if (!proc.hasResult()) {
            this.describeMismatchSafely(proc, mismatch);
            return false;
        }
        return Returns.quickMatch(this.resultMatcher, proc.getResult(), mismatch, "returned $1");
    }

    @Factory
    public static Matcher<Proc> result(Object value) {
        return Returns.returns(value);
    }

    @Factory
    public static Matcher<Proc> result(Matcher<?> resultMatcher) {
        return Returns.returns(resultMatcher);
    }

    @Factory
    public static Matcher<Proc> hasResult() {
        return Returns.returns();
    }

    @Factory
    public static Matcher<Proc> returns(Object value) {
        return new Returns(IsEqual.equalTo((Object)value));
    }

    @Factory
    public static Matcher<Proc> returns(Matcher<?> resultMatcher) {
        return new Returns(resultMatcher);
    }

    @Factory
    public static Matcher<Proc> returns() {
        return new Returns(IsAnything.anything());
    }
}

