/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.object;

import java.util.Objects;
import org.cthul.matchers.diagnose.nested.NestedResultMatcher;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;

public class CIs<T>
extends NestedResultMatcher<T> {
    private final Matcher<? super T> nested;
    private final String prefix;
    private final String pastPrefix;
    private final boolean not;

    @Factory
    public static <T> CIs<T> is(Matcher<? super T> matcher) {
        return new CIs<T>(matcher, "is", false);
    }

    @Factory
    public static <T> CIs<T> has(Matcher<? super T> matcher) {
        return new CIs<T>(matcher, "has", false);
    }

    @Factory
    public static <T> CIs<T> not(Matcher<? super T> matcher) {
        return new CIs<T>(matcher, null, true);
    }

    @Factory
    public static <T> CIs<T> isNot(Matcher<? super T> matcher) {
        return new CIs<T>(matcher, "is", true);
    }

    @Factory
    public static <T> CIs<T> _is(Matcher<? super T> matcher) {
        return new CIs<T>(matcher, "is", false);
    }

    @Factory
    public static <T> CIs<T> _has(Matcher<? super T> matcher) {
        return new CIs<T>(matcher, "has", false);
    }

    @Factory
    public static <T> CIs<T> _not(Matcher<? super T> matcher) {
        return new CIs<T>(matcher, null, true);
    }

    @Factory
    public static <T> CIs<T> _isNot(Matcher<? super T> matcher) {
        return new CIs<T>(matcher, "is", true);
    }

    public CIs(Matcher<? super T> nested, String prefix, boolean not) {
        this.nested = nested;
        this.prefix = prefix;
        this.pastPrefix = CIs.pastPrefix(prefix);
        this.not = not;
    }

    public CIs(Matcher<? super T> nested, String prefix, String pastPrefix, boolean not) {
        this.nested = nested;
        this.prefix = prefix;
        this.pastPrefix = pastPrefix;
        this.not = not;
    }

    public CIs(Matcher<? super T> nested) {
        this(nested, "is", false);
    }

    @Override
    public boolean matches(Object o) {
        return this.not ^ this.nested.matches(o);
    }

    @Override
    public boolean matches(Object o, Description d) {
        if (this.matches(o)) {
            return true;
        }
        this.describeMismatch(o, d);
        return false;
    }

    public void describeTo(Description description) {
        if (this.prefix != null) {
            description.appendText(this.prefix).appendText(" ");
        }
        if (this.not) {
            description.appendText("not ");
        }
        this.nestedDescribeTo((SelfDescribing)this.nested, description);
    }

    @Override
    public int getDescriptionPrecedence() {
        return this.not ? 0x100000 : 0x700000;
    }

    @Override
    public <I> MatchResult<I> matchResult(I item) {
        final MatchResult<I> result = CIs.quickMatchResult(this.nested, item);
        return new NestedResultMatcher.NestedResult<I, CIs<T>>(item, this, this.not ^ result.matched()){

            @Override
            public void describeMatch(Description d) {
                if (!CIs.this.not) {
                    d.appendValue(this.getValue()).appendText(" ");
                }
                this.nestedDescribeTo(this.getMatchPrecedence(), result, d);
            }

            @Override
            public void describeExpected(Description d) {
                if (CIs.this.prefix != null) {
                    d.appendText(CIs.this.prefix).appendText(" ");
                }
                if (CIs.this.not) {
                    d.appendText("not ");
                    this.nestedDescribeTo(this.getExpectedPrecedence(), result.getMatcherDescription(), d);
                } else {
                    this.nestedDescribeTo(this.getExpectedPrecedence(), result.getMismatch().getExpectedDescription(), d);
                }
            }

            @Override
            public void describeMismatch(Description d) {
                if (CIs.this.not) {
                    d.appendValue(this.getValue()).appendText(" ");
                }
                this.nestedDescribeTo(this.getMismatchPrecedence(), result, d);
            }
        };
    }

    protected void appendPastPrefix(Description d) {
        if (this.pastPrefix != null) {
            d.appendText(this.pastPrefix).appendText(" ");
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.nested);
        hash = 29 * hash + Objects.hashCode(this.prefix);
        hash = 29 * hash + Objects.hashCode(this.pastPrefix);
        hash = 29 * hash + (this.not ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CIs other = (CIs)obj;
        if (!Objects.equals(this.nested, other.nested)) {
            return false;
        }
        if (!Objects.equals(this.prefix, other.prefix)) {
            return false;
        }
        if (!Objects.equals(this.pastPrefix, other.pastPrefix)) {
            return false;
        }
        return this.not == other.not;
    }

    public static String pastPrefix(String prefix) {
        if (prefix != null) {
            if (prefix.equals("is")) {
                return "was";
            }
            if (prefix.equals("has")) {
                return "had";
            }
            return prefix;
        }
        return null;
    }

    public static <T> Matcher<T> wrap(String prefix, boolean not, Matcher<? super T> matcher) {
        if (prefix == null && !not) {
            return matcher;
        }
        return new CIs<T>(matcher, prefix, not);
    }
}

