/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.proc;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.cthul.matchers.diagnose.nested.NestedMatcher;
import org.cthul.matchers.diagnose.result.AtomicMismatch;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.cthul.matchers.diagnose.safe.TypesafeNestedResultMatcher;
import org.cthul.proc.Proc;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsAnything;
import org.hamcrest.core.IsEqual;

public class Returns
extends TypesafeNestedResultMatcher<Proc> {
    private final Matcher<?> resultMatcher;

    public Returns(Matcher<?> resultMatcher, String returns, String returned) {
        super(Proc.class);
        this.resultMatcher = resultMatcher;
    }

    public Returns(Matcher<?> resultMatcher) {
        this(resultMatcher, "returns", "returned");
    }

    @Override
    public int getDescriptionPrecedence() {
        return 0x100000;
    }

    public void describeTo(Description description) {
        description.appendText("a call returning ");
        this.nestedDescribeTo((SelfDescribing)this.resultMatcher, description);
    }

    @Override
    protected boolean matchesSafely(Proc proc) {
        if (!proc.hasResult()) {
            return false;
        }
        return this.resultMatcher.matches(proc.getResult());
    }

    @Override
    protected <I extends Proc> MatchResult<I> matchResultSafely(I proc) {
        if (!proc.hasResult()) {
            StringWriter sw = new StringWriter();
            sw.append("threw <");
            sw.append(proc.getException().toString());
            sw.append("> ");
            proc.getException().printStackTrace(new PrintWriter(sw));
            return new AtomicMismatch<I, Returns>(proc, this, sw.toString());
        }
        final MatchResult<Object> nested = Returns.quickMatchResult(this.resultMatcher, proc.getResult());
        return new NestedMatcher.NestedResult<I, Returns>(proc, this, nested.matched()){

            @Override
            public void describeTo(Description description) {
                description.appendText("result ");
                this.nestedDescribeTo(this.getDescriptionPrecedence(), nested, description);
            }

            @Override
            public void describeMatch(Description description) {
                this.describeTo(description);
            }

            @Override
            public void describeExpected(Description description) {
                description.appendText("a call returning ");
                this.nestedDescribeTo(this.getExpectedPrecedence(), nested.getMismatch().getExpectedDescription(), description);
            }

            @Override
            public void describeMismatch(Description description) {
                this.describeTo(description);
            }
        };
    }

    @Factory
    public static Matcher<Proc> result(Object value) {
        return Returns.result(Is.is((Object)value));
    }

    @Factory
    public static Matcher<Proc> result(Matcher<?> resultMatcher) {
        return new Returns(resultMatcher, "result", "result");
    }

    @Factory
    public static Matcher<Proc> hasResult() {
        return Returns.returns();
    }

    @Factory
    public static Matcher<Proc> returns(Object value) {
        return new Returns(IsEqual.equalTo((Object)value));
    }

    @Factory
    public static Matcher<Proc> returns(Matcher<?> resultMatcher) {
        return new Returns(resultMatcher);
    }

    @Factory
    public static Matcher<Proc> returns() {
        return new Returns(IsAnything.anything((String)"anything"));
    }
}

