/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.proc;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.cthul.objects.reflection.Signatures;
import org.cthul.proc.PN;

public class ReflectiveProc
extends PN {
    public static final Class[] ANY_PARAMETERS = null;
    private static final Class[][] PARAM_COUNT = new Class[][]{new Class[0], new Class[1], new Class[2], new Class[3], new Class[4], new Class[5], new Class[6], new Class[7], new Class[8], new Class[9]};
    public static final Class[] NO_PARAMETERS = PARAM_COUNT[0];
    private final Object instance;
    private final Method method;
    private final Constructor constructor;
    private final int paramCount;
    private final Class varArgType;

    public static Class[] anyParameters(int count) {
        if (count < 0) {
            return ANY_PARAMETERS;
        }
        if (count == 0) {
            return NO_PARAMETERS;
        }
        return new Class[count];
    }

    static Class[] internAnyParameters(int count) {
        if (count < 0) {
            return ANY_PARAMETERS;
        }
        if (count < PARAM_COUNT.length) {
            return PARAM_COUNT[count];
        }
        return new Class[count];
    }

    public static ReflectiveProc newInstance(Class<?> clazz, Class ... paramTypes) {
        Constructor c = Signatures.bestConstructor(clazz, (Class[])paramTypes);
        if (c == null) {
            throw ReflectiveProc.notFound(clazz, null, paramTypes);
        }
        return new ReflectiveProc(c);
    }

    public static PN newInstanceWith(Class<?> clazz, Object ... args) {
        Constructor c = Signatures.bestConstructor(clazz, (Object[])args);
        if (c == null) {
            throw ReflectiveProc.notFound(clazz, null, args);
        }
        return (PN)new ReflectiveProc(c).call(args);
    }

    public static ReflectiveProc invoke(Class clazz, String name, Class ... paramTypes) {
        Method m = Signatures.bestMethod((Class)clazz, (String)name, (Class[])paramTypes);
        if (m == null) {
            throw ReflectiveProc.notFound(clazz, name, paramTypes);
        }
        return new ReflectiveProc(null, m);
    }

    public static ReflectiveProc invoke(Object object, String name, Class ... paramTypes) {
        Method m = Signatures.bestMethod(object.getClass(), (String)name, (Class[])paramTypes);
        if (m == null) {
            throw ReflectiveProc.notFound(object, name, paramTypes);
        }
        return new ReflectiveProc(object, m);
    }

    public static PN invokeWith(Class clazz, String name, Object ... args) {
        Method m = Signatures.bestMethod((Class)clazz, (String)name, (Object[])args);
        if (m == null) {
            throw ReflectiveProc.notFound(clazz, name, args);
        }
        return (PN)new ReflectiveProc(null, m).call(args);
    }

    public static PN invokeWith(Object object, String name, Object ... args) {
        Method m = Signatures.bestMethod(object.getClass(), (String)name, (Object[])args);
        if (m == null) {
            throw ReflectiveProc.notFound(object, name, args);
        }
        return (PN)new ReflectiveProc(object, m).call(args);
    }

    private static IllegalArgumentException notFound(Object owner, String name, Object[] args) {
        Class[] argTypes;
        if (args instanceof Class[]) {
            argTypes = (Class[])args;
        } else if (args == null) {
            argTypes = null;
        } else {
            argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object a = args[i];
                argTypes[i] = a == null ? null : a.getClass();
            }
        }
        String invokee = owner instanceof Class ? ((Class)owner).getName() : (owner == null ? "null" : owner.getClass().getName());
        String msg = ReflectiveProc.describeMethod(invokee, name, argTypes) + " not found";
        return new IllegalArgumentException(msg);
    }

    private static String describeMethod(String invokee, String method, Class[] paramTypes) {
        String paramString;
        if (paramTypes == null) {
            paramString = "<any args>";
        } else if (paramTypes.length == 0) {
            paramString = "";
        } else {
            StringBuilder sb = new StringBuilder();
            for (Class c : paramTypes) {
                sb.append(',');
                sb.append(c == null ? "<any>" : c.getName());
            }
            paramString = sb.substring(1);
        }
        String mName = String.format(method == null ? "new %s" : "%s#%s", invokee, method);
        return mName + "(" + paramString + ")";
    }

    public ReflectiveProc(Object instance, Method method) {
        super(ReflectiveProc.expectedArgCount(method, instance));
        this.name(ReflectiveProc.describeMethod(instance == null ? method.getDeclaringClass().getName() : instance.toString(), method.getName(), method.getParameterTypes()));
        if (instance == null && ReflectiveProc.isStatic(method)) {
            instance = method;
        }
        this.instance = instance;
        this.method = method;
        Class<?>[] params = method.getParameterTypes();
        this.paramCount = params.length;
        this.varArgType = method.isVarArgs() ? params[this.paramCount - 1] : null;
        this.constructor = null;
    }

    private static int expectedArgCount(Method method, Object instance) {
        if (method.isVarArgs()) {
            return -1;
        }
        return method.getParameterTypes().length + (instance != null || ReflectiveProc.isStatic(method) ? 0 : 1);
    }

    private static boolean isStatic(Method method) {
        return (method.getModifiers() & 8) != 0;
    }

    public ReflectiveProc(Constructor constructor) {
        super(ReflectiveProc.expectedArgCount(constructor));
        this.name(ReflectiveProc.describeMethod(constructor.getDeclaringClass().getName(), null, constructor.getParameterTypes()));
        this.instance = null;
        this.method = null;
        this.constructor = constructor;
        Class<?>[] params = constructor.getParameterTypes();
        this.paramCount = params.length;
        this.varArgType = constructor.isVarArgs() ? params[this.paramCount - 1] : null;
    }

    private static int expectedArgCount(Constructor constructor) {
        if (constructor.isVarArgs()) {
            return -1;
        }
        return constructor.getParameterTypes().length;
    }

    @Override
    protected Object runN(Object[] args) throws Throwable {
        if (this.constructor == null) {
            return this.invoke(args);
        }
        return this.newInstance(args);
    }

    private Object[] fixVarArgs(Object[] args) {
        return Signatures.fixVarArgs((int)this.paramCount, (Class)this.varArgType, (Object[])args);
    }

    private Object invoke(Object[] args) throws Throwable {
        Object result;
        boolean wasAccessible = this.method.isAccessible();
        if (!wasAccessible) {
            this.method.setAccessible(true);
        }
        try {
            Object obj;
            if (this.instance != null) {
                obj = this.instance;
            } else {
                obj = args[0];
                args = Arrays.copyOfRange(args, 1, args.length);
            }
            if (this.method.isVarArgs()) {
                args = this.fixVarArgs(args);
            }
            result = this.method.invoke(obj, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            if (!wasAccessible) {
                this.method.setAccessible(false);
            }
        }
        return result;
    }

    private Object newInstance(Object[] args) throws Throwable {
        Object result;
        boolean wasAccessible = this.constructor.isAccessible();
        if (!wasAccessible) {
            this.constructor.setAccessible(true);
        }
        try {
            if (this.constructor.isVarArgs()) {
                args = this.fixVarArgs(args);
            }
            result = this.constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            if (!wasAccessible) {
                this.constructor.setAccessible(false);
            }
        }
        return result;
    }
}

