/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.objects.instance;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cthul.objects.instance.DefaultInject;
import org.cthul.objects.instance.Initialize;
import org.cthul.objects.instance.Inject;

public class InstanceMap {
    protected static final Ambiguous AMBIGUOUS = new Ambiguous();
    public static final Class<?> ANY_INTERFACE = AnyInterface.class;
    public static final Class[] NO_LIMIT = null;
    public static final Class[] LIMIT_NO_INTERFACES = new Class[]{Object.class};
    public static final Class[] LIMIT_INTERFACES_ONLY = new Class[]{ANY_INTERFACE};
    private final Map<String, Object> map = new HashMap<String, Object>();
    private final Map<String, List<Property>> properties = new HashMap<String, List<Property>>();
    private final Set<Object> initializing = new HashSet<Object>();
    private final List<ObjectConfig> lateInits = new ArrayList<ObjectConfig>();
    protected static final String IS_INITIALIZING = " is currently initializing";
    protected static final Inject DEFAULT_INJECT = new Inject(){

        @Override
        public String value() {
            return "";
        }

        @Override
        public boolean create() {
            return false;
        }

        @Override
        public Class<?> impl() {
            return Void.class;
        }

        @Override
        public String factory() {
            return "";
        }

        @Override
        public boolean late() {
            return false;
        }

        @Override
        public boolean autoUpdate() {
            return true;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Inject.class;
        }
    };
    protected static final Inject NO_UPDATE = new Inject(){

        @Override
        public String value() {
            return "";
        }

        @Override
        public boolean create() {
            return false;
        }

        @Override
        public Class<?> impl() {
            return Void.class;
        }

        @Override
        public String factory() {
            return "";
        }

        @Override
        public boolean late() {
            return false;
        }

        @Override
        public boolean autoUpdate() {
            return false;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Inject.class;
        }
    };

    public InstanceMap() {
        this.put(this.getClass(), this, InstanceMap.class, ANY_INTERFACE);
    }

    protected InstanceMap(InstanceMap source) {
        this.map.putAll(source.map);
        this.properties.putAll(source.properties);
        this.replace(this.getClass(), this, InstanceMap.class, ANY_INTERFACE);
    }

    public Object put(String key, Object value) {
        Object old = this.map.put(key, value);
        this.updateProperties(key, value);
        return old;
    }

    protected final <T> T t_put(String key, Object value) {
        return (T)this.put(key, value);
    }

    protected void updateProperties(String key, Object value) {
        List<Property> l = this.properties.get(key);
        if (l != null && !l.isEmpty()) {
            if (this.isAmbiguous(value)) {
                throw new IllegalArgumentException("Auto-update failed: value for '" + key + "' is ambiguous");
            }
            for (Property p : l) {
                p.update(value);
            }
        }
    }

    protected void addAutoUpdated(String key, Property p) {
        List<Property> l = this.properties.get(key);
        if (l == null) {
            l = new ArrayList<Property>();
            this.properties.put(key, l);
        }
        l.add(p);
    }

    public Object put(Class<?> clazz, Object value, Class ... limit) {
        if (!this.checkLimit(clazz, limit)) {
            return value;
        }
        this.put(clazz.getSuperclass(), value, limit);
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            this.put(iface, value, limit);
            ++n2;
        }
        String key = this.key(clazz);
        Object old = this.unsafeGet(key);
        if (old != null && old != value) {
            if (!this.isAmbiguous(old)) {
                this.put(key, (Object)AMBIGUOUS);
            }
            return AMBIGUOUS;
        }
        return this.put(key, value);
    }

    public Object put(Class<?> clazz, Object value) {
        return this.put(clazz, value, NO_LIMIT);
    }

    public <T> T replace(Class<T> clazz, Object value, Class ... limit) {
        if (!this.checkLimit(clazz, limit)) {
            return null;
        }
        this.replace(clazz.getSuperclass(), value, limit);
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> i = classArray[n2];
            this.replace(i, value, limit);
            ++n2;
        }
        String key = this.key(clazz);
        return this.t_put(key, value);
    }

    public <T> T replace(Class<T> clazz, Object value) {
        return this.replace(clazz, value, NO_LIMIT);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean checkLimit(Class<?> clazz, Class[] limit) {
        if (clazz == null) {
            return false;
        }
        if (limit == null) {
            return true;
        }
        isInterface = clazz.isInterface();
        var7_4 = limit;
        var6_5 = limit.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            l = var7_4[var5_6];
            if (isInterface) {
                if (l != Object.class) {
                    if (l == AnyInterface.class) {
                        return true;
                    } else {
                        ** GOTO lbl-1000
                    }
                }
            } else if (l.isAssignableFrom(clazz)) {
                return true;
            }
            ++var5_6;
        }
        return false;
    }

    public Object get(String key) {
        Object v = this.unsafeGet(key);
        if (this.isAmbiguous(v)) {
            throw new IllegalArgumentException("Value for '" + key + "' is ambiguous");
        }
        this.ensureNotInitializing(v);
        return v;
    }

    protected final <T> T t_get(String key) {
        return (T)this.get(key);
    }

    protected Object unsafeGet(String key) {
        return this.map.get(key);
    }

    public <T> T get(Class<T> clazz) {
        return this.t_get(this.key(clazz));
    }

    public <T> T putNew(String key, Factory<? extends T> factory) {
        T t = factory.create(this);
        this.put(key, t);
        this.initialize(t);
        return t;
    }

    public <T> T putNew(Class<?> clazz, Factory<? extends T> factory) {
        T t = factory.create(this);
        this.put(clazz, t);
        this.initialize(t);
        return t;
    }

    public <T> T getOrCreate(String key, Factory<T> factory) {
        T t = this.t_get(key);
        if (t == null) {
            t = this.putNew(key, factory);
        }
        return t;
    }

    public <T> T getOrCreate(String key, Class<T> impl) {
        return this.getOrCreate(key, this.f(impl));
    }

    public <T> T getOrCreate(Class<T> clazz, Factory<? extends T> factory) {
        T t = this.get(clazz);
        if (t == null) {
            t = this.putNew(clazz, factory);
        }
        return t;
    }

    public <T> T getOrCreate(Class<T> clazz, Class<? extends T> impl) {
        T t = this.get(clazz);
        if (t == null) {
            t = this.putNew(clazz, this.f(impl));
        }
        return t;
    }

    public <T> T getOrCreate(Class<T> clazz) {
        return this.getOrCreate(clazz, clazz);
    }

    public <T> T get(Class<T> clazz, Inject inject) {
        String key = this.propertyKey(inject.value(), clazz);
        T t = this.t_get(key);
        if (t != null) {
            return t;
        }
        if (!this.propertyCreate(inject)) {
            return null;
        }
        Class<T> impl = this.propertyImpl(inject.impl(), clazz);
        Factory<T> f = this.propertyFactory(impl, inject.factory());
        if (inject.value().isEmpty()) {
            return this.putNew(clazz, f);
        }
        return this.putNew(key, f);
    }

    public Object remove(String key) {
        return this.put(key, null);
    }

    public <T> T remove(Class<T> clazz) {
        return this.remove(clazz, NO_LIMIT);
    }

    public <T> T remove(Class<T> clazz, Class ... limit) {
        T old = this.get(clazz);
        this.removeValue(old, clazz, limit);
        return old;
    }

    protected void removeValue(Object value, Class<?> clazz, Class ... limit) {
        if (!this.checkLimit(clazz, limit)) {
            return;
        }
        this.removeValue(value, clazz.getSuperclass(), limit);
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            this.removeValue(value, iface, limit);
            ++n2;
        }
        String key = this.key(clazz);
        if (this.unsafeGet(key) == value) {
            this.put(key, null);
        }
    }

    protected String key(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return clazz.getCanonicalName();
    }

    protected <T> Factory<T> f(Class<T> clazz) {
        Inject inject = clazz.getAnnotation(Inject.class);
        if (inject != null) {
            return new InjectFactory<T>(clazz, inject);
        }
        return new ReflectiveFactory<T>(clazz);
    }

    protected boolean isAmbiguous(Object v) {
        return v instanceof Ambiguous;
    }

    public <T> T initialize(T o) {
        if (!this.initializing.add(o)) {
            throw new IllegalArgumentException("Circular dependency at " + o + ", " + "try defining some properties as `late`");
        }
        try {
            try {
                ObjectConfig config = this.config(o);
                for (Init i : config.injects) {
                    i.init(this);
                }
                for (Init i : config.inits) {
                    i.init(this);
                }
                if (!config.lateInits.isEmpty() || !config.lateInjects.isEmpty()) {
                    this.lateInits.add(config);
                }
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().endsWith(IS_INITIALIZING)) {
                    throw new IllegalArgumentException("Circular dependency at " + o + ", " + "try defining some properties as `late`");
                }
                throw e;
            }
        }
        finally {
            this.initializing.remove(o);
            if (this.initializing.isEmpty()) {
                this.lateInitialize();
            }
        }
        return o;
    }

    protected void lateInitialize() {
        for (ObjectConfig oc : this.lateInits) {
            for (Init i : oc.lateInjects) {
                i.init(this);
            }
            for (Init i : oc.lateInits) {
                i.init(this);
            }
        }
        this.lateInits.clear();
    }

    protected void ensureNotInitializing(Object o) {
        if (this.initializing.contains(o)) {
            throw new IllegalArgumentException(o + IS_INITIALIZING);
        }
    }

    protected ObjectConfig config(Object o) {
        ObjectConfig config = new ObjectConfig();
        this.collectFields(config, o);
        this.collectMethods(config, o);
        return config;
    }

    protected void collectFields(ObjectConfig config, Object o) {
        Class<?> clazz = o.getClass();
        Inject classInject = this.defaultInject(clazz);
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Init i;
            Field f = fieldArray[n2];
            Inject inject = f.getAnnotation(Inject.class);
            Initialize init = f.getAnnotation(Initialize.class);
            if (inject != null) {
                if (init != null) {
                    inject = InstanceMap.merge(inject, NO_UPDATE);
                }
                i = this.collectField(config, o, f, InstanceMap.merge(inject, classInject));
                this.addInject(i, config, inject.late());
            } else if (init != null) {
                i = this.collectField(config, o, f, init);
                this.addInit(i, config, init.late());
            }
            ++n2;
        }
    }

    protected Init collectField(ObjectConfig config, Object o, Field f, Inject inject) {
        String key = this.propertyKey(inject.value(), f.getType());
        FieldProperty prop = new FieldProperty(o, f);
        if (inject.autoUpdate()) {
            this.addAutoUpdated(key, prop);
        }
        return new PropertyInit(prop, inject, f.getType());
    }

    protected Init collectField(ObjectConfig config, Object o, Field f, Initialize init) {
        return new FieldValueInit(o, f);
    }

    protected void collectMethods(ObjectConfig config, Object o) {
        Class<?> clazz = o.getClass();
        Inject classInject = this.defaultInject(clazz);
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Initialize init;
            Method m = methodArray[n2];
            Inject inject = m.getAnnotation(Inject.class);
            if (inject != null) {
                this.collectMethod(config, o, m, InstanceMap.merge(inject, classInject));
            }
            if ((init = m.getAnnotation(Initialize.class)) != null) {
                this.collectMethod(config, o, m, init, classInject);
            }
            ++n2;
        }
    }

    protected void collectMethod(ObjectConfig config, Object o, Method m, Inject inject) {
        SetterInit init = this.collectParams(o, m, inject, false);
        this.addInject(init, config, inject.late());
    }

    protected void collectMethod(ObjectConfig config, Object o, Method m, Initialize initialize, Inject classInject) {
        SetterInit init = this.collectParams(o, m, InstanceMap.merge(NO_UPDATE, classInject), true);
        this.addInit(init, config, initialize.late());
    }

    protected SetterInit collectParams(Object o, Method m, Inject mInject, boolean initResult) {
        SetterInit init = new SetterInit(o, m, initResult);
        Annotation[][] paramAts = m.getParameterAnnotations();
        Class<?>[] paramCls = m.getParameterTypes();
        int i = 0;
        while (i < paramAts.length) {
            Inject pInject = null;
            Annotation[] annotationArray = paramAts[i];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation at = annotationArray[n2];
                if (at instanceof Inject) {
                    pInject = (Inject)at;
                }
                ++n2;
            }
            pInject = pInject == null ? mInject : this.paramMerge(pInject, mInject, m, i);
            this.collectParam(init, o, m, pInject, i, paramAts[i], paramCls[i]);
            ++i;
        }
        return init;
    }

    protected Inject paramMerge(Inject param, Inject method, Method m, int pId) {
        if (param.late() && !method.late()) {
            throw new IllegalArgumentException("Parameter " + pId + " of " + m + " is flagged as lazy, " + "but method is not.");
        }
        return InstanceMap.merge(param, method);
    }

    protected void collectParam(SetterInit init, Object o, Method m, Inject inject, int paramId, Annotation[] ats, Class<?> type) {
        String key = this.propertyKey(inject.value(), type);
        ParamProperty prop = new ParamProperty(o, m, paramId);
        init.addParameter(prop, type, inject);
        if (inject.autoUpdate()) {
            this.addAutoUpdated(key, prop);
        }
    }

    protected String propertyKey(String key, Class<?> clazz) {
        if (key != null && !key.isEmpty()) {
            return key;
        }
        return this.key(clazz);
    }

    protected boolean propertyCreate(Inject inject) {
        return inject.create() || inject.impl() != Void.class || !inject.factory().isEmpty();
    }

    protected <T> Class<T> propertyImpl(Class<?> impl, Class<?> clazz) {
        if (impl != Void.class) {
            return impl;
        }
        return clazz;
    }

    protected <T> Factory<T> propertyFactory(Class<T> impl, String factory) {
        if (factory == null || factory.isEmpty()) {
            return new ReflectiveFactory<T>(impl);
        }
        return new ReflectiveProxyFactory<T>(impl, factory);
    }

    protected void addInject(Init init, ObjectConfig config, boolean late) {
        if (late) {
            config.lateInjects.add(init);
        } else {
            config.injects.add(init);
        }
    }

    protected void addInit(Init init, ObjectConfig config, boolean late) {
        if (late) {
            config.lateInits.add(init);
        } else {
            config.inits.add(init);
        }
    }

    public static Object getFactory(Class<?> clazz, String factory) {
        try {
            Field f = clazz.getField(factory);
            InstanceMap.checkAccess(f.getModifiers(), factory);
            return f.get(null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Error accessing " + clazz + "#" + factory, e);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            try {
                Method m = clazz.getMethod(factory, new Class[0]);
                InstanceMap.checkAccess(m.getModifiers(), factory);
                return m.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException("Error invoking " + clazz + "#" + factory + "()", e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException(clazz + " has no member " + factory);
            }
        }
    }

    private static void checkAccess(int modifier, String factory) throws IllegalArgumentException {
        if ((modifier & 1) == 0) {
            throw new IllegalArgumentException(String.valueOf(factory) + " is not public");
        }
        if ((modifier & 8) == 0) {
            throw new IllegalArgumentException(String.valueOf(factory) + " is not static");
        }
    }

    protected Inject defaultInject(Class<?> clazz) {
        Inject classInject = null;
        DefaultInject def = clazz.getAnnotation(DefaultInject.class);
        if (def != null) {
            classInject = def.value();
        }
        return classInject;
    }

    protected static Inject merge(final Inject inject, final Inject base) {
        if (base == null || base == DEFAULT_INJECT) {
            if (inject == null) {
                return DEFAULT_INJECT;
            }
            return inject;
        }
        if (inject == null || inject == DEFAULT_INJECT) {
            return base;
        }
        return new Inject(){

            private boolean isValue(String s) {
                return s != null && !s.isEmpty();
            }

            @Override
            public String value() {
                String v = inject.value();
                return this.isValue(v) ? v : base.value();
            }

            @Override
            public boolean create() {
                return inject.create() || base.create();
            }

            @Override
            public Class<?> impl() {
                Class<?> i = inject.impl();
                return i != Void.class ? i : base.impl();
            }

            @Override
            public String factory() {
                String f = inject.factory();
                return this.isValue(f) ? f : base.factory();
            }

            @Override
            public boolean late() {
                return inject.late() || base.late();
            }

            @Override
            public boolean autoUpdate() {
                return inject.autoUpdate() && base.autoUpdate();
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return Inject.class;
            }
        };
    }

    protected static class Ambiguous
    implements Serializable {
        protected Ambiguous() {
        }
    }

    public static interface AnyInterface {
    }

    public static interface Factory<T> {
        public T create(InstanceMap var1);
    }

    protected static class FieldProperty
    extends Property {
        protected final Object instance;
        protected final Field field;

        public FieldProperty(Object instance, Field field) {
            this.instance = instance;
            this.field = field;
        }

        @Override
        public void update(Object newValue) {
            if (!this.isInitialized()) {
                return;
            }
            try {
                this.field.set(this.instance, newValue);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static class FieldValueInit
    extends Init {
        protected final Object o;
        protected final Field f;

        public FieldValueInit(Object o, Field f) {
            this.o = o;
            this.f = f;
        }

        @Override
        public void init(InstanceMap map) {
            try {
                map.initialize(this.f.get(this.o));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static abstract class Init {
        protected Init() {
        }

        public abstract void init(InstanceMap var1);
    }

    public class InjectFactory<T>
    implements Factory<T> {
        protected final Class<T> clazz;
        protected final Inject inject;

        public InjectFactory(Class<T> clazz, Inject inject) {
            this.clazz = clazz;
            this.inject = inject;
        }

        @Override
        public T create(InstanceMap map) {
            String f;
            Object t;
            if (this.inject.late()) {
                throw this.unsupportedOption("late");
            }
            if (this.inject.create()) {
                throw this.unsupportedOption("create");
            }
            if (!this.inject.autoUpdate()) {
                throw this.unsupportedOption("autoUpdate");
            }
            String key = this.inject.value();
            if (key != null && (t = map.get(key)) != null) {
                return (T)t;
            }
            Class<Object> impl = this.inject.impl();
            if (impl == Void.class) {
                impl = this.clazz;
            }
            if ((f = this.inject.factory()).isEmpty()) {
                return (T)new ReflectiveFactory(impl).create(map);
            }
            return (T)new ReflectiveProxyFactory(impl, f).create(map);
        }

        protected IllegalArgumentException unsupportedOption(String name) {
            return new IllegalArgumentException("Unsupported option in " + this.clazz.getName() + ": @Inject(" + name + ")");
        }
    }

    protected static class InjectedParameters {
        protected final List<Inject> paramInjects = new ArrayList<Inject>();
        protected final List<Class<?>> paramTypes = new ArrayList();

        protected InjectedParameters() {
        }

        protected void addParameter(Class<?> type, Inject inject) {
            this.paramTypes.add(type);
            this.paramInjects.add(inject);
        }

        public Object[] getArguments(InstanceMap map) {
            int paramCount = this.paramTypes.size();
            if (paramCount == 0) {
                return null;
            }
            Object[] args = new Object[paramCount];
            int i = 0;
            while (i < paramCount) {
                args[i] = this.getArgument(map, i);
                ++i;
            }
            return args;
        }

        public Object getArgument(InstanceMap map, int i) {
            return map.get(this.paramTypes.get(i), this.paramInjects.get(i));
        }
    }

    protected class ObjectConfig {
        protected final List<Init> injects = new ArrayList<Init>();
        protected final List<Init> inits = new ArrayList<Init>();
        protected final List<Init> lateInjects = new ArrayList<Init>();
        protected final List<Init> lateInits = new ArrayList<Init>();

        protected ObjectConfig() {
        }
    }

    protected static class ParamProperty
    extends Property {
        protected final Object instance;
        protected final Method method;
        protected final int paramCount;
        protected final int paramId;

        public ParamProperty(Object instance, Method method, int paramId) {
            this.instance = instance;
            this.method = method;
            this.paramId = paramId;
            this.paramCount = method.getParameterTypes().length;
        }

        @Override
        public void update(Object newValue) {
            if (!this.isInitialized()) {
                return;
            }
            try {
                Object[] args = new Object[this.paramCount];
                args[this.paramId] = newValue;
                this.method.invoke(this.instance, args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static abstract class Property {
        private boolean initialized = false;

        protected Property() {
        }

        protected boolean isInitialized() {
            return this.initialized;
        }

        public abstract void update(Object var1);
    }

    protected static class PropertyInit
    extends Init {
        protected final Property prop;
        protected final Inject inject;
        protected final Class<?> clazz;

        public PropertyInit(Property prop, Inject inject, Class<?> clazz) {
            this.prop = prop;
            this.inject = inject;
            this.clazz = clazz;
        }

        @Override
        public void init(InstanceMap map) {
            Object value = this.getInitialValue(map);
            this.prop.initialized = true;
            if (value != null) {
                this.prop.update(value);
            }
        }

        protected Object getInitialValue(InstanceMap map) {
            return map.get(this.clazz, this.inject);
        }
    }

    public class ReflectiveFactory<T>
    implements Factory<T> {
        protected final Constructor<T> constructor;
        protected final InjectedParameters ip;

        public ReflectiveFactory(Constructor<T> c, InjectedParameters ip) {
            this.constructor = c;
            this.ip = ip;
        }

        public ReflectiveFactory(Class<T> clazz) {
            this.constructor = this.selectConstructor(clazz);
            this.ip = this.initializeParameters(this.constructor);
        }

        private Constructor<T> selectConstructor(Class<T> clazz) {
            Constructor<?> choice = null;
            Constructor<?> ambiguous = null;
            boolean choiceIsAnnotated = false;
            int choiceParamC = -1;
            Constructor<?>[] constructorArray = clazz.getConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> c = constructorArray[n2];
                if (c.getAnnotation(Inject.class) != null) {
                    if (choiceIsAnnotated) {
                        throw this.ambiguous(choice, c);
                    }
                    choice = c;
                    choiceIsAnnotated = true;
                } else if (!choiceIsAnnotated) {
                    if (choice == null) {
                        choice = c;
                        choiceParamC = c.getParameterTypes().length;
                    } else if (c.getParameterTypes().length == 0) {
                        choice = c;
                        choiceParamC = 0;
                    } else {
                        ambiguous = c;
                    }
                }
                ++n2;
            }
            if (choiceParamC > 0 && ambiguous != null && !choiceIsAnnotated) {
                throw this.ambiguous(choice, ambiguous);
            }
            if (choice == null) {
                throw new IllegalArgumentException("No suitable constructor for: " + clazz);
            }
            return choice;
        }

        private IllegalArgumentException ambiguous(Constructor<?> c1, Constructor<?> c2) {
            return new IllegalArgumentException("Multiple possible constructors: " + c1 + " and " + c2);
        }

        private InjectedParameters initializeParameters(Constructor<T> c) {
            Class<?>[] pTypes = c.getParameterTypes();
            if (pTypes.length == 0) {
                return null;
            }
            Annotation[][] pAts = c.getParameterAnnotations();
            Inject classInject = InstanceMap.this.defaultInject(c.getDeclaringClass());
            Inject cInject = InstanceMap.merge(c.getAnnotation(Inject.class), classInject);
            InjectedParameters params = new InjectedParameters();
            int i = 0;
            while (i < pTypes.length) {
                Inject pInject = null;
                Annotation[] annotationArray = pAts[i];
                int n = annotationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation at = annotationArray[n2];
                    if (at instanceof Inject) {
                        pInject = (Inject)at;
                    }
                    ++n2;
                }
                pInject = InstanceMap.merge(pInject, cInject);
                params.addParameter(pTypes[i], pInject);
                ++i;
            }
            return params;
        }

        @Override
        public T create(InstanceMap map) {
            try {
                Object[] args = this.ip != null ? this.ip.getArguments(map) : null;
                return this.constructor.newInstance(args);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class ReflectiveProxyFactory<T>
    implements Factory<T> {
        protected final Class<T> clazz;
        protected final String factory;

        public ReflectiveProxyFactory(Class<T> clazz, String factory) {
            this.clazz = clazz;
            this.factory = factory;
        }

        @Override
        public T create(InstanceMap map) {
            Object o = InstanceMap.getFactory(this.clazz, this.factory);
            if (o instanceof Factory) {
                return ((Factory)o).create(map);
            }
            return (T)o;
        }
    }

    protected static class SetterInit
    extends Init {
        protected final List<ParamProperty> params = new ArrayList<ParamProperty>();
        protected final InjectedParameters ip = new InjectedParameters();
        protected final Object instance;
        protected final Method method;
        protected final boolean initResult;

        public SetterInit(Object instance, Method method, boolean initResult) {
            this.instance = instance;
            this.method = method;
            this.initResult = initResult;
        }

        protected void addParameter(ParamProperty pp, Class<?> type, Inject inject) {
            this.params.add(pp);
            this.ip.addParameter(type, inject);
        }

        @Override
        public void init(InstanceMap map) {
            Object[] args = this.ip.getArguments(map);
            try {
                Object object = this.method.invoke(this.instance, args);
                if (object != null && this.initResult) {
                    map.initialize(object);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
            for (Property property : this.params) {
                property.initialized = true;
            }
        }
    }
}

