/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.objects.instance;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.cthul.objects.Boxing;
import org.cthul.objects.instance.Arg;
import org.cthul.objects.instance.Instance;
import org.cthul.objects.instance.InstanceMap;
import org.cthul.objects.reflection.Signatures;

public class Instances {
    public static Object newInstance(Instance inst) {
        return Instances.getInstance(null, inst);
    }

    public static Object getInstance(InstanceMap map, Instance inst) {
        return Instances.getInstance(map, inst.key(), inst.impl(), inst.factory(), null);
    }

    public static Object[] getInstances(InstanceMap map, Instance[] inst) {
        Object[] result = new Object[inst.length];
        int i = 0;
        while (i < result.length) {
            result[i] = Instances.getInstance(map, inst[i]);
            ++i;
        }
        return result;
    }

    public static Object newInstance(Class<?> impl, String factory, Arg[] args) {
        return Instances.getInstance(null, null, impl, factory, args);
    }

    public static Object newInstance(Class<?> impl, String factory, Arg[] args, Object[] moreValues) {
        return Instances.getInstance(null, null, impl, factory, args, moreValues);
    }

    public static Object getInstance(InstanceMap map, String key, Class<?> impl, String factory, Arg[] args) {
        return Instances.getInstance(map, key, impl, factory, args, null);
    }

    public static Object getInstance(InstanceMap map, String key, Class<?> impl, String factory, Arg[] args, Object[] moreValues) {
        Object o;
        if (map != null && (!Instances.isDefault(key, "") ? (o = map.get(key)) != null : Instances.isDefault(factory, "") && Instances.isEmpty(args) && (o = map.get(impl)) != null)) {
            return o;
        }
        if (args == null) {
            return Instances.newInstance(map, impl, factory, null, moreValues);
        }
        Object[] argValues = new Object[Instances.lengthOf(args)];
        Class[] argTypes = new Class[argValues.length];
        Instances.fillArgs(map, args, argValues, argTypes, moreValues);
        return Instances.newInstance(map, impl, factory, argTypes, argValues);
    }

    public static void fillArgs(InstanceMap map, Arg[] args, Object[] values, Class[] types, Object[] moreValues) {
        if (Instances.isEmpty(args)) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            Instances.fillArg(map, args, i, values, types, moreValues);
            ++i;
        }
    }

    private static void fillArg(InstanceMap map, Arg[] args, int i, Object[] values, Class[] types, Object[] moreValues) {
        Class<?> argType;
        Object[] prims;
        int index;
        int j;
        Arg a = args[i];
        Object value = null;
        Class<Object> type = null;
        boolean storeValue = false;
        if (!Instances.isDefault(a.key(), "")) {
            if (map != null) {
                value = map.get(a.key());
                if (value != null) {
                    type = value.getClass();
                    storeValue = true;
                }
            } else if (moreValues != null) {
                String[] keys = a.key().split(",");
                Object[] v = new Object[keys.length];
                try {
                    j = 0;
                    while (j < keys.length) {
                        index = Integer.parseInt(keys[j]);
                        v[j] = moreValues[index];
                        ++j;
                    }
                    value = v;
                    type = Object[].class;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        Object[] objectArray = prims = new Object[]{a.x(), a.b(), a.c(), a.d(), a.f(), a.i(), a.l(), a.s(), a.str(), a.o()};
        index = prims.length;
        j = 0;
        while (j < index) {
            Object[] p = objectArray[j];
            if (!Instances.isEmpty(p)) {
                if (type != null) {
                    throw new IllegalArgumentException("Ambiguous @Arg, got " + type.getSimpleName() + " and " + p.getClass().getSimpleName());
                }
                if (p instanceof Instance[]) {
                    p = Instances.getInstances(map, (Instance[])p);
                }
                value = p;
                type = value.getClass();
            }
            ++j;
        }
        Class<?> compType = a.arrayOf();
        if (compType == Void.TYPE && value != null) {
            int l = Instances.lengthOf(value);
            if (l == 1) {
                type = (value = Array.get(value, 0)) != null ? value.getClass() : null;
            }
        } else if (value == null) {
            value = Array.newInstance(compType, 0);
            type = value.getClass();
        } else if (Boxing.boxingType(compType) != null) {
            type = Array.newInstance(compType, 0).getClass();
            value = Boxing.as(value, type);
        } else {
            Class<?> t = Array.newInstance(compType, 0).getClass();
            Object[] src = (Object[])value;
            type = t;
            value = Arrays.copyOf(src, src.length, t);
        }
        if ((argType = a.type()) != Void.TYPE) {
            type = argType;
        }
        values[i] = value;
        types[i] = type;
        if (map != null && storeValue) {
            map.put(a.key(), value);
        }
    }

    public static Class[] getTypes(InstanceMap map, Arg[] args, Class[] inputTypes) {
        Class[] result = new Class[args.length];
        int i = 0;
        while (i < result.length) {
            result[i] = Instances.getType(map, args[i], inputTypes);
            ++i;
        }
        return result;
    }

    private static Class getType(InstanceMap map, Arg a, Class[] inputTypes) {
        Object[] prims;
        Class<?> compType;
        if (!Instances.isDefault(a.key(), "")) {
            if (map != null) {
                return map.get(a.key()).getClass();
            }
            if (inputTypes != null) {
                String[] keys = a.key().split(",");
                if (keys.length > 1) {
                    return Object[].class;
                }
                try {
                    int i = Integer.parseInt(keys[0]);
                    return inputTypes[i];
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        if ((compType = a.arrayOf()) != Void.TYPE && compType != null) {
            return Array.newInstance(compType, 0).getClass();
        }
        Object[] objectArray = prims = new Object[]{a.x(), a.b(), a.c(), a.d(), a.f(), a.i(), a.l(), a.s(), a.str(), a.o()};
        int n = prims.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] p = objectArray[n2];
            if (!Instances.isEmpty(p)) {
                if (p instanceof Instance[]) {
                    p = Instances.getInstances(map, (Instance[])p);
                }
                if (Array.getLength(p) == 1) {
                    return p.getClass().getComponentType();
                }
                return p.getClass();
            }
            ++n2;
        }
        return null;
    }

    public static Object[] getArgs(InstanceMap map, Arg[] args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static int lengthOf(Object array) {
        return array == null ? 0 : Array.getLength(array);
    }

    private static boolean isEmpty(Object array) {
        return array == null || Array.getLength(array) == 0;
    }

    private static boolean isDefault(Object value, Object def) {
        return value == null || value.equals(def);
    }

    private static boolean isStatic(Method m) {
        return (m.getModifiers() & 8) != 0;
    }

    private static boolean isStatic(Field f) {
        return (f.getModifiers() & 8) != 0;
    }

    public static Object newInstance(Class<?> impl, String factory, Class[] argTypes, Object[] argValues) {
        return Instances.newInstance(null, impl, factory, argTypes, argValues);
    }

    private static Object newInstance(InstanceMap map, Class<?> impl, String factory, Class[] argTypes, Object[] argValues) {
        Object f2;
        int n;
        int n2;
        Object[] objectArray;
        Method m;
        boolean useConstructor;
        boolean useMethod;
        if (Instances.isDefault(factory, "")) {
            useMethod = true;
            useConstructor = true;
        } else if (factory.equals("new")) {
            useConstructor = true;
            useMethod = false;
        } else {
            useConstructor = false;
            useMethod = true;
        }
        if (useConstructor) {
            Constructor<?> c = argTypes != null ? Signatures.bestConstructor(impl, argTypes) : Signatures.bestConstructor(impl, argValues);
            if (c == null && !useMethod) {
                throw new IllegalArgumentException("No suitable constructor in " + impl);
            }
            if (c != null) {
                try {
                    c.setAccessible(true);
                    return c.newInstance(argValues);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (Instances.isDefault(factory, "")) {
            m = null;
            String[] methods = new String[]{"instance", "newInstance", "getInstance"};
            objectArray = methods;
            n2 = methods.length;
            n = 0;
            while (n < n2) {
                Object name = objectArray[n];
                m = argTypes != null ? Signatures.bestMethod(impl, (String)name, argTypes) : Signatures.bestMethod(impl, (String)name, argValues);
                if (m == null) {
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            m = argTypes != null ? Signatures.bestMethod(impl, factory, argTypes) : Signatures.bestMethod(impl, factory, argValues);
        }
        if (m != null) {
            Object factoryInstance = null;
            if (!Instances.isStatic(m)) {
                if (map == null) {
                    throw new IllegalArgumentException("InstanceMap required to get factory instance: " + impl);
                }
                factoryInstance = map.getOrCreate(impl);
            }
            try {
                m.setAccessible(true);
                return m.invoke(factoryInstance, argValues);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        Object f = null;
        if (Instances.isDefault(factory, "")) {
            objectArray = impl.getDeclaredFields();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                f2 = objectArray[n];
                if (((Field)f2).getName().equalsIgnoreCase("instance")) {
                    f = f2;
                    break;
                }
                ++n;
            }
        } else {
            objectArray = impl.getDeclaredFields();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                f2 = objectArray[n];
                if (((Field)f2).getName().equals(factory)) {
                    f = f2;
                    break;
                }
                ++n;
            }
        }
        if (f != null) {
            Object factoryInstance = null;
            if (!Instances.isStatic(f)) {
                if (map == null) {
                    throw new IllegalArgumentException("InstanceMap required to get factory instance: " + impl);
                }
                factoryInstance = map.getOrCreate(impl);
            }
            if (!Instances.isEmpty(argValues)) {
                throw new IllegalArgumentException("No args allowed for field " + f);
            }
            try {
                ((Field)f).setAccessible(true);
                return ((Field)f).get(factoryInstance);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        if (useConstructor) {
            throw new IllegalArgumentException("No suitable constructor or factory in " + impl);
        }
        throw new IllegalArgumentException("No suitable factory '" + factory + "' in " + impl);
    }
}

