/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.objects.internal;

import java.util.Collection;

public class BoxingBase {
    public static boolean unboxBoolean(Object b) {
        if (b instanceof Boolean) {
            return (Boolean)b;
        }
        if (b instanceof Number) {
            return ((Number)b).doubleValue() > 0.0;
        }
        if (b instanceof Character) {
            return ((Character)b).charValue() > '\u0000';
        }
        throw new IllegalArgumentException(String.valueOf(b));
    }

    public static byte unboxByte(Object b) {
        if (b instanceof Number) {
            return ((Number)b).byteValue();
        }
        if (b instanceof Character) {
            return (byte)((Character)b).charValue();
        }
        if (b instanceof Boolean) {
            return (byte)((Boolean)b != false ? 1 : 0);
        }
        throw new IllegalArgumentException(String.valueOf(b));
    }

    public static char unboxCharacter(Object b) {
        if (b instanceof Character) {
            return ((Character)b).charValue();
        }
        if (b instanceof Number) {
            return (char)((Number)b).intValue();
        }
        if (b instanceof Boolean) {
            return (Boolean)b != false ? (char)'\u0001' : '\u0000';
        }
        throw new IllegalArgumentException(String.valueOf(b));
    }

    public static float unboxFloat(Object b) {
        if (b instanceof Number) {
            return ((Number)b).floatValue();
        }
        if (b instanceof Character) {
            return ((Character)b).charValue();
        }
        if (b instanceof Boolean) {
            return (Boolean)b != false ? 1 : 0;
        }
        throw new IllegalArgumentException(String.valueOf(b));
    }

    public static double unboxDouble(Object b) {
        if (b instanceof Number) {
            return ((Number)b).doubleValue();
        }
        if (b instanceof Character) {
            return ((Character)b).charValue();
        }
        if (b instanceof Boolean) {
            return (Boolean)b != false ? 1 : 0;
        }
        throw new IllegalArgumentException(String.valueOf(b));
    }

    public static int unboxInteger(Object b) {
        if (b instanceof Number) {
            return ((Number)b).intValue();
        }
        if (b instanceof Character) {
            return ((Character)b).charValue();
        }
        if (b instanceof Boolean) {
            return (Boolean)b != false ? 1 : 0;
        }
        throw new IllegalArgumentException(String.valueOf(b));
    }

    public static long unboxLong(Object b) {
        if (b instanceof Number) {
            return ((Number)b).longValue();
        }
        if (b instanceof Character) {
            return ((Character)b).charValue();
        }
        if (b instanceof Boolean) {
            return (Boolean)b != false ? 1 : 0;
        }
        throw new IllegalArgumentException(String.valueOf(b));
    }

    public static short unboxShort(Object b) {
        if (b instanceof Number) {
            return ((Number)b).shortValue();
        }
        if (b instanceof Character) {
            return (short)((Character)b).charValue();
        }
        if (b instanceof Boolean) {
            return (short)((Boolean)b != false ? 1 : 0);
        }
        throw new IllegalArgumentException(String.valueOf(b));
    }

    public static boolean[] unboxBooleans(Array src, int srcPos, int len) {
        if (len < 0) {
            len = src.length() - srcPos + len + 1;
        }
        boolean[] result = new boolean[len];
        int i = 0;
        while (i < len) {
            result[i] = src.getBooleanValue(srcPos + i);
            ++i;
        }
        return result;
    }

    public static boolean[] unboxBooleans(Object[] src, int srcPos, int len) {
        if (len < 0) {
            len = src.length - srcPos + len + 1;
        }
        boolean[] result = new boolean[len];
        int i = 0;
        while (i < len) {
            result[i] = BoxingBase.unboxBoolean(src[srcPos + i]);
            ++i;
        }
        return result;
    }

    public static byte[] unboxBytes(Array src, int srcPos, int len) {
        if (len < 0) {
            len = src.length() - srcPos + len + 1;
        }
        byte[] result = new byte[len];
        int i = 0;
        while (i < len) {
            result[i] = src.getByteValue(srcPos + i);
            ++i;
        }
        return result;
    }

    public static byte[] unboxBytes(Object[] src, int srcPos, int len) {
        if (len < 0) {
            len = src.length - srcPos + len + 1;
        }
        byte[] result = new byte[len];
        int i = 0;
        while (i < len) {
            result[i] = BoxingBase.unboxByte(src[srcPos + i]);
            ++i;
        }
        return result;
    }

    public static char[] unboxCharacters(Array src, int srcPos, int len) {
        if (len < 0) {
            len = src.length() - srcPos + len + 1;
        }
        char[] result = new char[len];
        int i = 0;
        while (i < len) {
            result[i] = src.getCharacterValue(srcPos + i);
            ++i;
        }
        return result;
    }

    public static char[] unboxCharacters(Object[] src, int srcPos, int len) {
        if (len < 0) {
            len = src.length - srcPos + len + 1;
        }
        char[] result = new char[len];
        int i = 0;
        while (i < len) {
            result[i] = BoxingBase.unboxCharacter(src[srcPos + i]);
            ++i;
        }
        return result;
    }

    public static float[] unboxFloats(Array src, int srcPos, int len) {
        if (len < 0) {
            len = src.length() - srcPos + len + 1;
        }
        float[] result = new float[len];
        int i = 0;
        while (i < len) {
            result[i] = src.getFloatValue(srcPos + i);
            ++i;
        }
        return result;
    }

    public static float[] unboxFloats(Object[] src, int srcPos, int len) {
        if (len < 0) {
            len = src.length - srcPos + len + 1;
        }
        float[] result = new float[len];
        int i = 0;
        while (i < len) {
            result[i] = BoxingBase.unboxFloat(src[srcPos + i]);
            ++i;
        }
        return result;
    }

    public static double[] unboxDoubles(Array src, int srcPos, int len) {
        if (len < 0) {
            len = src.length() - srcPos + len + 1;
        }
        double[] result = new double[len];
        int i = 0;
        while (i < len) {
            result[i] = src.getDoubleValue(srcPos + i);
            ++i;
        }
        return result;
    }

    public static double[] unboxDoubles(Object[] src, int srcPos, int len) {
        if (len < 0) {
            len = src.length - srcPos + len + 1;
        }
        double[] result = new double[len];
        int i = 0;
        while (i < len) {
            result[i] = BoxingBase.unboxDouble(src[srcPos + i]);
            ++i;
        }
        return result;
    }

    public static int[] unboxIntegers(Array src, int srcPos, int len) {
        if (len < 0) {
            len = src.length() - srcPos + len + 1;
        }
        int[] result = new int[len];
        int i = 0;
        while (i < len) {
            result[i] = src.getIntegerValue(srcPos + i);
            ++i;
        }
        return result;
    }

    public static int[] unboxIntegers(Object[] src, int srcPos, int len) {
        if (len < 0) {
            len = src.length - srcPos + len + 1;
        }
        int[] result = new int[len];
        int i = 0;
        while (i < len) {
            result[i] = BoxingBase.unboxInteger(src[srcPos + i]);
            ++i;
        }
        return result;
    }

    public static long[] unboxLongs(Array src, int srcPos, int len) {
        if (len < 0) {
            len = src.length() - srcPos + len + 1;
        }
        long[] result = new long[len];
        int i = 0;
        while (i < len) {
            result[i] = src.getLongValue(srcPos + i);
            ++i;
        }
        return result;
    }

    public static long[] unboxLongs(Object[] src, int srcPos, int len) {
        if (len < 0) {
            len = src.length - srcPos + len + 1;
        }
        long[] result = new long[len];
        int i = 0;
        while (i < len) {
            result[i] = BoxingBase.unboxLong(src[srcPos + i]);
            ++i;
        }
        return result;
    }

    public static short[] unboxShorts(Array src, int srcPos, int len) {
        if (len < 0) {
            len = src.length() - srcPos + len + 1;
        }
        short[] result = new short[len];
        int i = 0;
        while (i < len) {
            result[i] = src.getShortValue(srcPos + i);
            ++i;
        }
        return result;
    }

    public static short[] unboxShorts(Object[] src, int srcPos, int len) {
        if (len < 0) {
            len = src.length - srcPos + len + 1;
        }
        short[] result = new short[len];
        int i = 0;
        while (i < len) {
            result[i] = BoxingBase.unboxShort(src[srcPos + i]);
            ++i;
        }
        return result;
    }

    public static boolean[] unboxBooleans(Object[] src) {
        return BoxingBase.unboxBooleans(src, 0, -1);
    }

    public static byte[] unboxBytes(Object[] src) {
        return BoxingBase.unboxBytes(src, 0, -1);
    }

    public static char[] unboxCharacters(Object[] src) {
        return BoxingBase.unboxCharacters(src, 0, -1);
    }

    public static float[] unboxFloats(Object[] src) {
        return BoxingBase.unboxFloats(src, 0, -1);
    }

    public static double[] unboxDoubles(Object[] src) {
        return BoxingBase.unboxDoubles(src, 0, -1);
    }

    public static int[] unboxIntegers(Object[] src) {
        return BoxingBase.unboxIntegers(src, 0, -1);
    }

    public static long[] unboxLongs(Object[] src) {
        return BoxingBase.unboxLongs(src, 0, -1);
    }

    public static short[] unboxShorts(Object[] src) {
        return BoxingBase.unboxShorts(src, 0, -1);
    }

    public static boolean[] unboxBooleans(Collection<?> src, int srcPos, int len) {
        return BoxingBase.unboxBooleans(src.toArray(), srcPos, len);
    }

    public static byte[] unboxBytes(Collection<?> src, int srcPos, int len) {
        return BoxingBase.unboxBytes(src.toArray(), srcPos, len);
    }

    public static char[] unboxCharacters(Collection<?> src, int srcPos, int len) {
        return BoxingBase.unboxCharacters(src.toArray(), srcPos, len);
    }

    public static float[] unboxFloats(Collection<?> src, int srcPos, int len) {
        return BoxingBase.unboxFloats(src.toArray(), srcPos, len);
    }

    public static double[] unboxDoubles(Collection<?> src, int srcPos, int len) {
        return BoxingBase.unboxDoubles(src.toArray(), srcPos, len);
    }

    public static int[] unboxIntegers(Collection<?> src, int srcPos, int len) {
        return BoxingBase.unboxIntegers(src.toArray(), srcPos, len);
    }

    public static long[] unboxLongs(Collection<?> src, int srcPos, int len) {
        return BoxingBase.unboxLongs(src.toArray(), srcPos, len);
    }

    public static short[] unboxShorts(Collection<?> src, int srcPos, int len) {
        return BoxingBase.unboxShorts(src.toArray(), srcPos, len);
    }

    public static boolean[] unboxBooleans(Collection<?> src) {
        return BoxingBase.unboxBooleans(src.toArray(), 0, -1);
    }

    public static byte[] unboxBytes(Collection<?> src) {
        return BoxingBase.unboxBytes(src.toArray(), 0, -1);
    }

    public static char[] unboxCharacters(Collection<?> src) {
        return BoxingBase.unboxCharacters(src.toArray(), 0, -1);
    }

    public static float[] unboxFloats(Collection<?> src) {
        return BoxingBase.unboxFloats(src.toArray(), 0, -1);
    }

    public static double[] unboxDoubles(Collection<?> src) {
        return BoxingBase.unboxDoubles(src.toArray(), 0, -1);
    }

    public static int[] unboxIntegers(Collection<?> src) {
        return BoxingBase.unboxIntegers(src.toArray(), 0, -1);
    }

    public static long[] unboxLongs(Collection<?> src) {
        return BoxingBase.unboxLongs(src.toArray(), 0, -1);
    }

    public static short[] unboxShorts(Collection<?> src) {
        return BoxingBase.unboxShorts(src.toArray(), 0, -1);
    }

    public static boolean[] unbox(Boolean[] src, int srcPos, int len) {
        return BoxingBase.unboxBooleans(src, srcPos, len);
    }

    public static byte[] unbox(Byte[] src, int srcPos, int len) {
        return BoxingBase.unboxBytes(src, srcPos, len);
    }

    public static char[] unbox(Character[] src, int srcPos, int len) {
        return BoxingBase.unboxCharacters(src, srcPos, len);
    }

    public static float[] unbox(Float[] src, int srcPos, int len) {
        return BoxingBase.unboxFloats(src, srcPos, len);
    }

    public static double[] unbox(Double[] src, int srcPos, int len) {
        return BoxingBase.unboxDoubles(src, srcPos, len);
    }

    public static int[] unbox(Integer[] src, int srcPos, int len) {
        return BoxingBase.unboxIntegers(src, srcPos, len);
    }

    public static long[] unbox(Long[] src, int srcPos, int len) {
        return BoxingBase.unboxLongs(src, srcPos, len);
    }

    public static short[] unbox(Short[] src, int srcPos, int len) {
        return BoxingBase.unboxShorts(src, srcPos, len);
    }

    public static boolean[] unbox(Boolean[] src) {
        return BoxingBase.unboxBooleans(src);
    }

    public static byte[] unbox(Byte[] src) {
        return BoxingBase.unboxBytes(src);
    }

    public static char[] unbox(Character[] src) {
        return BoxingBase.unboxCharacters(src);
    }

    public static float[] unbox(Float[] src) {
        return BoxingBase.unboxFloats(src);
    }

    public static double[] unbox(Double[] src) {
        return BoxingBase.unboxDoubles(src);
    }

    public static int[] unbox(Integer[] src) {
        return BoxingBase.unboxIntegers(src);
    }

    public static long[] unbox(Long[] src) {
        return BoxingBase.unboxLongs(src);
    }

    public static short[] unbox(Short[] src) {
        return BoxingBase.unboxShorts(src);
    }

    public static Boolean boxBoolean(Object b) {
        if (b instanceof Boolean) {
            return (Boolean)b;
        }
        return BoxingBase.unboxBoolean(b);
    }

    public static Byte boxByte(Object b) {
        if (b instanceof Byte) {
            return (Byte)b;
        }
        return BoxingBase.unboxByte(b);
    }

    public static Character boxCharacter(Object b) {
        if (b instanceof Character) {
            return (Character)b;
        }
        return Character.valueOf(BoxingBase.unboxCharacter(b));
    }

    public static Float boxFloat(Object b) {
        if (b instanceof Float) {
            return (Float)b;
        }
        return Float.valueOf(BoxingBase.unboxFloat(b));
    }

    public static Double boxDouble(Object b) {
        if (b instanceof Double) {
            return (Double)b;
        }
        return BoxingBase.unboxDouble(b);
    }

    public static Integer boxInteger(Object b) {
        if (b instanceof Integer) {
            return (Integer)b;
        }
        return BoxingBase.unboxInteger(b);
    }

    public static Long boxLong(Object b) {
        if (b instanceof Long) {
            return (Long)b;
        }
        return BoxingBase.unboxLong(b);
    }

    public static Short boxShort(Object b) {
        if (b instanceof Short) {
            return (Short)b;
        }
        return BoxingBase.unboxShort(b);
    }

    public static Boolean[] boxBooleans(Array src, int srcPos, int len) {
        if (len < 0) {
            len = src.length() - srcPos + len + 1;
        }
        Boolean[] result = new Boolean[len];
        int i = 0;
        while (i < len) {
            result[i] = src.getBoolean(srcPos + i);
            ++i;
        }
        return result;
    }

    public static Boolean[] boxBooleans(boolean[] src, int srcPos, int len) {
        if (len < 0) {
            len = src.length - srcPos + len + 1;
        }
        Boolean[] result = new Boolean[len];
        int i = 0;
        while (i < len) {
            result[i] = src[srcPos + i];
            ++i;
        }
        return result;
    }

    public static Byte[] boxBytes(Array src, int srcPos, int len) {
        if (len < 0) {
            len = src.length() - srcPos + len + 1;
        }
        Byte[] result = new Byte[len];
        int i = 0;
        while (i < len) {
            result[i] = src.getByte(srcPos + i);
            ++i;
        }
        return result;
    }

    public static Byte[] boxBytes(byte[] src, int srcPos, int len) {
        if (len < 0) {
            len = src.length - srcPos + len + 1;
        }
        Byte[] result = new Byte[len];
        int i = 0;
        while (i < len) {
            result[i] = src[srcPos + i];
            ++i;
        }
        return result;
    }

    public static Character[] boxCharacters(Array src, int srcPos, int len) {
        if (len < 0) {
            len = src.length() - srcPos + len + 1;
        }
        Character[] result = new Character[len];
        int i = 0;
        while (i < len) {
            result[i] = src.getCharacter(srcPos + i);
            ++i;
        }
        return result;
    }

    public static Character[] boxCharacters(char[] src, int srcPos, int len) {
        if (len < 0) {
            len = src.length - srcPos + len + 1;
        }
        Character[] result = new Character[len];
        int i = 0;
        while (i < len) {
            result[i] = Character.valueOf(src[srcPos + i]);
            ++i;
        }
        return result;
    }

    public static Float[] boxFloats(Array src, int srcPos, int len) {
        if (len < 0) {
            len = src.length() - srcPos + len + 1;
        }
        Float[] result = new Float[len];
        int i = 0;
        while (i < len) {
            result[i] = src.getFloat(srcPos + i);
            ++i;
        }
        return result;
    }

    public static Float[] boxFloats(float[] src, int srcPos, int len) {
        if (len < 0) {
            len = src.length - srcPos + len + 1;
        }
        Float[] result = new Float[len];
        int i = 0;
        while (i < len) {
            result[i] = Float.valueOf(src[srcPos + i]);
            ++i;
        }
        return result;
    }

    public static Double[] boxDoubles(Array src, int srcPos, int len) {
        if (len < 0) {
            len = src.length() - srcPos + len + 1;
        }
        Double[] result = new Double[len];
        int i = 0;
        while (i < len) {
            result[i] = src.getDouble(srcPos + i);
            ++i;
        }
        return result;
    }

    public static Double[] boxDoubles(double[] src, int srcPos, int len) {
        if (len < 0) {
            len = src.length - srcPos + len + 1;
        }
        Double[] result = new Double[len];
        int i = 0;
        while (i < len) {
            result[i] = src[srcPos + i];
            ++i;
        }
        return result;
    }

    public static Integer[] boxIntegers(Array src, int srcPos, int len) {
        if (len < 0) {
            len = src.length() - srcPos + len + 1;
        }
        Integer[] result = new Integer[len];
        int i = 0;
        while (i < len) {
            result[i] = src.getInteger(srcPos + i);
            ++i;
        }
        return result;
    }

    public static Integer[] boxIntegers(int[] src, int srcPos, int len) {
        if (len < 0) {
            len = src.length - srcPos + len + 1;
        }
        Integer[] result = new Integer[len];
        int i = 0;
        while (i < len) {
            result[i] = src[srcPos + i];
            ++i;
        }
        return result;
    }

    public static Long[] boxLongs(Array src, int srcPos, int len) {
        if (len < 0) {
            len = src.length() - srcPos + len + 1;
        }
        Long[] result = new Long[len];
        int i = 0;
        while (i < len) {
            result[i] = src.getLong(srcPos + i);
            ++i;
        }
        return result;
    }

    public static Long[] boxLongs(long[] src, int srcPos, int len) {
        if (len < 0) {
            len = src.length - srcPos + len + 1;
        }
        Long[] result = new Long[len];
        int i = 0;
        while (i < len) {
            result[i] = src[srcPos + i];
            ++i;
        }
        return result;
    }

    public static Short[] boxShorts(Array src, int srcPos, int len) {
        if (len < 0) {
            len = src.length() - srcPos + len + 1;
        }
        Short[] result = new Short[len];
        int i = 0;
        while (i < len) {
            result[i] = src.getShort(srcPos + i);
            ++i;
        }
        return result;
    }

    public static Short[] boxShorts(short[] src, int srcPos, int len) {
        if (len < 0) {
            len = src.length - srcPos + len + 1;
        }
        Short[] result = new Short[len];
        int i = 0;
        while (i < len) {
            result[i] = src[srcPos + i];
            ++i;
        }
        return result;
    }

    public static Boolean[] boxBooleans(boolean[] src) {
        return BoxingBase.boxBooleans(src, 0, -1);
    }

    public static Byte[] boxBytes(byte[] src) {
        return BoxingBase.boxBytes(src, 0, -1);
    }

    public static Character[] boxCharacters(char[] src) {
        return BoxingBase.boxCharacters(src, 0, -1);
    }

    public static Float[] boxFloats(float[] src) {
        return BoxingBase.boxFloats(src, 0, -1);
    }

    public static Double[] boxDoubles(double[] src) {
        return BoxingBase.boxDoubles(src, 0, -1);
    }

    public static Integer[] boxIntegers(int[] src) {
        return BoxingBase.boxIntegers(src, 0, -1);
    }

    public static Long[] boxLongs(long[] src) {
        return BoxingBase.boxLongs(src, 0, -1);
    }

    public static Short[] boxShorts(short[] src) {
        return BoxingBase.boxShorts(src, 0, -1);
    }

    public static Boolean[] box(boolean[] src, int srcPos, int len) {
        return BoxingBase.boxBooleans(src, 0, -1);
    }

    public static Byte[] box(byte[] src, int srcPos, int len) {
        return BoxingBase.boxBytes(src, 0, -1);
    }

    public static Character[] box(char[] src, int srcPos, int len) {
        return BoxingBase.boxCharacters(src, 0, -1);
    }

    public static Float[] box(float[] src, int srcPos, int len) {
        return BoxingBase.boxFloats(src, 0, -1);
    }

    public static Double[] box(double[] src, int srcPos, int len) {
        return BoxingBase.boxDoubles(src, 0, -1);
    }

    public static Integer[] box(int[] src, int srcPos, int len) {
        return BoxingBase.boxIntegers(src, 0, -1);
    }

    public static Long[] box(long[] src, int srcPos, int len) {
        return BoxingBase.boxLongs(src, 0, -1);
    }

    public static Short[] box(short[] src, int srcPos, int len) {
        return BoxingBase.boxShorts(src, 0, -1);
    }

    public static Boolean[] box(boolean[] src) {
        return BoxingBase.boxBooleans(src, 0, -1);
    }

    public static Byte[] box(byte[] src) {
        return BoxingBase.boxBytes(src, 0, -1);
    }

    public static Character[] box(char[] src) {
        return BoxingBase.boxCharacters(src, 0, -1);
    }

    public static Float[] box(float[] src) {
        return BoxingBase.boxFloats(src, 0, -1);
    }

    public static Double[] box(double[] src) {
        return BoxingBase.boxDoubles(src, 0, -1);
    }

    public static Integer[] box(int[] src) {
        return BoxingBase.boxIntegers(src, 0, -1);
    }

    public static Long[] box(long[] src) {
        return BoxingBase.boxLongs(src, 0, -1);
    }

    public static Short[] box(short[] src) {
        return BoxingBase.boxShorts(src, 0, -1);
    }

    public static Array array(boolean[] array) {
        return new BooleanArray(array);
    }

    public static Array array(byte[] array) {
        return new ByteArray(array);
    }

    public static Array array(char[] array) {
        return new CharacterArray(array);
    }

    public static Array array(float[] array) {
        return new FloatArray(array);
    }

    public static Array array(double[] array) {
        return new DoubleArray(array);
    }

    public static Array array(int[] array) {
        return new IntegerArray(array);
    }

    public static Array array(long[] array) {
        return new LongArray(array);
    }

    public static Array array(short[] array) {
        return new ShortArray(array);
    }

    public static Array array(Object[] array) {
        return new ObjectArray(array);
    }

    public static abstract class Array {
        public abstract int length();

        public abstract boolean getBooleanValue(int var1);

        public abstract byte getByteValue(int var1);

        public abstract char getCharacterValue(int var1);

        public abstract float getFloatValue(int var1);

        public abstract double getDoubleValue(int var1);

        public abstract int getIntegerValue(int var1);

        public abstract long getLongValue(int var1);

        public abstract short getShortValue(int var1);

        public abstract Boolean getBoolean(int var1);

        public abstract Byte getByte(int var1);

        public abstract Character getCharacter(int var1);

        public abstract Float getFloat(int var1);

        public abstract Double getDouble(int var1);

        public abstract Integer getInteger(int var1);

        public abstract Long getLong(int var1);

        public abstract Short getShort(int var1);
    }

    private static final class BooleanArray
    extends PrimArray {
        private final boolean[] array;

        public BooleanArray(boolean[] array) {
            this.array = array;
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public boolean getBooleanValue(int i) {
            return this.array[i];
        }

        @Override
        public byte getByteValue(int i) {
            return BoxingBase.unboxByte(this.array[i]);
        }

        @Override
        public char getCharacterValue(int i) {
            return BoxingBase.unboxCharacter(this.array[i]);
        }

        @Override
        public float getFloatValue(int i) {
            return BoxingBase.unboxFloat(this.array[i]);
        }

        @Override
        public double getDoubleValue(int i) {
            return BoxingBase.unboxDouble(this.array[i]);
        }

        @Override
        public int getIntegerValue(int i) {
            return BoxingBase.unboxInteger(this.array[i]);
        }

        @Override
        public long getLongValue(int i) {
            return BoxingBase.unboxLong(this.array[i]);
        }

        @Override
        public short getShortValue(int i) {
            return BoxingBase.unboxShort(this.array[i]);
        }
    }

    private static final class ByteArray
    extends PrimArray {
        private final byte[] array;

        public ByteArray(byte[] array) {
            this.array = array;
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public boolean getBooleanValue(int i) {
            return BoxingBase.unboxBoolean(this.array[i]);
        }

        @Override
        public byte getByteValue(int i) {
            return this.array[i];
        }

        @Override
        public char getCharacterValue(int i) {
            return (char)this.array[i];
        }

        @Override
        public float getFloatValue(int i) {
            return this.array[i];
        }

        @Override
        public double getDoubleValue(int i) {
            return this.array[i];
        }

        @Override
        public int getIntegerValue(int i) {
            return this.array[i];
        }

        @Override
        public long getLongValue(int i) {
            return this.array[i];
        }

        @Override
        public short getShortValue(int i) {
            return this.array[i];
        }
    }

    private static final class CharacterArray
    extends PrimArray {
        private final char[] array;

        public CharacterArray(char[] array) {
            this.array = array;
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public boolean getBooleanValue(int i) {
            return BoxingBase.unboxBoolean(Character.valueOf(this.array[i]));
        }

        @Override
        public byte getByteValue(int i) {
            return (byte)this.array[i];
        }

        @Override
        public char getCharacterValue(int i) {
            return this.array[i];
        }

        @Override
        public float getFloatValue(int i) {
            return this.array[i];
        }

        @Override
        public double getDoubleValue(int i) {
            return this.array[i];
        }

        @Override
        public int getIntegerValue(int i) {
            return this.array[i];
        }

        @Override
        public long getLongValue(int i) {
            return this.array[i];
        }

        @Override
        public short getShortValue(int i) {
            return (short)this.array[i];
        }
    }

    private static final class DoubleArray
    extends PrimArray {
        private final double[] array;

        public DoubleArray(double[] array) {
            this.array = array;
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public boolean getBooleanValue(int i) {
            return BoxingBase.unboxBoolean(this.array[i]);
        }

        @Override
        public byte getByteValue(int i) {
            return (byte)this.array[i];
        }

        @Override
        public char getCharacterValue(int i) {
            return (char)this.array[i];
        }

        @Override
        public float getFloatValue(int i) {
            return (float)this.array[i];
        }

        @Override
        public double getDoubleValue(int i) {
            return this.array[i];
        }

        @Override
        public int getIntegerValue(int i) {
            return (int)this.array[i];
        }

        @Override
        public long getLongValue(int i) {
            return (long)this.array[i];
        }

        @Override
        public short getShortValue(int i) {
            return (short)this.array[i];
        }
    }

    private static final class FloatArray
    extends PrimArray {
        private final float[] array;

        public FloatArray(float[] array) {
            this.array = array;
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public boolean getBooleanValue(int i) {
            return BoxingBase.unboxBoolean(Float.valueOf(this.array[i]));
        }

        @Override
        public byte getByteValue(int i) {
            return (byte)this.array[i];
        }

        @Override
        public char getCharacterValue(int i) {
            return (char)this.array[i];
        }

        @Override
        public float getFloatValue(int i) {
            return this.array[i];
        }

        @Override
        public double getDoubleValue(int i) {
            return this.array[i];
        }

        @Override
        public int getIntegerValue(int i) {
            return (int)this.array[i];
        }

        @Override
        public long getLongValue(int i) {
            return (long)this.array[i];
        }

        @Override
        public short getShortValue(int i) {
            return (short)this.array[i];
        }
    }

    private static final class IntegerArray
    extends PrimArray {
        private final int[] array;

        public IntegerArray(int[] array) {
            this.array = array;
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public boolean getBooleanValue(int i) {
            return BoxingBase.unboxBoolean(this.array[i]);
        }

        @Override
        public byte getByteValue(int i) {
            return (byte)this.array[i];
        }

        @Override
        public char getCharacterValue(int i) {
            return (char)this.array[i];
        }

        @Override
        public float getFloatValue(int i) {
            return this.array[i];
        }

        @Override
        public double getDoubleValue(int i) {
            return this.array[i];
        }

        @Override
        public int getIntegerValue(int i) {
            return this.array[i];
        }

        @Override
        public long getLongValue(int i) {
            return this.array[i];
        }

        @Override
        public short getShortValue(int i) {
            return (short)this.array[i];
        }
    }

    private static final class LongArray
    extends PrimArray {
        private final long[] array;

        public LongArray(long[] array) {
            this.array = array;
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public boolean getBooleanValue(int i) {
            return BoxingBase.unboxBoolean(this.array[i]);
        }

        @Override
        public byte getByteValue(int i) {
            return (byte)this.array[i];
        }

        @Override
        public char getCharacterValue(int i) {
            return (char)this.array[i];
        }

        @Override
        public float getFloatValue(int i) {
            return this.array[i];
        }

        @Override
        public double getDoubleValue(int i) {
            return this.array[i];
        }

        @Override
        public int getIntegerValue(int i) {
            return (int)this.array[i];
        }

        @Override
        public long getLongValue(int i) {
            return this.array[i];
        }

        @Override
        public short getShortValue(int i) {
            return (short)this.array[i];
        }
    }

    private static final class ObjectArray
    extends Array {
        private final Object[] array;

        public ObjectArray(Object[] array) {
            this.array = array;
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public boolean getBooleanValue(int i) {
            return BoxingBase.unboxBoolean(this.array[i]);
        }

        @Override
        public byte getByteValue(int i) {
            return BoxingBase.unboxByte(this.array[i]);
        }

        @Override
        public char getCharacterValue(int i) {
            return BoxingBase.unboxCharacter(this.array[i]);
        }

        @Override
        public float getFloatValue(int i) {
            return BoxingBase.unboxFloat(this.array[i]);
        }

        @Override
        public double getDoubleValue(int i) {
            return BoxingBase.unboxDouble(this.array[i]);
        }

        @Override
        public int getIntegerValue(int i) {
            return BoxingBase.unboxInteger(this.array[i]);
        }

        @Override
        public long getLongValue(int i) {
            return BoxingBase.unboxLong(this.array[i]);
        }

        @Override
        public short getShortValue(int i) {
            return BoxingBase.unboxShort(this.array[i]);
        }

        @Override
        public Boolean getBoolean(int i) {
            return BoxingBase.boxBoolean(this.array[i]);
        }

        @Override
        public Byte getByte(int i) {
            return BoxingBase.boxByte(this.array[i]);
        }

        @Override
        public Character getCharacter(int i) {
            return BoxingBase.boxCharacter(this.array[i]);
        }

        @Override
        public Float getFloat(int i) {
            return BoxingBase.boxFloat(this.array[i]);
        }

        @Override
        public Double getDouble(int i) {
            return BoxingBase.boxDouble(this.array[i]);
        }

        @Override
        public Integer getInteger(int i) {
            return BoxingBase.boxInteger(this.array[i]);
        }

        @Override
        public Long getLong(int i) {
            return BoxingBase.boxLong(this.array[i]);
        }

        @Override
        public Short getShort(int i) {
            return BoxingBase.boxShort(this.array[i]);
        }
    }

    private static abstract class PrimArray
    extends Array {
        private PrimArray() {
        }

        @Override
        public Boolean getBoolean(int i) {
            return this.getBooleanValue(i);
        }

        @Override
        public Byte getByte(int i) {
            return this.getByteValue(i);
        }

        @Override
        public Character getCharacter(int i) {
            return Character.valueOf(this.getCharacterValue(i));
        }

        @Override
        public Float getFloat(int i) {
            return Float.valueOf(this.getFloatValue(i));
        }

        @Override
        public Double getDouble(int i) {
            return this.getDoubleValue(i);
        }

        @Override
        public Integer getInteger(int i) {
            return this.getIntegerValue(i);
        }

        @Override
        public Long getLong(int i) {
            return this.getLongValue(i);
        }

        @Override
        public Short getShort(int i) {
            return this.getShortValue(i);
        }
    }

    private static final class ShortArray
    extends PrimArray {
        private final short[] array;

        public ShortArray(short[] array) {
            this.array = array;
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public boolean getBooleanValue(int i) {
            return BoxingBase.unboxBoolean(this.array[i]);
        }

        @Override
        public byte getByteValue(int i) {
            return (byte)this.array[i];
        }

        @Override
        public char getCharacterValue(int i) {
            return (char)this.array[i];
        }

        @Override
        public float getFloatValue(int i) {
            return this.array[i];
        }

        @Override
        public double getDoubleValue(int i) {
            return this.array[i];
        }

        @Override
        public int getIntegerValue(int i) {
            return this.array[i];
        }

        @Override
        public long getLongValue(int i) {
            return this.array[i];
        }

        @Override
        public short getShortValue(int i) {
            return this.array[i];
        }
    }
}

