/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.objects.reflection;

import org.cthul.objects.Boxing;

public class JavaSignatureComparator {
    public static final int MATCH = 400;
    public static final int MATCH_WILDCARD = 300;
    public static final int MATCH_BOXING = 200;
    public static final int MATCH_VARARGS = 100;
    public static final int NO_MATCH = -99;
    private final Class<?>[] argTypes;

    public JavaSignatureComparator(Class<?> ... argTypes) {
        this.argTypes = argTypes;
    }

    public Class<?>[] getReferenceSignature() {
        return (Class[])this.argTypes.clone();
    }

    public int compareSpecificness(Class<?>[] a, boolean a_varArgs, Class<?>[] b, boolean b_varArgs) {
        int newC;
        boolean b_varArgsUsed;
        int newC2;
        int i;
        Class<?> b_varType;
        int a_fixLen = a.length - (a_varArgs ? 1 : 0);
        int b_fixLen = b.length - (b_varArgs ? 1 : 0);
        int fixLen = Math.min(a_fixLen, b_fixLen);
        int c = 0;
        int i2 = 0;
        while (i2 < fixLen) {
            int newC3 = this.compareParameter(a[i2], b[i2]);
            if (newC3 != 0 && newC3 != c) {
                if (c == 0) {
                    c = newC3;
                } else {
                    return 0;
                }
            }
            ++i2;
        }
        Class<?> a_varType = a_varArgs ? a[a_fixLen] : null;
        Class<?> clazz = b_varType = b_varArgs ? b[b_fixLen] : null;
        if (a_varArgs && a_fixLen < b_fixLen) {
            i = fixLen;
            while (i < b_fixLen) {
                newC2 = this.compareParameter(a_varType, b[i]);
                if (newC2 != 0 && newC2 != c) {
                    if (c == 0) {
                        c = newC2;
                    } else {
                        return 0;
                    }
                }
                ++i;
            }
        }
        if (b_varArgs && b_fixLen < a_fixLen) {
            i = fixLen;
            while (i < a_fixLen) {
                newC2 = this.compareParameter(a[i], b_varType);
                if (newC2 != 0 && newC2 != c) {
                    if (c == 0) {
                        c = newC2;
                    } else {
                        return 0;
                    }
                }
                ++i;
            }
        }
        boolean a_varArgsUsed = a_varArgs && this.argTypes.length > a_fixLen;
        boolean bl = b_varArgsUsed = b_varArgs && this.argTypes.length > b_fixLen;
        if (a_varArgsUsed && b_varArgsUsed && (newC = this.compareParameter(a_varType, b_varType)) != 0 && newC != c) {
            if (c == 0) {
                c = newC;
            } else {
                return 0;
            }
        }
        if (c == 0) {
            if (a_fixLen > b_fixLen) {
                return -1;
            }
            if (b_fixLen > a_fixLen) {
                return 1;
            }
        }
        return c;
    }

    private int compareParameter(Class<?> a, Class<?> b) {
        if (a.equals(b)) {
            return 0;
        }
        if (b.isAssignableFrom(a)) {
            return -1;
        }
        if (a.isAssignableFrom(b)) {
            return 1;
        }
        return 0;
    }

    public int applicability(Class<?>[] paramTypes, boolean varArgs) {
        int m;
        if (this.argTypes == null) {
            return 300;
        }
        int level = 400;
        int fixArgs = paramTypes.length - (varArgs ? 1 : 0);
        if (fixArgs > this.argTypes.length || !varArgs && fixArgs != this.argTypes.length) {
            return -99;
        }
        int i = 0;
        while (i < fixArgs) {
            m = this.applicable(this.argTypes[i], paramTypes[i]);
            if (m == -99) {
                return -99;
            }
            if (m < level) {
                level = m;
            }
            ++i;
        }
        if (varArgs) {
            Class<?> varArgType = paramTypes[fixArgs];
            if (paramTypes.length == this.argTypes.length && (m = this.applicable(this.argTypes[fixArgs], varArgType)) != -99) {
                return Math.min(m, level);
            }
            level = 100;
            Class<?> comp = varArgType.getComponentType();
            int i2 = fixArgs;
            while (i2 < this.argTypes.length) {
                int m2 = this.applicable(this.argTypes[i2], comp);
                if (m2 == -99) {
                    return -99;
                }
                ++i2;
            }
        }
        return level;
    }

    private int applicable(Class<?> arg, Class<?> param) {
        if (arg == null) {
            if (param != null && param.isPrimitive()) {
                return -99;
            }
            return 400;
        }
        if (param == null) {
            return 300;
        }
        if (param.isAssignableFrom(arg)) {
            return 400;
        }
        Class<?> boxArg = Boxing.boxingType(arg);
        if (boxArg != null && param.isAssignableFrom(boxArg)) {
            return 200;
        }
        return -99;
    }
}

