/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.objects.reflection;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.cthul.objects.instance.UniqueValueCache;
import org.cthul.objects.reflection.VirtualMethod;

public class VirtualSwitch {
    private static final UniqueValueCache<Class, VirtualSwitch> INSTANCES = new UniqueValueCache<Class, VirtualSwitch>(){

        @Override
        protected VirtualSwitch newValue(Class clazz) {
            return new VirtualSwitch(clazz);
        }
    };
    private final Class clazz;
    private final Map<Signature, VirtualMethod<?>> methods = new ConcurrentHashMap();

    public static VirtualSwitch instance(Class clazz) {
        return INSTANCES.get(clazz);
    }

    public VirtualSwitch(Class clazz) {
        this.clazz = clazz;
    }

    public <R> R invoke(Object self, String name, Object ... args) throws IllegalAccessException, InvocationTargetException {
        VirtualMethod<R> vms = this.get(name);
        return vms.invoke(self, args);
    }

    public <R> R invokeStatic(String name, Object ... args) throws IllegalAccessException, InvocationTargetException {
        VirtualMethod<R> vms = this.get(name);
        return vms.invokeStatic(args);
    }

    public <R> R _invoke(Object self, String name, Object ... args) {
        VirtualMethod<R> vms = this.get(name);
        return vms._invoke(self, args);
    }

    public <R> R _invokeStatic(String name, Object ... args) {
        VirtualMethod<R> vms = this.get(name);
        return vms._invokeStatic(args);
    }

    public <R> VirtualMethod<R> get(String name) {
        return this.get(name, 0, true, null);
    }

    public <R> VirtualMethod<R> get(String name, Class ... paramTypes) {
        return this.get(name, 0, true, paramTypes);
    }

    public <R> VirtualMethod<R> get(String name, boolean varArgSwitch, Class ... paramTypes) {
        return this.get(name, 0, varArgSwitch, paramTypes);
    }

    public <R> VirtualMethod<R> get(String name, int switchParamCount, Class ... moreParams) {
        return this.get(name, switchParamCount, true, moreParams);
    }

    public <R> VirtualMethod<R> get(String name, int switchParamCount, boolean varArgSwitch, Class ... moreParams) {
        Signature sig = new Signature(name, switchParamCount, varArgSwitch, moreParams);
        VirtualMethod<Object> vms = this.methods.get(sig);
        if (vms == null) {
            vms = new VirtualMethod(this.clazz, name, switchParamCount, varArgSwitch, moreParams);
            this.methods.put(sig, vms);
        }
        return vms;
    }

    protected static class Signature {
        final String name;
        final int switchParamCount;
        final boolean varArgSwitch;
        final Class[] moreParams;

        public Signature(String name, int switchParamCount, boolean varArgSwitch, Class[] moreParams) {
            this.name = name;
            this.switchParamCount = switchParamCount;
            this.varArgSwitch = varArgSwitch;
            this.moreParams = moreParams;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + Objects.hashCode(this.name);
            hash = 29 * hash + this.switchParamCount;
            hash = 29 * hash + (this.varArgSwitch ? 1 : 0);
            hash = 29 * hash + Arrays.deepHashCode(this.moreParams);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Signature other = (Signature)obj;
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            if (this.switchParamCount != other.switchParamCount) {
                return false;
            }
            if (this.varArgSwitch != other.varArgSwitch) {
                return false;
            }
            return Arrays.deepEquals(this.moreParams, other.moreParams);
        }
    }
}

