// generated code
package org.cthul.objects.internal;

import java.util.Collection;

public class BoxingBase {

    /**
     * Transforms any {@code Boolean}, {@code Character}, or {@code Number}
     * into a {@code boolean}.
     * @param b boxed value
     * @return boolean
     */
    public static boolean unboxBoolean(Object b) {
        if (b instanceof Boolean) {
            return (Boolean) b;
        } else if (b instanceof Number) {
            return ((Number) b).doubleValue() > 0;
        } else if (b instanceof Character) {
            return ((Character) b) > '\0';
        } else {
            throw new IllegalArgumentException(String.valueOf(b));
        }  
    }

    /**
     * Transforms any {@code Boolean}, {@code Character}, or {@code Number}
     * into a {@code byte}.
     * @param b boxed value
     * @return byte
     */
    public static byte unboxByte(Object b) {
        if (b instanceof Number) {
            return ((Number) b).byteValue();
        } else if (b instanceof Character) {
            return (byte) ((Character) b).charValue();
        } else if (b instanceof Boolean) {
            return (byte) (((Boolean) b) ? 1 : 0);
        } else {
            throw new IllegalArgumentException(String.valueOf(b));
        }  
    }

    /**
     * Transforms any {@code Boolean}, {@code Character}, or {@code Number}
     * into a {@code char}.
     * @param b boxed value
     * @return char
     */
    public static char unboxCharacter(Object b) {
        if (b instanceof Character) {
            return (Character) b;
        } else if (b instanceof Number) {
            return (char) ((Number) b).intValue();
        } else if (b instanceof Boolean) {
            return ((Boolean) b) ? '\1' : '\0';
        } else {
            throw new IllegalArgumentException(String.valueOf(b));
        }  
    }

    /**
     * Transforms any {@code Boolean}, {@code Character}, or {@code Number}
     * into a {@code float}.
     * @param b boxed value
     * @return float
     */
    public static float unboxFloat(Object b) {
        if (b instanceof Number) {
            return ((Number) b).floatValue();
        } else if (b instanceof Character) {
            return (float) ((Character) b).charValue();
        } else if (b instanceof Boolean) {
            return (float) (((Boolean) b) ? 1 : 0);
        } else {
            throw new IllegalArgumentException(String.valueOf(b));
        }  
    }

    /**
     * Transforms any {@code Boolean}, {@code Character}, or {@code Number}
     * into a {@code double}.
     * @param b boxed value
     * @return double
     */
    public static double unboxDouble(Object b) {
        if (b instanceof Number) {
            return ((Number) b).doubleValue();
        } else if (b instanceof Character) {
            return (double) ((Character) b).charValue();
        } else if (b instanceof Boolean) {
            return (double) (((Boolean) b) ? 1 : 0);
        } else {
            throw new IllegalArgumentException(String.valueOf(b));
        }  
    }

    /**
     * Transforms any {@code Boolean}, {@code Character}, or {@code Number}
     * into a {@code int}.
     * @param b boxed value
     * @return int
     */
    public static int unboxInteger(Object b) {
        if (b instanceof Number) {
            return ((Number) b).intValue();
        } else if (b instanceof Character) {
            return (int) ((Character) b).charValue();
        } else if (b instanceof Boolean) {
            return (int) (((Boolean) b) ? 1 : 0);
        } else {
            throw new IllegalArgumentException(String.valueOf(b));
        }  
    }

    /**
     * Transforms any {@code Boolean}, {@code Character}, or {@code Number}
     * into a {@code long}.
     * @param b boxed value
     * @return long
     */
    public static long unboxLong(Object b) {
        if (b instanceof Number) {
            return ((Number) b).longValue();
        } else if (b instanceof Character) {
            return (long) ((Character) b).charValue();
        } else if (b instanceof Boolean) {
            return (long) (((Boolean) b) ? 1 : 0);
        } else {
            throw new IllegalArgumentException(String.valueOf(b));
        }  
    }

    /**
     * Transforms any {@code Boolean}, {@code Character}, or {@code Number}
     * into a {@code short}.
     * @param b boxed value
     * @return short
     */
    public static short unboxShort(Object b) {
        if (b instanceof Number) {
            return ((Number) b).shortValue();
        } else if (b instanceof Character) {
            return (short) ((Character) b).charValue();
        } else if (b instanceof Boolean) {
            return (short) (((Boolean) b) ? 1 : 0);
        } else {
            throw new IllegalArgumentException(String.valueOf(b));
        }  
    }
    
    /**
     * Transforms an {@link Array} into an array of {@code boolean}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of boolean
     */
    public static boolean[] unboxBooleans(Array src, int srcPos, int len) {
        if (len < 0) len = src.length() - srcPos + len + 1;
        final boolean[] result = new boolean[len];
        for (int i = 0; i < len; i++) {
            result[i] = src.getBooleanValue(srcPos + i);
        }
        return result;
    }
    
    /**
     * Transforms an array of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code boolean}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of boolean
     */
    public static boolean[] unboxBooleans(Object[] src, int srcPos, int len) {
        if (len < 0) len = src.length - srcPos + len + 1;
        final boolean[] result = new boolean[len];
        for (int i = 0; i < len; i++) {
            result[i] = unboxBoolean(src[srcPos + i]);
        }
        return result;
    }
    
    /**
     * Transforms an {@link Array} into an array of {@code byte}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of byte
     */
    public static byte[] unboxBytes(Array src, int srcPos, int len) {
        if (len < 0) len = src.length() - srcPos + len + 1;
        final byte[] result = new byte[len];
        for (int i = 0; i < len; i++) {
            result[i] = src.getByteValue(srcPos + i);
        }
        return result;
    }
    
    /**
     * Transforms an array of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code byte}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of byte
     */
    public static byte[] unboxBytes(Object[] src, int srcPos, int len) {
        if (len < 0) len = src.length - srcPos + len + 1;
        final byte[] result = new byte[len];
        for (int i = 0; i < len; i++) {
            result[i] = unboxByte(src[srcPos + i]);
        }
        return result;
    }
    
    /**
     * Transforms an {@link Array} into an array of {@code char}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of char
     */
    public static char[] unboxCharacters(Array src, int srcPos, int len) {
        if (len < 0) len = src.length() - srcPos + len + 1;
        final char[] result = new char[len];
        for (int i = 0; i < len; i++) {
            result[i] = src.getCharacterValue(srcPos + i);
        }
        return result;
    }
    
    /**
     * Transforms an array of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code char}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of char
     */
    public static char[] unboxCharacters(Object[] src, int srcPos, int len) {
        if (len < 0) len = src.length - srcPos + len + 1;
        final char[] result = new char[len];
        for (int i = 0; i < len; i++) {
            result[i] = unboxCharacter(src[srcPos + i]);
        }
        return result;
    }
    
    /**
     * Transforms an {@link Array} into an array of {@code float}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of float
     */
    public static float[] unboxFloats(Array src, int srcPos, int len) {
        if (len < 0) len = src.length() - srcPos + len + 1;
        final float[] result = new float[len];
        for (int i = 0; i < len; i++) {
            result[i] = src.getFloatValue(srcPos + i);
        }
        return result;
    }
    
    /**
     * Transforms an array of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code float}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of float
     */
    public static float[] unboxFloats(Object[] src, int srcPos, int len) {
        if (len < 0) len = src.length - srcPos + len + 1;
        final float[] result = new float[len];
        for (int i = 0; i < len; i++) {
            result[i] = unboxFloat(src[srcPos + i]);
        }
        return result;
    }
    
    /**
     * Transforms an {@link Array} into an array of {@code double}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of double
     */
    public static double[] unboxDoubles(Array src, int srcPos, int len) {
        if (len < 0) len = src.length() - srcPos + len + 1;
        final double[] result = new double[len];
        for (int i = 0; i < len; i++) {
            result[i] = src.getDoubleValue(srcPos + i);
        }
        return result;
    }
    
    /**
     * Transforms an array of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code double}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of double
     */
    public static double[] unboxDoubles(Object[] src, int srcPos, int len) {
        if (len < 0) len = src.length - srcPos + len + 1;
        final double[] result = new double[len];
        for (int i = 0; i < len; i++) {
            result[i] = unboxDouble(src[srcPos + i]);
        }
        return result;
    }
    
    /**
     * Transforms an {@link Array} into an array of {@code int}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of int
     */
    public static int[] unboxIntegers(Array src, int srcPos, int len) {
        if (len < 0) len = src.length() - srcPos + len + 1;
        final int[] result = new int[len];
        for (int i = 0; i < len; i++) {
            result[i] = src.getIntegerValue(srcPos + i);
        }
        return result;
    }
    
    /**
     * Transforms an array of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code int}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of int
     */
    public static int[] unboxIntegers(Object[] src, int srcPos, int len) {
        if (len < 0) len = src.length - srcPos + len + 1;
        final int[] result = new int[len];
        for (int i = 0; i < len; i++) {
            result[i] = unboxInteger(src[srcPos + i]);
        }
        return result;
    }
    
    /**
     * Transforms an {@link Array} into an array of {@code long}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of long
     */
    public static long[] unboxLongs(Array src, int srcPos, int len) {
        if (len < 0) len = src.length() - srcPos + len + 1;
        final long[] result = new long[len];
        for (int i = 0; i < len; i++) {
            result[i] = src.getLongValue(srcPos + i);
        }
        return result;
    }
    
    /**
     * Transforms an array of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code long}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of long
     */
    public static long[] unboxLongs(Object[] src, int srcPos, int len) {
        if (len < 0) len = src.length - srcPos + len + 1;
        final long[] result = new long[len];
        for (int i = 0; i < len; i++) {
            result[i] = unboxLong(src[srcPos + i]);
        }
        return result;
    }
    
    /**
     * Transforms an {@link Array} into an array of {@code short}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of short
     */
    public static short[] unboxShorts(Array src, int srcPos, int len) {
        if (len < 0) len = src.length() - srcPos + len + 1;
        final short[] result = new short[len];
        for (int i = 0; i < len; i++) {
            result[i] = src.getShortValue(srcPos + i);
        }
        return result;
    }
    
    /**
     * Transforms an array of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code short}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of short
     */
    public static short[] unboxShorts(Object[] src, int srcPos, int len) {
        if (len < 0) len = src.length - srcPos + len + 1;
        final short[] result = new short[len];
        for (int i = 0; i < len; i++) {
            result[i] = unboxShort(src[srcPos + i]);
        }
        return result;
    }

    /**
     * Transforms an array of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code boolean}.
     * @param src source array
     * @return array of boolean
     */
    public static boolean[] unboxBooleans(Object[] src) {
        return unboxBooleans(src, 0, -1);
    }

    /**
     * Transforms an array of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code byte}.
     * @param src source array
     * @return array of byte
     */
    public static byte[] unboxBytes(Object[] src) {
        return unboxBytes(src, 0, -1);
    }

    /**
     * Transforms an array of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code char}.
     * @param src source array
     * @return array of char
     */
    public static char[] unboxCharacters(Object[] src) {
        return unboxCharacters(src, 0, -1);
    }

    /**
     * Transforms an array of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code float}.
     * @param src source array
     * @return array of float
     */
    public static float[] unboxFloats(Object[] src) {
        return unboxFloats(src, 0, -1);
    }

    /**
     * Transforms an array of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code double}.
     * @param src source array
     * @return array of double
     */
    public static double[] unboxDoubles(Object[] src) {
        return unboxDoubles(src, 0, -1);
    }

    /**
     * Transforms an array of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code int}.
     * @param src source array
     * @return array of int
     */
    public static int[] unboxIntegers(Object[] src) {
        return unboxIntegers(src, 0, -1);
    }

    /**
     * Transforms an array of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code long}.
     * @param src source array
     * @return array of long
     */
    public static long[] unboxLongs(Object[] src) {
        return unboxLongs(src, 0, -1);
    }

    /**
     * Transforms an array of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code short}.
     * @param src source array
     * @return array of short
     */
    public static short[] unboxShorts(Object[] src) {
        return unboxShorts(src, 0, -1);
    }

    /**
     * Transforms a collection of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code boolean}.
     * @param src source collection
     * @param srcPos start position
     * @param len length
     * @return array of boolean
     */
    public static boolean[] unboxBooleans(Collection<?> src, int srcPos, int len) {
        return unboxBooleans(src.toArray(), srcPos, len);
    }

    /**
     * Transforms a collection of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code byte}.
     * @param src source collection
     * @param srcPos start position
     * @param len length
     * @return array of byte
     */
    public static byte[] unboxBytes(Collection<?> src, int srcPos, int len) {
        return unboxBytes(src.toArray(), srcPos, len);
    }

    /**
     * Transforms a collection of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code char}.
     * @param src source collection
     * @param srcPos start position
     * @param len length
     * @return array of char
     */
    public static char[] unboxCharacters(Collection<?> src, int srcPos, int len) {
        return unboxCharacters(src.toArray(), srcPos, len);
    }

    /**
     * Transforms a collection of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code float}.
     * @param src source collection
     * @param srcPos start position
     * @param len length
     * @return array of float
     */
    public static float[] unboxFloats(Collection<?> src, int srcPos, int len) {
        return unboxFloats(src.toArray(), srcPos, len);
    }

    /**
     * Transforms a collection of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code double}.
     * @param src source collection
     * @param srcPos start position
     * @param len length
     * @return array of double
     */
    public static double[] unboxDoubles(Collection<?> src, int srcPos, int len) {
        return unboxDoubles(src.toArray(), srcPos, len);
    }

    /**
     * Transforms a collection of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code int}.
     * @param src source collection
     * @param srcPos start position
     * @param len length
     * @return array of int
     */
    public static int[] unboxIntegers(Collection<?> src, int srcPos, int len) {
        return unboxIntegers(src.toArray(), srcPos, len);
    }

    /**
     * Transforms a collection of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code long}.
     * @param src source collection
     * @param srcPos start position
     * @param len length
     * @return array of long
     */
    public static long[] unboxLongs(Collection<?> src, int srcPos, int len) {
        return unboxLongs(src.toArray(), srcPos, len);
    }

    /**
     * Transforms a collection of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code short}.
     * @param src source collection
     * @param srcPos start position
     * @param len length
     * @return array of short
     */
    public static short[] unboxShorts(Collection<?> src, int srcPos, int len) {
        return unboxShorts(src.toArray(), srcPos, len);
    }

    /**
     * Transforms a collection of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code boolean}.
     * @param src source collection
     * @return array of boolean
     */
    public static boolean[] unboxBooleans(Collection<?> src) {
        return unboxBooleans(src.toArray(), 0, -1);
    }

    /**
     * Transforms a collection of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code byte}.
     * @param src source collection
     * @return array of byte
     */
    public static byte[] unboxBytes(Collection<?> src) {
        return unboxBytes(src.toArray(), 0, -1);
    }

    /**
     * Transforms a collection of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code char}.
     * @param src source collection
     * @return array of char
     */
    public static char[] unboxCharacters(Collection<?> src) {
        return unboxCharacters(src.toArray(), 0, -1);
    }

    /**
     * Transforms a collection of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code float}.
     * @param src source collection
     * @return array of float
     */
    public static float[] unboxFloats(Collection<?> src) {
        return unboxFloats(src.toArray(), 0, -1);
    }

    /**
     * Transforms a collection of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code double}.
     * @param src source collection
     * @return array of double
     */
    public static double[] unboxDoubles(Collection<?> src) {
        return unboxDoubles(src.toArray(), 0, -1);
    }

    /**
     * Transforms a collection of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code int}.
     * @param src source collection
     * @return array of int
     */
    public static int[] unboxIntegers(Collection<?> src) {
        return unboxIntegers(src.toArray(), 0, -1);
    }

    /**
     * Transforms a collection of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code long}.
     * @param src source collection
     * @return array of long
     */
    public static long[] unboxLongs(Collection<?> src) {
        return unboxLongs(src.toArray(), 0, -1);
    }

    /**
     * Transforms a collection of {@code Boolean}, {@code Character}, or {@code Number}
     * into an array of {@code short}.
     * @param src source collection
     * @return array of short
     */
    public static short[] unboxShorts(Collection<?> src) {
        return unboxShorts(src.toArray(), 0, -1);
    }

    /**
     * Transforms an array of {@code Boolean}
     * into an array of {@code boolean}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of boolean
     */
    public static boolean[] unbox(Boolean[] src, int srcPos, int len) {
        return unboxBooleans(src, srcPos, len);
    }

    /**
     * Transforms an array of {@code Byte}
     * into an array of {@code byte}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of byte
     */
    public static byte[] unbox(Byte[] src, int srcPos, int len) {
        return unboxBytes(src, srcPos, len);
    }

    /**
     * Transforms an array of {@code Character}
     * into an array of {@code char}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of char
     */
    public static char[] unbox(Character[] src, int srcPos, int len) {
        return unboxCharacters(src, srcPos, len);
    }

    /**
     * Transforms an array of {@code Float}
     * into an array of {@code float}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of float
     */
    public static float[] unbox(Float[] src, int srcPos, int len) {
        return unboxFloats(src, srcPos, len);
    }

    /**
     * Transforms an array of {@code Double}
     * into an array of {@code double}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of double
     */
    public static double[] unbox(Double[] src, int srcPos, int len) {
        return unboxDoubles(src, srcPos, len);
    }

    /**
     * Transforms an array of {@code Integer}
     * into an array of {@code int}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of int
     */
    public static int[] unbox(Integer[] src, int srcPos, int len) {
        return unboxIntegers(src, srcPos, len);
    }

    /**
     * Transforms an array of {@code Long}
     * into an array of {@code long}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of long
     */
    public static long[] unbox(Long[] src, int srcPos, int len) {
        return unboxLongs(src, srcPos, len);
    }

    /**
     * Transforms an array of {@code Short}
     * into an array of {@code short}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of short
     */
    public static short[] unbox(Short[] src, int srcPos, int len) {
        return unboxShorts(src, srcPos, len);
    }

    /**
     * Transforms an array of {@code Boolean}
     * into an array of {@code boolean}.
     * @param src source array
     * @return array of boolean
     */
    public static boolean[] unbox(Boolean[] src) {
        return unboxBooleans(src);
    }

    /**
     * Transforms an array of {@code Byte}
     * into an array of {@code byte}.
     * @param src source array
     * @return array of byte
     */
    public static byte[] unbox(Byte[] src) {
        return unboxBytes(src);
    }

    /**
     * Transforms an array of {@code Character}
     * into an array of {@code char}.
     * @param src source array
     * @return array of char
     */
    public static char[] unbox(Character[] src) {
        return unboxCharacters(src);
    }

    /**
     * Transforms an array of {@code Float}
     * into an array of {@code float}.
     * @param src source array
     * @return array of float
     */
    public static float[] unbox(Float[] src) {
        return unboxFloats(src);
    }

    /**
     * Transforms an array of {@code Double}
     * into an array of {@code double}.
     * @param src source array
     * @return array of double
     */
    public static double[] unbox(Double[] src) {
        return unboxDoubles(src);
    }

    /**
     * Transforms an array of {@code Integer}
     * into an array of {@code int}.
     * @param src source array
     * @return array of int
     */
    public static int[] unbox(Integer[] src) {
        return unboxIntegers(src);
    }

    /**
     * Transforms an array of {@code Long}
     * into an array of {@code long}.
     * @param src source array
     * @return array of long
     */
    public static long[] unbox(Long[] src) {
        return unboxLongs(src);
    }

    /**
     * Transforms an array of {@code Short}
     * into an array of {@code short}.
     * @param src source array
     * @return array of short
     */
    public static short[] unbox(Short[] src) {
        return unboxShorts(src);
    }
    
    /**
     * Transforms any {@code Boolean}, {@code Character}, or {@code Number}
     * into a {@code Boolean}.
     * @param b boxed value
     * @return Boolean
     */
    public static Boolean boxBoolean(Object b) {
        if (b instanceof Boolean) {
            return (Boolean) b;
        } else {
            return unboxBoolean(b);
        }
    }
    
    /**
     * Transforms any {@code Boolean}, {@code Character}, or {@code Number}
     * into a {@code Byte}.
     * @param b boxed value
     * @return Byte
     */
    public static Byte boxByte(Object b) {
        if (b instanceof Byte) {
            return (Byte) b;
        } else {
            return unboxByte(b);
        }
    }
    
    /**
     * Transforms any {@code Boolean}, {@code Character}, or {@code Number}
     * into a {@code Character}.
     * @param b boxed value
     * @return Character
     */
    public static Character boxCharacter(Object b) {
        if (b instanceof Character) {
            return (Character) b;
        } else {
            return unboxCharacter(b);
        }
    }
    
    /**
     * Transforms any {@code Boolean}, {@code Character}, or {@code Number}
     * into a {@code Float}.
     * @param b boxed value
     * @return Float
     */
    public static Float boxFloat(Object b) {
        if (b instanceof Float) {
            return (Float) b;
        } else {
            return unboxFloat(b);
        }
    }
    
    /**
     * Transforms any {@code Boolean}, {@code Character}, or {@code Number}
     * into a {@code Double}.
     * @param b boxed value
     * @return Double
     */
    public static Double boxDouble(Object b) {
        if (b instanceof Double) {
            return (Double) b;
        } else {
            return unboxDouble(b);
        }
    }
    
    /**
     * Transforms any {@code Boolean}, {@code Character}, or {@code Number}
     * into a {@code Integer}.
     * @param b boxed value
     * @return Integer
     */
    public static Integer boxInteger(Object b) {
        if (b instanceof Integer) {
            return (Integer) b;
        } else {
            return unboxInteger(b);
        }
    }
    
    /**
     * Transforms any {@code Boolean}, {@code Character}, or {@code Number}
     * into a {@code Long}.
     * @param b boxed value
     * @return Long
     */
    public static Long boxLong(Object b) {
        if (b instanceof Long) {
            return (Long) b;
        } else {
            return unboxLong(b);
        }
    }
    
    /**
     * Transforms any {@code Boolean}, {@code Character}, or {@code Number}
     * into a {@code Short}.
     * @param b boxed value
     * @return Short
     */
    public static Short boxShort(Object b) {
        if (b instanceof Short) {
            return (Short) b;
        } else {
            return unboxShort(b);
        }
    }
    
    /**
     * Transforms an {@link Array} into an array of {@code Boolean}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Boolean
     */
    public static Boolean[] boxBooleans(Array src, int srcPos, int len) {
        if (len < 0) len = src.length() - srcPos + len + 1;
        final Boolean[] result = new Boolean[len];
        for (int i = 0; i < len; i++) {
            result[i] = src.getBoolean(srcPos + i);
        }
        return result;
    }

    /**
     * Transforms an array of {@code boolean}
     * into an array of {@code Boolean}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Boolean
     */
    public static Boolean[] boxBooleans(boolean[] src, int srcPos, int len) {
        if (len < 0) len = src.length - srcPos + len + 1;
        final Boolean[] result = new Boolean[len];
        for (int i = 0; i < len; i++) {
            result[i] = src[srcPos + i];
        }
        return result;
    }
    
    /**
     * Transforms an {@link Array} into an array of {@code Byte}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Byte
     */
    public static Byte[] boxBytes(Array src, int srcPos, int len) {
        if (len < 0) len = src.length() - srcPos + len + 1;
        final Byte[] result = new Byte[len];
        for (int i = 0; i < len; i++) {
            result[i] = src.getByte(srcPos + i);
        }
        return result;
    }

    /**
     * Transforms an array of {@code byte}
     * into an array of {@code Byte}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Byte
     */
    public static Byte[] boxBytes(byte[] src, int srcPos, int len) {
        if (len < 0) len = src.length - srcPos + len + 1;
        final Byte[] result = new Byte[len];
        for (int i = 0; i < len; i++) {
            result[i] = src[srcPos + i];
        }
        return result;
    }
    
    /**
     * Transforms an {@link Array} into an array of {@code Character}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Character
     */
    public static Character[] boxCharacters(Array src, int srcPos, int len) {
        if (len < 0) len = src.length() - srcPos + len + 1;
        final Character[] result = new Character[len];
        for (int i = 0; i < len; i++) {
            result[i] = src.getCharacter(srcPos + i);
        }
        return result;
    }

    /**
     * Transforms an array of {@code char}
     * into an array of {@code Character}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Character
     */
    public static Character[] boxCharacters(char[] src, int srcPos, int len) {
        if (len < 0) len = src.length - srcPos + len + 1;
        final Character[] result = new Character[len];
        for (int i = 0; i < len; i++) {
            result[i] = src[srcPos + i];
        }
        return result;
    }
    
    /**
     * Transforms an {@link Array} into an array of {@code Float}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Float
     */
    public static Float[] boxFloats(Array src, int srcPos, int len) {
        if (len < 0) len = src.length() - srcPos + len + 1;
        final Float[] result = new Float[len];
        for (int i = 0; i < len; i++) {
            result[i] = src.getFloat(srcPos + i);
        }
        return result;
    }

    /**
     * Transforms an array of {@code float}
     * into an array of {@code Float}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Float
     */
    public static Float[] boxFloats(float[] src, int srcPos, int len) {
        if (len < 0) len = src.length - srcPos + len + 1;
        final Float[] result = new Float[len];
        for (int i = 0; i < len; i++) {
            result[i] = src[srcPos + i];
        }
        return result;
    }
    
    /**
     * Transforms an {@link Array} into an array of {@code Double}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Double
     */
    public static Double[] boxDoubles(Array src, int srcPos, int len) {
        if (len < 0) len = src.length() - srcPos + len + 1;
        final Double[] result = new Double[len];
        for (int i = 0; i < len; i++) {
            result[i] = src.getDouble(srcPos + i);
        }
        return result;
    }

    /**
     * Transforms an array of {@code double}
     * into an array of {@code Double}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Double
     */
    public static Double[] boxDoubles(double[] src, int srcPos, int len) {
        if (len < 0) len = src.length - srcPos + len + 1;
        final Double[] result = new Double[len];
        for (int i = 0; i < len; i++) {
            result[i] = src[srcPos + i];
        }
        return result;
    }
    
    /**
     * Transforms an {@link Array} into an array of {@code Integer}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Integer
     */
    public static Integer[] boxIntegers(Array src, int srcPos, int len) {
        if (len < 0) len = src.length() - srcPos + len + 1;
        final Integer[] result = new Integer[len];
        for (int i = 0; i < len; i++) {
            result[i] = src.getInteger(srcPos + i);
        }
        return result;
    }

    /**
     * Transforms an array of {@code int}
     * into an array of {@code Integer}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Integer
     */
    public static Integer[] boxIntegers(int[] src, int srcPos, int len) {
        if (len < 0) len = src.length - srcPos + len + 1;
        final Integer[] result = new Integer[len];
        for (int i = 0; i < len; i++) {
            result[i] = src[srcPos + i];
        }
        return result;
    }
    
    /**
     * Transforms an {@link Array} into an array of {@code Long}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Long
     */
    public static Long[] boxLongs(Array src, int srcPos, int len) {
        if (len < 0) len = src.length() - srcPos + len + 1;
        final Long[] result = new Long[len];
        for (int i = 0; i < len; i++) {
            result[i] = src.getLong(srcPos + i);
        }
        return result;
    }

    /**
     * Transforms an array of {@code long}
     * into an array of {@code Long}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Long
     */
    public static Long[] boxLongs(long[] src, int srcPos, int len) {
        if (len < 0) len = src.length - srcPos + len + 1;
        final Long[] result = new Long[len];
        for (int i = 0; i < len; i++) {
            result[i] = src[srcPos + i];
        }
        return result;
    }
    
    /**
     * Transforms an {@link Array} into an array of {@code Short}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Short
     */
    public static Short[] boxShorts(Array src, int srcPos, int len) {
        if (len < 0) len = src.length() - srcPos + len + 1;
        final Short[] result = new Short[len];
        for (int i = 0; i < len; i++) {
            result[i] = src.getShort(srcPos + i);
        }
        return result;
    }

    /**
     * Transforms an array of {@code short}
     * into an array of {@code Short}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Short
     */
    public static Short[] boxShorts(short[] src, int srcPos, int len) {
        if (len < 0) len = src.length - srcPos + len + 1;
        final Short[] result = new Short[len];
        for (int i = 0; i < len; i++) {
            result[i] = src[srcPos + i];
        }
        return result;
    }
    
    /**
     * Transforms an array of {@code boolean}
     * into an array of {@code Boolean}.
     * @param src source array
     * @return array of Boolean
     */
    public static Boolean[] boxBooleans(boolean[] src) {
        return boxBooleans(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code byte}
     * into an array of {@code Byte}.
     * @param src source array
     * @return array of Byte
     */
    public static Byte[] boxBytes(byte[] src) {
        return boxBytes(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code char}
     * into an array of {@code Character}.
     * @param src source array
     * @return array of Character
     */
    public static Character[] boxCharacters(char[] src) {
        return boxCharacters(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code float}
     * into an array of {@code Float}.
     * @param src source array
     * @return array of Float
     */
    public static Float[] boxFloats(float[] src) {
        return boxFloats(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code double}
     * into an array of {@code Double}.
     * @param src source array
     * @return array of Double
     */
    public static Double[] boxDoubles(double[] src) {
        return boxDoubles(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code int}
     * into an array of {@code Integer}.
     * @param src source array
     * @return array of Integer
     */
    public static Integer[] boxIntegers(int[] src) {
        return boxIntegers(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code long}
     * into an array of {@code Long}.
     * @param src source array
     * @return array of Long
     */
    public static Long[] boxLongs(long[] src) {
        return boxLongs(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code short}
     * into an array of {@code Short}.
     * @param src source array
     * @return array of Short
     */
    public static Short[] boxShorts(short[] src) {
        return boxShorts(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code boolean}
     * into an array of {@code Boolean}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Boolean
     */
    public static Boolean[] box(boolean[] src, int srcPos, int len) {
        return boxBooleans(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code byte}
     * into an array of {@code Byte}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Byte
     */
    public static Byte[] box(byte[] src, int srcPos, int len) {
        return boxBytes(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code char}
     * into an array of {@code Character}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Character
     */
    public static Character[] box(char[] src, int srcPos, int len) {
        return boxCharacters(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code float}
     * into an array of {@code Float}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Float
     */
    public static Float[] box(float[] src, int srcPos, int len) {
        return boxFloats(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code double}
     * into an array of {@code Double}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Double
     */
    public static Double[] box(double[] src, int srcPos, int len) {
        return boxDoubles(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code int}
     * into an array of {@code Integer}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Integer
     */
    public static Integer[] box(int[] src, int srcPos, int len) {
        return boxIntegers(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code long}
     * into an array of {@code Long}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Long
     */
    public static Long[] box(long[] src, int srcPos, int len) {
        return boxLongs(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code short}
     * into an array of {@code Short}.
     * @param src source array
     * @param srcPos start position
     * @param len length
     * @return array of Short
     */
    public static Short[] box(short[] src, int srcPos, int len) {
        return boxShorts(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code boolean}
     * into an array of {@code Boolean}.
     * @param src source array
     * @return array of Boolean
     */
    public static Boolean[] box(boolean[] src) {
        return boxBooleans(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code byte}
     * into an array of {@code Byte}.
     * @param src source array
     * @return array of Byte
     */
    public static Byte[] box(byte[] src) {
        return boxBytes(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code char}
     * into an array of {@code Character}.
     * @param src source array
     * @return array of Character
     */
    public static Character[] box(char[] src) {
        return boxCharacters(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code float}
     * into an array of {@code Float}.
     * @param src source array
     * @return array of Float
     */
    public static Float[] box(float[] src) {
        return boxFloats(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code double}
     * into an array of {@code Double}.
     * @param src source array
     * @return array of Double
     */
    public static Double[] box(double[] src) {
        return boxDoubles(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code int}
     * into an array of {@code Integer}.
     * @param src source array
     * @return array of Integer
     */
    public static Integer[] box(int[] src) {
        return boxIntegers(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code long}
     * into an array of {@code Long}.
     * @param src source array
     * @return array of Long
     */
    public static Long[] box(long[] src) {
        return boxLongs(src, 0, -1);
    }
    
    /**
     * Transforms an array of {@code short}
     * into an array of {@code Short}.
     * @param src source array
     * @return array of Short
     */
    public static Short[] box(short[] src) {
        return boxShorts(src, 0, -1);
    }

    /**
     * Creates an {@link Array}.
     * @param array source array
     * @return array
     */
    public static Array array(boolean[] array) {
        return new BooleanArray(array);
    }

    /**
     * Creates an {@link Array}.
     * @param array source array
     * @return array
     */
    public static Array array(byte[] array) {
        return new ByteArray(array);
    }

    /**
     * Creates an {@link Array}.
     * @param array source array
     * @return array
     */
    public static Array array(char[] array) {
        return new CharacterArray(array);
    }

    /**
     * Creates an {@link Array}.
     * @param array source array
     * @return array
     */
    public static Array array(float[] array) {
        return new FloatArray(array);
    }

    /**
     * Creates an {@link Array}.
     * @param array source array
     * @return array
     */
    public static Array array(double[] array) {
        return new DoubleArray(array);
    }

    /**
     * Creates an {@link Array}.
     * @param array source array
     * @return array
     */
    public static Array array(int[] array) {
        return new IntegerArray(array);
    }

    /**
     * Creates an {@link Array}.
     * @param array source array
     * @return array
     */
    public static Array array(long[] array) {
        return new LongArray(array);
    }

    /**
     * Creates an {@link Array}.
     * @param array source array
     * @return array
     */
    public static Array array(short[] array) {
        return new ShortArray(array);
    }

    /**
     * Creates an {@link Array}.
     * @param array source array
     * @return array
     */
    public static Array array(Object[] array) {
        return new ObjectArray(array);
    }

    /**
     * Represents an array of {@code Boolean}, {@code Character}, {@code Number},
     * or any primitive type.
     * Allows to access each item as any type.
     */
    public static abstract class Array {
        public abstract int length();
        public abstract boolean getBooleanValue(int i);
        public abstract byte getByteValue(int i);
        public abstract char getCharacterValue(int i);
        public abstract float getFloatValue(int i);
        public abstract double getDoubleValue(int i);
        public abstract int getIntegerValue(int i);
        public abstract long getLongValue(int i);
        public abstract short getShortValue(int i);
        public abstract Boolean getBoolean(int i);
        public abstract Byte getByte(int i);
        public abstract Character getCharacter(int i);
        public abstract Float getFloat(int i);
        public abstract Double getDouble(int i);
        public abstract Integer getInteger(int i);
        public abstract Long getLong(int i);
        public abstract Short getShort(int i);
    }

    private static abstract class PrimArray extends Array {
        @Override
        public Boolean getBoolean(int i) {
            return getBooleanValue(i);
        }
        @Override
        public Byte getByte(int i) {
            return getByteValue(i);
        }
        @Override
        public Character getCharacter(int i) {
            return getCharacterValue(i);
        }
        @Override
        public Float getFloat(int i) {
            return getFloatValue(i);
        }
        @Override
        public Double getDouble(int i) {
            return getDoubleValue(i);
        }
        @Override
        public Integer getInteger(int i) {
            return getIntegerValue(i);
        }
        @Override
        public Long getLong(int i) {
            return getLongValue(i);
        }
        @Override
        public Short getShort(int i) {
            return getShortValue(i);
        }
    }

    private static final class BooleanArray extends PrimArray {
        private final boolean[] array;
        public BooleanArray(boolean[] array) {
            this.array = array;
        }
        @Override
        public int length() {
            return array.length;
        }
        @Override
        public boolean getBooleanValue(int i) {
            return array[i];
        }
        @Override
        public byte getByteValue(int i) {
            return unboxByte(array[i]);
        }
        @Override
        public char getCharacterValue(int i) {
            return unboxCharacter(array[i]);
        }
        @Override
        public float getFloatValue(int i) {
            return unboxFloat(array[i]);
        }
        @Override
        public double getDoubleValue(int i) {
            return unboxDouble(array[i]);
        }
        @Override
        public int getIntegerValue(int i) {
            return unboxInteger(array[i]);
        }
        @Override
        public long getLongValue(int i) {
            return unboxLong(array[i]);
        }
        @Override
        public short getShortValue(int i) {
            return unboxShort(array[i]);
        }
    }

    private static final class ByteArray extends PrimArray {
        private final byte[] array;
        public ByteArray(byte[] array) {
            this.array = array;
        }
        @Override
        public int length() {
            return array.length;
        }
        @Override
        public boolean getBooleanValue(int i) {
            return unboxBoolean(array[i]);
        }
        @Override
        public byte getByteValue(int i) {
            return (byte) array[i];
        }
        @Override
        public char getCharacterValue(int i) {
            return (char) array[i];
        }
        @Override
        public float getFloatValue(int i) {
            return (float) array[i];
        }
        @Override
        public double getDoubleValue(int i) {
            return (double) array[i];
        }
        @Override
        public int getIntegerValue(int i) {
            return (int) array[i];
        }
        @Override
        public long getLongValue(int i) {
            return (long) array[i];
        }
        @Override
        public short getShortValue(int i) {
            return (short) array[i];
        }
    }

    private static final class CharacterArray extends PrimArray {
        private final char[] array;
        public CharacterArray(char[] array) {
            this.array = array;
        }
        @Override
        public int length() {
            return array.length;
        }
        @Override
        public boolean getBooleanValue(int i) {
            return unboxBoolean(array[i]);
        }
        @Override
        public byte getByteValue(int i) {
            return (byte) array[i];
        }
        @Override
        public char getCharacterValue(int i) {
            return (char) array[i];
        }
        @Override
        public float getFloatValue(int i) {
            return (float) array[i];
        }
        @Override
        public double getDoubleValue(int i) {
            return (double) array[i];
        }
        @Override
        public int getIntegerValue(int i) {
            return (int) array[i];
        }
        @Override
        public long getLongValue(int i) {
            return (long) array[i];
        }
        @Override
        public short getShortValue(int i) {
            return (short) array[i];
        }
    }

    private static final class FloatArray extends PrimArray {
        private final float[] array;
        public FloatArray(float[] array) {
            this.array = array;
        }
        @Override
        public int length() {
            return array.length;
        }
        @Override
        public boolean getBooleanValue(int i) {
            return unboxBoolean(array[i]);
        }
        @Override
        public byte getByteValue(int i) {
            return (byte) array[i];
        }
        @Override
        public char getCharacterValue(int i) {
            return (char) array[i];
        }
        @Override
        public float getFloatValue(int i) {
            return (float) array[i];
        }
        @Override
        public double getDoubleValue(int i) {
            return (double) array[i];
        }
        @Override
        public int getIntegerValue(int i) {
            return (int) array[i];
        }
        @Override
        public long getLongValue(int i) {
            return (long) array[i];
        }
        @Override
        public short getShortValue(int i) {
            return (short) array[i];
        }
    }

    private static final class DoubleArray extends PrimArray {
        private final double[] array;
        public DoubleArray(double[] array) {
            this.array = array;
        }
        @Override
        public int length() {
            return array.length;
        }
        @Override
        public boolean getBooleanValue(int i) {
            return unboxBoolean(array[i]);
        }
        @Override
        public byte getByteValue(int i) {
            return (byte) array[i];
        }
        @Override
        public char getCharacterValue(int i) {
            return (char) array[i];
        }
        @Override
        public float getFloatValue(int i) {
            return (float) array[i];
        }
        @Override
        public double getDoubleValue(int i) {
            return (double) array[i];
        }
        @Override
        public int getIntegerValue(int i) {
            return (int) array[i];
        }
        @Override
        public long getLongValue(int i) {
            return (long) array[i];
        }
        @Override
        public short getShortValue(int i) {
            return (short) array[i];
        }
    }

    private static final class IntegerArray extends PrimArray {
        private final int[] array;
        public IntegerArray(int[] array) {
            this.array = array;
        }
        @Override
        public int length() {
            return array.length;
        }
        @Override
        public boolean getBooleanValue(int i) {
            return unboxBoolean(array[i]);
        }
        @Override
        public byte getByteValue(int i) {
            return (byte) array[i];
        }
        @Override
        public char getCharacterValue(int i) {
            return (char) array[i];
        }
        @Override
        public float getFloatValue(int i) {
            return (float) array[i];
        }
        @Override
        public double getDoubleValue(int i) {
            return (double) array[i];
        }
        @Override
        public int getIntegerValue(int i) {
            return (int) array[i];
        }
        @Override
        public long getLongValue(int i) {
            return (long) array[i];
        }
        @Override
        public short getShortValue(int i) {
            return (short) array[i];
        }
    }

    private static final class LongArray extends PrimArray {
        private final long[] array;
        public LongArray(long[] array) {
            this.array = array;
        }
        @Override
        public int length() {
            return array.length;
        }
        @Override
        public boolean getBooleanValue(int i) {
            return unboxBoolean(array[i]);
        }
        @Override
        public byte getByteValue(int i) {
            return (byte) array[i];
        }
        @Override
        public char getCharacterValue(int i) {
            return (char) array[i];
        }
        @Override
        public float getFloatValue(int i) {
            return (float) array[i];
        }
        @Override
        public double getDoubleValue(int i) {
            return (double) array[i];
        }
        @Override
        public int getIntegerValue(int i) {
            return (int) array[i];
        }
        @Override
        public long getLongValue(int i) {
            return (long) array[i];
        }
        @Override
        public short getShortValue(int i) {
            return (short) array[i];
        }
    }

    private static final class ShortArray extends PrimArray {
        private final short[] array;
        public ShortArray(short[] array) {
            this.array = array;
        }
        @Override
        public int length() {
            return array.length;
        }
        @Override
        public boolean getBooleanValue(int i) {
            return unboxBoolean(array[i]);
        }
        @Override
        public byte getByteValue(int i) {
            return (byte) array[i];
        }
        @Override
        public char getCharacterValue(int i) {
            return (char) array[i];
        }
        @Override
        public float getFloatValue(int i) {
            return (float) array[i];
        }
        @Override
        public double getDoubleValue(int i) {
            return (double) array[i];
        }
        @Override
        public int getIntegerValue(int i) {
            return (int) array[i];
        }
        @Override
        public long getLongValue(int i) {
            return (long) array[i];
        }
        @Override
        public short getShortValue(int i) {
            return (short) array[i];
        }
    }

    private static final class ObjectArray extends Array {
        private final Object[] array;
        public ObjectArray(Object[] array) {
            this.array = array;
        }
        @Override
        public int length() {
            return array.length;
        }
        @Override
        public boolean getBooleanValue(int i) {
            return unboxBoolean(array[i]);
        }
        @Override
        public byte getByteValue(int i) {
            return unboxByte(array[i]);
        }
        @Override
        public char getCharacterValue(int i) {
            return unboxCharacter(array[i]);
        }
        @Override
        public float getFloatValue(int i) {
            return unboxFloat(array[i]);
        }
        @Override
        public double getDoubleValue(int i) {
            return unboxDouble(array[i]);
        }
        @Override
        public int getIntegerValue(int i) {
            return unboxInteger(array[i]);
        }
        @Override
        public long getLongValue(int i) {
            return unboxLong(array[i]);
        }
        @Override
        public short getShortValue(int i) {
            return unboxShort(array[i]);
        }
        @Override
        public Boolean getBoolean(int i) {
            return boxBoolean(array[i]);
        }
        @Override
        public Byte getByte(int i) {
            return boxByte(array[i]);
        }
        @Override
        public Character getCharacter(int i) {
            return boxCharacter(array[i]);
        }
        @Override
        public Float getFloat(int i) {
            return boxFloat(array[i]);
        }
        @Override
        public Double getDouble(int i) {
            return boxDouble(array[i]);
        }
        @Override
        public Integer getInteger(int i) {
            return boxInteger(array[i]);
        }
        @Override
        public Long getLong(int i) {
            return boxLong(array[i]);
        }
        @Override
        public Short getShort(int i) {
            return boxShort(array[i]);
        }
    }
}
