/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.resolve;

import java.net.URL;
import java.util.Map;
import org.cthul.resolve.RRequest;
import org.cthul.resolve.RResult;
import org.cthul.resolve.UriMappingResolver;
import org.cthul.resolve.results.URLResult;

public class ClassLoaderResourceResolver
extends UriMappingResolver {
    private final ClassLoader clazzLoader;

    private static ClassLoader getClassLoader(ClassLoader cl) {
        if (cl != null) {
            return cl;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public ClassLoaderResourceResolver() {
        this((ClassLoader)null);
    }

    public ClassLoaderResourceResolver(ClassLoader cl) {
        this.clazzLoader = ClassLoaderResourceResolver.getClassLoader(cl);
    }

    public ClassLoaderResourceResolver(ClassLoader cl, String ... schemas) {
        super(schemas);
        this.clazzLoader = ClassLoaderResourceResolver.getClassLoader(cl);
    }

    public ClassLoaderResourceResolver(ClassLoader cl, Map<String, String> schemas) {
        super(schemas);
        this.clazzLoader = ClassLoaderResourceResolver.getClassLoader(cl);
    }

    @Override
    protected RResult get(RRequest request, String source) {
        URL url = this.clazzLoader.getResource(source);
        if (url == null) {
            return null;
        }
        return new URLResult(request, url);
    }
}

