/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.resolve;

import java.util.Collection;
import org.cthul.resolve.RRequest;
import org.cthul.resolve.RResponse;
import org.cthul.resolve.ResourceResolver;
import org.cthul.resolve.ResourceResolverBase;
import org.cthul.resolve.ResponseBuilder;

public class CompositeResolver
extends ResourceResolverBase {
    private final ResourceResolver[] inputs;

    public static CompositeResolver all(ResourceResolver r0, ResourceResolver ... more) {
        return CompositeResolver.join(r0, more);
    }

    public static CompositeResolver join(ResourceResolver r0, ResourceResolver ... more) {
        ResourceResolver[] all = new ResourceResolver[more.length + 1];
        all[0] = r0;
        System.arraycopy(more, 0, all, 1, more.length);
        return new CompositeResolver(false, all);
    }

    public CompositeResolver(ResourceResolver ... inputs) {
        this(true, inputs);
    }

    public CompositeResolver(Collection<? extends ResourceResolver> inputs) {
        this(false, inputs.toArray(new ResourceResolver[inputs.size()]));
    }

    protected CompositeResolver(boolean clone, ResourceResolver ... inputs) {
        this.inputs = clone ? (ResourceResolver[])inputs.clone() : inputs;
    }

    @Override
    public RResponse resolve(RRequest request) {
        ResponseBuilder response = request.noResultResponse();
        for (ResourceResolver r : this.inputs) {
            RResponse res = r.resolve(request);
            if (res.hasResult()) {
                return response.withResult(res.getResult());
            }
            response = response.withResponse(res);
        }
        return response;
    }

    @Override
    public ResourceResolver immutable() {
        return this;
    }

    public String toString() {
        if (this.inputs.length == 1) {
            String cn = this.getClass().getSimpleName();
            if (cn.equals("CompositeResolver")) {
                cn = "";
            }
            return cn + "[" + this.inputs[0] + "]";
        }
        return this.getClass().getSimpleName() + "(" + this.inputs.length + ")";
    }
}

