/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.resolve;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.cthul.resolve.RRequest;
import org.cthul.resolve.RResponse;
import org.cthul.resolve.UriMappingResolver;
import org.cthul.resolve.results.FileResult;

public class FileResolver
extends UriMappingResolver {
    private final Path base;
    private final Path canonicalBase;

    public FileResolver(Path base, Path check) {
        this.base = base;
        this.canonicalBase = check != null ? base.resolve(check).normalize().toAbsolutePath() : null;
    }

    public FileResolver(File base, String check) {
        this(base != null ? Paths.get(base.toURI()) : null, check != null ? Paths.get(check, new String[0]) : null);
    }

    public FileResolver() {
        this((File)null, (String)null);
    }

    public FileResolver(String base) {
        this(new File(base));
    }

    public FileResolver(File base) {
        this(base, base);
    }

    public FileResolver(File base, File check) {
        this(base, FileResolver.canonicalPath(check));
    }

    @Override
    public UriMappingResolver lookupAll() {
        this.addDomain("file:/");
        return super.lookupAll();
    }

    private static String canonicalPath(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected RResponse get(RRequest request, String source) {
        Path p;
        try {
            p = this.base != null ? this.base.resolve(source).normalize() : Paths.get(source, new String[0]);
        }
        catch (InvalidPathException e) {
            return request.noResultResponse().withWarning(e);
        }
        if (this.canonicalBase != null && !p.toAbsolutePath().startsWith(this.canonicalBase)) {
            return null;
        }
        if (!Files.isRegularFile(p, new LinkOption[0])) {
            return null;
        }
        return new FileResult(request, p);
    }

    @Override
    public String toString() {
        String m = this.getMappingString();
        return this.getClass().getSimpleName() + "(" + (this.base == null ? "" : this.base) + (m.isEmpty() ? "" : ": " + m) + ")";
    }
}

