/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.resolve;

import org.cthul.resolve.CompositeResolver;
import org.cthul.resolve.RRequest;
import org.cthul.resolve.RResponse;
import org.cthul.resolve.RResult;
import org.cthul.resolve.ResourceResolver;

public abstract class ObjectResolver<T, E extends Exception> {
    protected final ResourceResolver resolver;

    public ObjectResolver(ResourceResolver resolver) {
        this.resolver = resolver;
    }

    public ObjectResolver(ResourceResolver ... resolver) {
        this((ResourceResolver)new CompositeResolver(resolver));
    }

    protected T resolve(String uri, String publicId, String systemId, String baseURI) throws E {
        RRequest req = new RRequest(uri, publicId, systemId, baseURI);
        return this.resolve(req);
    }

    protected T resolve(String uri) throws E {
        RRequest req = new RRequest(uri);
        return this.resolve(req);
    }

    protected T resolve(String systemId, String baseURI) throws E {
        RRequest req = new RRequest(systemId, baseURI);
        return this.resolve(req);
    }

    protected T resolve(RRequest req) throws E {
        RResponse res = this.resolver.resolve(req);
        if (res == null) {
            res = req.noResultResponse();
        }
        if (res.hasResult()) {
            RResult result = res.getResult();
            this.log_resolved(result);
            return this.result(result);
        }
        this.log_notFound(res);
        return this.noResult(res);
    }

    protected void log_notFound(RResponse res) {
    }

    protected void log_resolved(RResult res) {
    }

    protected T noResult(RResponse res) throws E {
        return null;
    }

    protected abstract T result(RResult var1) throws E;
}

