/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.resolve;

import java.net.URI;
import java.net.URISyntaxException;
import org.cthul.resolve.ResolvingException;
import org.cthul.resolve.ResponseBuilder;

public class RRequest {
    static final String NULL_STR = new String();
    private final String uri;
    private final String publicId;
    private final String systemId;
    private final String baseUri;
    private String resolvedSystemId = NULL_STR;
    private ResponseBuilder noResult = null;

    public RRequest(String uri, String publicId, String systemId, String baseUri) {
        this.uri = uri;
        this.publicId = publicId;
        this.systemId = systemId;
        this.baseUri = baseUri;
    }

    public RRequest(String systemId, String baseUri) {
        this.uri = null;
        this.publicId = null;
        this.systemId = systemId;
        this.baseUri = baseUri;
    }

    public RRequest(String uri) {
        this.uri = uri;
        this.publicId = null;
        this.systemId = null;
        this.baseUri = null;
    }

    public String getUri() {
        return this.uri;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public String getUriOrId() {
        String u = this.getUri();
        if (u != null) {
            return u;
        }
        return this.getResolvedSystemId();
    }

    public String getResolvedSystemId() {
        if (this.resolvedSystemId == NULL_STR) {
            this.resolvedSystemId = this.resolveSystemId();
        }
        return this.resolvedSystemId;
    }

    protected String resolveSystemId() {
        return this.expandSystemId(this.getBaseUri(), this.getSystemId());
    }

    protected String expandSystemId(String baseId, String systemId) {
        if (baseId == null || baseId.isEmpty()) {
            return systemId;
        }
        if (systemId == null || systemId.isEmpty()) {
            return baseId;
        }
        try {
            return new URI(baseId).resolve(new URI(systemId)).toASCIIString();
        }
        catch (URISyntaxException ex) {
            throw new ResolvingException(this.toString(), (Throwable)ex);
        }
    }

    public ResponseBuilder noResultResponse() {
        if (this.noResult == null) {
            this.noResult = ResponseBuilder.noResult(this);
        }
        return this.noResult;
    }

    public String toString() {
        String s = this.getUri();
        if (s == null && this.resolvedSystemId != NULL_STR) {
            s = this.resolvedSystemId;
        }
        if (s == null) {
            s = this.getSystemId();
        }
        if (s == null) {
            s = this.getPublicId();
        }
        if (s == null) {
            return "RRequest@" + Integer.toHexString(this.hashCode());
        }
        return "RRequest(" + s + ")";
    }
}

