/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.resolve;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cthul.resolve.RRequest;
import org.cthul.resolve.RResponse;
import org.cthul.resolve.ResolvingException;
import org.cthul.resolve.ResponseBuilder;

public abstract class RResult
implements RResponse {
    private final RRequest request;
    private final String systemId;
    private String resolvedSystemId = RRequest.NULL_STR;
    private String defaultEncoding = null;
    ResponseBuilder.WarningsList warnings = null;
    private static final int BUF_SIZE = 8192;

    public RResult(RRequest request) {
        this(request, null);
    }

    public RResult(RRequest request, String systemId) {
        this.request = request;
        this.systemId = systemId;
    }

    public RResult(String uri, String publicId, String systemId, String baseUri) {
        this(new RRequest(uri, publicId, systemId, baseUri), systemId);
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public RResult getResult() {
        return this;
    }

    @Override
    public List<Exception> getWarningsLog() {
        if (this.warnings == null) {
            return Collections.emptyList();
        }
        return this.warnings.asReadOnly();
    }

    @Override
    public ResolvingException asException() {
        return ResponseBuilder.asException(this.getRequest(), this.warnings);
    }

    @Override
    public RRequest getRequest() {
        return this.request;
    }

    public String getUri() {
        return this.request.getUri();
    }

    public String getPublicId() {
        return this.request.getPublicId();
    }

    public String getSystemId() {
        return this.systemId != null ? this.systemId : this.request.getSystemId();
    }

    public String getBaseUri() {
        return this.request.getBaseUri();
    }

    public String getUriOrId() {
        String uri = this.getUri();
        if (uri != null) {
            return uri;
        }
        return this.getResolvedSystemId();
    }

    public String getResolvedSystemId() {
        if (this.resolvedSystemId == RRequest.NULL_STR) {
            this.resolvedSystemId = this.resolveSystemId();
        }
        return this.resolvedSystemId;
    }

    protected String resolveSystemId() {
        String reqSysId;
        String mySysId = this.getSystemId();
        if (Objects.equals(mySysId, reqSysId = this.getRequest().getSystemId())) {
            return this.getRequest().getResolvedSystemId();
        }
        return this.expandSystemId(this.getBaseUri(), mySysId);
    }

    protected String expandSystemId(String baseId, String systemId) {
        return this.getRequest().expandSystemId(baseId, systemId);
    }

    public abstract ResultType getResultType();

    public Reader getReader() {
        try {
            return this.createReader();
        }
        catch (Exception e) {
            throw this.resolvingException(e);
        }
    }

    protected Reader createReader() throws Exception {
        return null;
    }

    public InputStream getInputStream() {
        try {
            return this.createInputStream();
        }
        catch (Exception e) {
            throw this.resolvingException(e);
        }
    }

    protected InputStream createInputStream() throws Exception {
        return null;
    }

    public String getString() {
        return null;
    }

    public ByteBuffer getByteBuffer() {
        try {
            return this.createByteBuffer();
        }
        catch (Exception e) {
            throw this.resolvingException(e);
        }
    }

    protected ByteBuffer createByteBuffer() throws Exception {
        return null;
    }

    public URLConnection getURLConnection() {
        try {
            return this.createURLConnection();
        }
        catch (Exception e) {
            throw this.resolvingException(e);
        }
    }

    protected URLConnection createURLConnection() throws Exception {
        URL url = this.getResourceURL();
        if (url == null) {
            return null;
        }
        URLConnection uc = url.openConnection();
        return uc;
    }

    public URL getResourceURL() throws Exception {
        return null;
    }

    protected URL getResourceURLOrSystemId() throws Exception {
        URL url = this.getResourceURL();
        if (url != null) {
            return url;
        }
        return new URL(this.getResolvedSystemId());
    }

    public void setDefaultEncoding(String enc) {
        this.defaultEncoding = enc;
    }

    public boolean trySetEncoding(String enc) {
        this.setDefaultEncoding(enc);
        return Objects.equals(enc, this.getEncoding());
    }

    public void setEncoding(String enc) {
        if (!this.trySetEncoding(enc)) {
            throw new IllegalStateException(this + ": cannot change encoding from " + this.getEncoding() + " to " + enc);
        }
    }

    public String getEncoding() {
        return this.defaultEncoding;
    }

    public Charset getCharset() {
        String enc = this.getEncoding();
        if (enc == null) {
            return Charset.defaultCharset();
        }
        return Charset.forName(enc);
    }

    public Reader asReader() {
        Reader r = this.getReader();
        if (r != null) {
            return r;
        }
        String s = this.getString();
        if (s != null) {
            return new StringReader(s);
        }
        InputStream is = this.fromStreamOrBufferOrUrl();
        if (is != null) {
            return this.readerFrom(is);
        }
        throw this.resourceUnaccessible();
    }

    public InputStream asInputStream() {
        InputStream is = this.fromStreamOrBufferOrUrl();
        if (is != null) {
            return is;
        }
        String s = this.fromStringOrReader();
        if (s != null) {
            return this.streamFrom(s);
        }
        throw this.resourceUnaccessible();
    }

    public ByteBuffer asByteBuffer() {
        ByteBuffer bb = this.getByteBuffer();
        if (bb != null) {
            return null;
        }
        InputStream is = this.fromStreamOrUrl();
        if (is != null) {
            return this.bufferFrom(is);
        }
        String s = this.fromStringOrReader();
        if (s != null) {
            return this.bufferFrom(s);
        }
        throw this.resourceUnaccessible();
    }

    public String asString() {
        String s = this.fromStringOrReader();
        if (s != null) {
            return s;
        }
        ByteBuffer bb = this.getByteBuffer();
        if (bb != null) {
            return this.stringFrom(bb);
        }
        InputStream is = this.fromStreamOrUrl();
        if (is != null) {
            Reader r = this.readerFrom(is);
            return this.stringFrom(r);
        }
        throw this.resourceUnaccessible();
    }

    public URLConnection asURLConnection() {
        URLConnection uc = this.getURLConnection();
        if (uc != null) {
            return uc;
        }
        try {
            return new InputStreamURLConnection(this.getResourceURLOrSystemId(), this, this.getDefaultUrlConnectionHeader());
        }
        catch (Exception e) {
            throw this.resolvingException(e);
        }
    }

    protected Map<String, String> getDefaultUrlConnectionHeader() {
        return null;
    }

    public BufferedInputStream asBufferedInputStream() {
        InputStream is = this.asInputStream();
        if (is == null) {
            return null;
        }
        if (is instanceof BufferedInputStream) {
            return (BufferedInputStream)is;
        }
        return new BufferedInputStream(is);
    }

    protected String fromStringOrReader() {
        String s = this.getString();
        if (s != null) {
            return s;
        }
        Reader r = this.getReader();
        if (r != null) {
            return this.stringFrom(r);
        }
        return null;
    }

    protected InputStream fromStreamOrBuffer() {
        InputStream is = this.getInputStream();
        if (is != null) {
            return is;
        }
        ByteBuffer bb = this.getByteBuffer();
        if (bb != null) {
            return this.streamFrom(bb);
        }
        return null;
    }

    protected InputStream fromStreamOrBufferOrUrl() {
        InputStream is = this.fromStreamOrBuffer();
        if (is != null) {
            return is;
        }
        return this.streamFromURLConnection();
    }

    protected InputStream fromStreamOrUrl() {
        InputStream is = this.getInputStream();
        if (is != null) {
            return is;
        }
        return this.streamFromURLConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String stringFrom(Reader r) {
        if (r == null) {
            return null;
        }
        try (Reader __ = r;){
            int n;
            char[] buf = new char[8192];
            StringWriter sw = new StringWriter();
            while (-1 < (n = r.read(buf))) {
                sw.write(buf, 0, n);
            }
            String string = sw.toString();
            return string;
        }
        catch (IOException e) {
            throw this.resolvingException(e);
        }
    }

    protected String stringFrom(ByteBuffer bb) {
        if (bb == null) {
            return null;
        }
        return this.getCharset().decode(bb).toString();
    }

    protected Reader readerFrom(InputStream is) throws ResolvingException {
        if (is == null) {
            return null;
        }
        return new InputStreamReader(is, this.getCharset());
    }

    protected InputStream streamFrom(String s) throws ResolvingException {
        if (s == null) {
            return null;
        }
        byte[] data = this.bytesFrom(s);
        return new ByteArrayInputStream(data);
    }

    protected InputStream streamFrom(ByteBuffer bb) {
        if (bb == null) {
            return null;
        }
        return new ByteBufferInputStream(bb);
    }

    protected InputStream streamFromURLConnection() {
        return this.streamFrom(this.getURLConnection());
    }

    protected InputStream streamFrom(URLConnection uc) {
        if (uc == null) {
            return null;
        }
        try {
            uc.connect();
            String enc = uc.getContentEncoding();
            if (enc != null) {
                this.setDefaultEncoding(enc);
            }
            return uc.getInputStream();
        }
        catch (IOException e) {
            throw this.resolvingException(e);
        }
    }

    protected ByteBuffer bufferFrom(String s) throws ResolvingException {
        if (s == null) {
            return null;
        }
        return this.getCharset().encode(s);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ByteBuffer bufferFrom(InputStream is) {
        if (is == null) {
            return null;
        }
        try (InputStream __ = is;){
            int n;
            if (is instanceof FileInputStream) {
                FileInputStream fis = (FileInputStream)is;
                MappedByteBuffer mappedByteBuffer = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fis.getChannel().size());
                return mappedByteBuffer;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
            byte[] buf = new byte[8192];
            while (-1 < (n = is.read(buf))) {
                out.write(buf, 0, n);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(out.toByteArray());
            return byteBuffer;
        }
        catch (IOException e) {
            throw this.resolvingException(e);
        }
    }

    protected byte[] bytesFrom(String s) throws ResolvingException {
        if (s == null) {
            return null;
        }
        return s.getBytes(this.getCharset());
    }

    protected RuntimeException resolvingException(Throwable t) {
        return new ResolvingException(this.toString(), t);
    }

    protected RuntimeException resourceUnaccessible() {
        return new ResolvingException(this.toString() + " is not accessible");
    }

    public String toString() {
        Class<?> clazz;
        String s = this.getSystemId();
        if (s == null) {
            s = this.getUri();
        }
        if (s == null) {
            s = this.getPublicId();
        }
        String cn = (clazz = this.getClass()).isAnonymousClass() ? "RResult" : clazz.getSimpleName();
        Class<?> decl = clazz.getEnclosingClass();
        if (decl != null) {
            cn = decl.getSimpleName() + "." + cn;
        }
        if (s == null) {
            return cn;
        }
        return cn + "(" + s + ")";
    }

    public static enum ResultType {
        CHARACTERS,
        STRING,
        READER,
        ANY,
        BINARY,
        BUFFER,
        STREAM,
        URL;


        public boolean isCharacterData() {
            return this.ordinal() <= ANY.ordinal();
        }

        public boolean isBinaryData() {
            return this.ordinal() >= ANY.ordinal();
        }
    }

    protected static class InputStreamURLConnection
    extends URLConnection {
        private final RResult result;
        private final Map<String, String> headerMap;
        private InputStream is = null;
        private List<String> headerKeys = null;

        public InputStreamURLConnection(URL url, RResult result, Map<String, String> headerMap) {
            super(url);
            this.result = result;
            this.headerMap = headerMap != null ? new HashMap<String, String>(headerMap) : new HashMap<String, String>();
        }

        @Override
        public synchronized void connect() throws IOException {
            if (this.connected) {
                return;
            }
            this.connected = true;
            String enc = this.headerMap.get("content-encoding");
            if (enc != null) {
                this.result.setDefaultEncoding(enc);
            }
            try {
                this.is = this.result.asInputStream();
            }
            catch (ResolvingException e) {
                throw e.againAs(IOException.class);
            }
            this.headerMap.put("content-encoding", this.result.getEncoding());
            this.headerKeys = new ArrayList<String>(this.headerMap.keySet());
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.is == null) {
                this.connect();
            }
            return this.is;
        }

        @Override
        public String getHeaderField(String name) {
            return this.headerMap.get(name);
        }

        @Override
        public String getHeaderField(int n) {
            return this.getHeaderField(this.headerKeys.get(n));
        }

        @Override
        public String getHeaderFieldKey(int n) {
            if (n < 0 || n >= this.headerKeys.size()) {
                return null;
            }
            return this.headerKeys.get(n);
        }

        @Override
        public Map<String, List<String>> getHeaderFields() {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            for (Map.Entry<String, String> e : this.headerMap.entrySet()) {
                fields.put(e.getKey(), Arrays.asList(e.getValue()));
            }
            return fields;
        }
    }

    protected static class ByteBufferInputStream
    extends InputStream {
        final ByteBuffer buf;

        public ByteBufferInputStream(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public int read() throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buf.remaining());
            this.buf.get(bytes, off, len);
            return len;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

