/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.resolve;

import java.util.List;
import org.cthul.resolve.RRequest;
import org.cthul.resolve.RResponse;
import org.cthul.resolve.RResult;
import org.cthul.resolve.ResponseBuilder;

public class ResolvingException
extends RuntimeException
implements RResponse {
    private final RRequest request;
    RResult result = null;
    ResponseBuilder.WarningsList warningsList = null;
    private static final Class<RuntimeException> NULL_EX = null;

    public static ResolvingException wrap(Exception e) {
        return ResolvingException.wrap(null, e);
    }

    public static ResolvingException wrap(RRequest request, Exception e) {
        if (e instanceof ResolvingException) {
            return (ResolvingException)e;
        }
        return new ResolvingException(request, (Throwable)e);
    }

    public ResolvingException() {
        this(null, null, null);
    }

    public ResolvingException(String message) {
        this(null, message, null);
    }

    public ResolvingException(Throwable cause) {
        this(null, null, cause);
    }

    public ResolvingException(String message, Throwable cause) {
        this(null, message, cause);
    }

    public ResolvingException(RRequest request) {
        this.request = request;
    }

    public ResolvingException(RRequest request, String message) {
        super(message);
        this.request = request;
    }

    public ResolvingException(RRequest request, String message, Throwable cause) {
        super(message, cause);
        this.request = request;
    }

    public ResolvingException(RRequest request, Throwable cause) {
        super(cause);
        this.request = request;
    }

    @Override
    public RRequest getRequest() {
        return this.request;
    }

    @Override
    public boolean hasResult() {
        return this.result != null;
    }

    @Override
    public RResult getResult() {
        if (this.hasResult()) {
            return this.result;
        }
        throw this.asException();
    }

    @Override
    public ResolvingException asException() {
        return this;
    }

    @Override
    public List<Exception> getWarningsLog() {
        if (this.warningsList == null) {
            this.warningsList = new ResponseBuilder.WarningsList();
            this.addWarning(this.getCause());
            for (Throwable t : this.getSuppressed()) {
                this.addWarning(t);
            }
        }
        return this.warningsList.asReadOnly();
    }

    private void addWarning(Throwable t) {
        if (t == null) {
            return;
        }
        if (t instanceof Exception) {
            this.warningsList.add((Exception)t);
        } else {
            this.warningsList.add(t.getMessage());
        }
    }

    public RuntimeException asRuntimeException() {
        Throwable c = this.getResolvingCause();
        if (c instanceof RuntimeException) {
            return (RuntimeException)c;
        }
        return this;
    }

    public <T1 extends Throwable> RuntimeException againAs(Class<T1> t1) throws T1 {
        return this.againAs(t1, NULL_EX, NULL_EX, NULL_EX);
    }

    public <T1 extends Throwable, T2 extends Throwable> RuntimeException againAs(Class<T1> t1, Class<T2> t2) throws T1, T2 {
        return this.againAs(t1, t2, NULL_EX, NULL_EX);
    }

    public <T1 extends Throwable, T2 extends Throwable, T3 extends Throwable> RuntimeException againAs(Class<T1> t1, Class<T2> t2, Class<T3> t3) throws T1, T2, T3 {
        return this.againAs(t1, t2, t3, NULL_EX);
    }

    public <T1 extends Throwable, T2 extends Throwable, T3 extends Throwable, T4 extends Throwable> RuntimeException againAs(Class<T1> t1, Class<T2> t2, Class<T3> t3, Class<T4> t4) throws T1, T2, T3, T4 {
        return this.throwIf(t1, t2, t3, t4);
    }

    public <T1 extends Throwable> RuntimeException throwIf(Class<T1> t1) throws T1 {
        return this.throwIf(t1, NULL_EX, NULL_EX, NULL_EX);
    }

    public <T1 extends Throwable, T2 extends Throwable> RuntimeException throwIf(Class<T1> t1, Class<T2> t2) throws T1, T2 {
        return this.throwIf(t1, t2, NULL_EX, NULL_EX);
    }

    public <T1 extends Throwable, T2 extends Throwable, T3 extends Throwable> RuntimeException throwIf(Class<T1> t1, Class<T2> t2, Class<T3> t3) throws T1, T2, T3 {
        return this.throwIf(t1, t2, t3, NULL_EX);
    }

    public <T1 extends Throwable, T2 extends Throwable, T3 extends Throwable, T4 extends Throwable> RuntimeException throwIf(Class<T1> t1, Class<T2> t2, Class<T3> t3, Class<T4> t4) throws T1, T2, T3, T4 {
        Throwable c = this.getResolvingCause();
        if (t1 != null && t1.isInstance(c)) {
            throw (Throwable)t1.cast(c);
        }
        if (t2 != null && t2.isInstance(c)) {
            throw (Throwable)t2.cast(c);
        }
        if (t3 != null && t3.isInstance(c)) {
            throw (Throwable)t3.cast(c);
        }
        if (t4 != null && t4.isInstance(c)) {
            throw (Throwable)t4.cast(c);
        }
        if (c instanceof RuntimeException) {
            return (RuntimeException)c;
        }
        return this;
    }

    public Throwable getResolvingCause() {
        ResolvingException t = this;
        Throwable c = this;
        while (c instanceof ResolvingException) {
            t = c;
            c = t.getCause();
        }
        return c == null ? t : c;
    }
}

