/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.resolve;

import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.RandomAccess;
import org.cthul.resolve.RRequest;
import org.cthul.resolve.RResponse;
import org.cthul.resolve.RResult;
import org.cthul.resolve.ResolvingException;

public abstract class ResponseBuilder
implements RResponse {
    public abstract ResponseBuilder withWarning(String var1);

    public abstract ResponseBuilder withWarning(Exception var1);

    public abstract ResponseBuilder withResponse(RResponse var1);

    public abstract RResponse withResult(RResult var1);

    public static ResponseBuilder noResult(RRequest request) {
        return new NoResult(request);
    }

    static WarningsList merge(WarningsList w1, WarningsList w2) {
        if (w1 == null || w1.isEmpty() && w1.message == null) {
            return w2;
        }
        if (w2 == null || w2.isEmpty() && w2.message == null) {
            return w1;
        }
        w1.add(w2);
        return w1;
    }

    static List<Exception> asReadOnly(WarningsList warningsList) {
        if (warningsList == null) {
            return Collections.emptyList();
        }
        return warningsList.asReadOnly();
    }

    static ResolvingException asException(RRequest request, WarningsList warningsList) {
        if (warningsList == null) {
            return null;
        }
        return warningsList.asException(request);
    }

    protected static class WarningsList
    extends AbstractList<Exception>
    implements Warnings,
    RandomAccess {
        private int size = 0;
        private final Deque<Warnings> source = new ArrayDeque<Warnings>();
        private final List<Exception> actual = new ArrayList<Exception>();
        private List<Exception> readOnly = null;
        private String message;

        public void addMessage(final String message) {
            if (this.message != null) {
                this.add(new Warnings(){

                    @Override
                    public int size() {
                        return 1;
                    }

                    @Override
                    public void addTo(List<Exception> target) {
                        target.add(new ResolvingException(message));
                    }
                });
            } else {
                this.message = message;
            }
        }

        @Override
        public boolean add(WarningsList warningsList) {
            if (warningsList.message != null) {
                this.add(warningsList.message);
            }
            return this.add((Warnings)warningsList);
        }

        @Override
        public boolean add(Warnings warnings) {
            this.size += warnings.size();
            this.source.add(warnings);
            return true;
        }

        @Override
        public void addTo(List<Exception> target) {
            if (target instanceof WarningsList) {
                ((WarningsList)target).add(this);
            } else {
                target.addAll(this);
            }
        }

        @Override
        public boolean add(final Exception e) {
            return this.add(new Warnings(){

                @Override
                public int size() {
                    return 1;
                }

                @Override
                public void addTo(List<Exception> target) {
                    target.add(e);
                }
            });
        }

        @Override
        public boolean add(final String message) {
            return this.add(new Warnings(){

                @Override
                public int size() {
                    return 1;
                }

                @Override
                public void addTo(List<Exception> target) {
                    target.add(new ResolvingException(message));
                }
            });
        }

        @Override
        public boolean addAll(final Collection<? extends Exception> c) {
            if (c.isEmpty()) {
                return false;
            }
            return this.add(new Warnings(){

                @Override
                public int size() {
                    return c.size();
                }

                @Override
                public void addTo(List<Exception> target) {
                    target.addAll(c);
                }
            });
        }

        @Override
        public Exception get(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("[" + index + "], size: " + this.size);
            }
            while (index >= this.actual.size()) {
                this.source.removeFirst().addTo(this.actual);
            }
            return this.actual.get(index);
        }

        @Override
        public int size() {
            return this.size;
        }

        public List<Exception> asReadOnly() {
            if (this.readOnly == null) {
                this.readOnly = Collections.unmodifiableList(this);
            }
            return this.readOnly;
        }

        public ResolvingException asException(RRequest request) {
            if (this.isEmpty()) {
                return null;
            }
            ResolvingException e = new ResolvingException(request, this.message != null ? this.message : (this.size() == 1 ? this.get(0).getMessage() : this.size() + " warnings"), this.get(0));
            for (int i = 1; i < this.size(); ++i) {
                e.addSuppressed(this.get(i));
            }
            return e;
        }
    }

    protected static interface Warnings {
        public int size();

        public void addTo(List<Exception> var1);
    }

    protected static class WarningLog
    extends ResponseBuilder {
        private final RRequest request;
        private WarningsList warningsList = new WarningsList();
        private RResult result = null;

        public WarningLog(RRequest request) {
            this.request = request;
        }

        @Override
        public RRequest getRequest() {
            return this.request;
        }

        @Override
        public boolean hasResult() {
            return this.result != null;
        }

        @Override
        public RResult getResult() {
            if (this.result != null) {
                return this.result;
            }
            throw this.asException();
        }

        @Override
        public List<Exception> getWarningsLog() {
            return this.warningsList.asReadOnly();
        }

        @Override
        public ResolvingException asException() {
            if (this.hasResult() && this.warningsList.isEmpty()) {
                return null;
            }
            return this.warningsList.asException(this.request);
        }

        @Override
        public ResponseBuilder withWarning(Exception e) {
            this.warningsList.add(e);
            return this;
        }

        @Override
        public ResponseBuilder withResponse(RResponse r) {
            if (r.hasResult()) {
                this.withResult(r.getResult());
            } else if (r instanceof WarningLog) {
                this.warningsList = WarningLog.merge(this.warningsList, ((WarningLog)r).warningsList);
            } else {
                this.warningsList.addAll((Collection<? extends Exception>)r.getWarningsLog());
            }
            return this;
        }

        @Override
        public ResponseBuilder withWarning(String message) {
            this.warningsList.add(message);
            return this;
        }

        @Override
        public RResponse withResult(RResult result) {
            result.warnings = this.warningsList = WarningLog.merge(this.warningsList, result.warnings);
            this.result = result;
            return result;
        }
    }

    protected static class NoResult
    extends ResponseBuilder {
        private final RRequest request;

        public NoResult(RRequest request) {
            this.request = request;
        }

        @Override
        public ResponseBuilder withWarning(Exception e) {
            return new WarningLog(this.request).withWarning(e);
        }

        @Override
        public ResponseBuilder withWarning(String message) {
            return new WarningLog(this.request).withWarning(message);
        }

        @Override
        public ResponseBuilder withResponse(RResponse r) {
            if (r instanceof ResponseBuilder) {
                return (ResponseBuilder)r;
            }
            return new WarningLog(this.request).withResponse(r);
        }

        @Override
        public RResponse withResult(RResult result) {
            return result;
        }

        @Override
        public RRequest getRequest() {
            return this.request;
        }

        @Override
        public boolean hasResult() {
            return false;
        }

        @Override
        public RResult getResult() {
            throw this.asException();
        }

        @Override
        public List<Exception> getWarningsLog() {
            return Collections.emptyList();
        }

        @Override
        public ResolvingException asException() {
            return new ResolvingException(this.request, "No result");
        }
    }
}

