/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.resolve;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cthul.resolve.RRequest;
import org.cthul.resolve.RResponse;
import org.cthul.resolve.ResolvingException;
import org.cthul.resolve.ResourceResolverBase;
import org.cthul.resolve.ResponseBuilder;
import org.cthul.strings.RegEx;

public abstract class UriMappingResolver
extends ResourceResolverBase {
    private Quoter quoter = DEFAULT_QUOTER;
    private final Map<String, String> uriMap = new HashMap<String, String>();
    private final Map<Pattern, String> patternMap = new HashMap<Pattern, String>();
    private static final Quoter SIMPLE_QUOTER;
    private static final Quoter DEFAULT_QUOTER;

    public UriMappingResolver(String ... schemas) {
        this.addSchemas(schemas);
    }

    public UriMappingResolver(Map<String, String> schemas) {
        this.addSchemas(schemas);
    }

    public UriMappingResolver() {
    }

    public UriMappingResolver useSimpleQuoting() {
        this.quoter = SIMPLE_QUOTER;
        return this;
    }

    protected String quote(String pattern) {
        return this.quoter.quote(pattern);
    }

    public UriMappingResolver addSchema(String uri, String schemas) {
        return this.addResource(uri, schemas);
    }

    public UriMappingResolver addSchemas(String ... schemas) {
        return this.addResources(schemas);
    }

    public UriMappingResolver addSchemas(Map<String, String> schemas) {
        return this.addResources(schemas);
    }

    public UriMappingResolver addResource(String uri, String resource) {
        this.uriMap.put(uri, resource);
        return this;
    }

    public UriMappingResolver addResources(String ... resources) {
        if (resources.length % 2 == 1) {
            throw new IllegalArgumentException("Expected even number of arguments");
        }
        for (int i = 0; i < resources.length; i += 2) {
            this.addSchema(resources[i], resources[i + 1]);
        }
        return this;
    }

    public UriMappingResolver addResources(Map<String, String> resources) {
        this.uriMap.putAll(resources);
        return this;
    }

    public UriMappingResolver addDomain(String domain, String replacement) {
        this.addDomainPattern(this.quote(domain) + "[/]*(.*)", replacement);
        return this;
    }

    public UriMappingResolver addDomain(String domain) {
        return this.addDomain(domain, "$1");
    }

    public UriMappingResolver addDomains(String ... values) {
        if (values.length % 2 == 1) {
            throw new IllegalArgumentException("Expected even number of arguments");
        }
        for (int i = 0; i < values.length; i += 2) {
            this.addDomain(values[i], values[i + 1]);
        }
        return this;
    }

    public UriMappingResolver lookupAll() {
        return this.addDomain("", "$1");
    }

    public UriMappingResolver addDomainPattern(String domain, String replacement) {
        Pattern domainPattern = Pattern.compile(domain);
        this.addDomainPattern(domainPattern, replacement);
        return this;
    }

    public UriMappingResolver addDomainPattern(Pattern pattern, String replacement) {
        this.patternMap.put(pattern, replacement);
        return this;
    }

    public UriMappingResolver addDomainPatterns(String ... values) {
        if (values.length % 2 == 1) {
            throw new IllegalArgumentException("Expected even number of arguments");
        }
        for (int i = 0; i < values.length; i += 2) {
            this.addDomainPattern(values[i], values[i + 1]);
        }
        return this;
    }

    protected Iterator<String> resolver(String uri) {
        return new Resolver(uri);
    }

    protected String mapUri(String uri) {
        return this.uriMap.get(uri);
    }

    protected Iterator<Map.Entry<Pattern, String>> patternIterator() {
        return this.patternMap.entrySet().iterator();
    }

    protected String mapDomain(Map.Entry<Pattern, String> domain, String uri) {
        Matcher m = domain.getKey().matcher(uri);
        if (!m.find()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        m.appendReplacement(sb, domain.getValue());
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public RResponse resolve(RRequest request) {
        return this.resolve(request, this.uri(request));
    }

    protected String uri(RRequest request) {
        return request.getUriOrId();
    }

    protected RResponse resolve(RRequest request, String uri) {
        ResponseBuilder response = request.noResultResponse();
        Iterator<String> resolver = this.resolver(uri);
        while (resolver.hasNext()) {
            String src = resolver.next();
            try {
                RResponse res = this.get(request, src);
                if (res == null) continue;
                if (res.hasResult()) {
                    return response.withResult(res.getResult());
                }
                response = response.withResponse(res);
            }
            catch (Exception e) {
                throw ResolvingException.wrap(request, e);
            }
        }
        return response;
    }

    protected abstract RResponse get(RRequest var1, String var2) throws Exception;

    protected String getMappingString() {
        StringBuilder sb = new StringBuilder();
        int schemaSize = this.uriMap.size();
        int domainSize = this.patternMap.size();
        int s = 0;
        int d = 0;
        for (String schema : this.uriMap.keySet()) {
            if (s > 0) {
                sb.append(", ");
            }
            sb.append(schema);
            if (++s <= 2 || schemaSize <= 3) continue;
            sb.append(", ");
            sb.append(schemaSize - s);
            sb.append(" more");
            break;
        }
        if (schemaSize > 0 && domainSize > 0) {
            sb.append("; ");
        }
        for (Pattern domain : this.patternMap.keySet()) {
            if (d > 0) {
                sb.append(", ");
            }
            sb.append(domain.pattern());
            if (++d <= 2 || domainSize <= 3) continue;
            sb.append(", ");
            sb.append(domainSize - s);
            sb.append(" more");
            break;
        }
        return sb.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getMappingString() + ")";
    }

    static {
        Quoter q;
        SIMPLE_QUOTER = new Quoter(){

            @Override
            public String quote(String regex) {
                return Pattern.quote(regex);
            }
        };
        try {
            q = new CthulQuoter();
        }
        catch (Throwable t) {
            q = SIMPLE_QUOTER;
        }
        DEFAULT_QUOTER = q;
    }

    private static class CthulQuoter
    implements Quoter {
        public CthulQuoter() {
            RegEx.quote((String)"");
        }

        @Override
        public String quote(String regex) {
            return RegEx.quote((String)regex);
        }
    }

    private static interface Quoter {
        public String quote(String var1);
    }

    protected class Resolver
    implements Iterator<String> {
        protected final String uri;
        protected int stage = 0;
        protected String next = null;
        protected Iterator<Map.Entry<Pattern, String>> patterns = null;

        public Resolver(String uri) {
            this.uri = uri;
        }

        @Override
        public boolean hasNext() {
            return this.checkNext();
        }

        @Override
        public String next() {
            if (!this.checkNext()) {
                throw new IllegalStateException("No more elements");
            }
            String result = this.next;
            this.next = null;
            return result;
        }

        protected boolean checkNext() {
            if (this.next != null) {
                return true;
            }
            if (this.stage == 0) {
                ++this.stage;
                this.next = UriMappingResolver.this.mapUri(this.uri);
                if (this.next != null) {
                    return true;
                }
            }
            if (this.stage == 1) {
                ++this.stage;
                this.patterns = UriMappingResolver.this.patternIterator();
            }
            while (this.patterns.hasNext()) {
                this.next = UriMappingResolver.this.mapDomain(this.patterns.next(), this.uri);
                if (this.next == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

