/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.resolve.results;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import org.cthul.resolve.RRequest;
import org.cthul.resolve.RResult;

public class BytesResult
extends RResult {
    private final ByteBuffer buffer;

    public BytesResult(RRequest request, String systemId, byte[] data) {
        this(request, systemId, data, false);
    }

    public BytesResult(RRequest request, String systemId, byte[] data, boolean copy) {
        this(request, systemId, ByteBuffer.wrap(copy ? (byte[])data.clone() : data));
    }

    public BytesResult(RRequest request, String systemId, ByteBuffer data) {
        this(request, systemId, data, false);
    }

    public BytesResult(RRequest request, String systemId, ByteBuffer data, boolean copy) {
        super(request, systemId);
        if (copy) {
            this.buffer = ByteBuffer.allocate(data.remaining());
            this.buffer.put(data);
        } else {
            this.buffer = data;
        }
    }

    public BytesResult(RRequest request, String systemId, InputStream is) throws IOException {
        super(request, systemId);
        this.buffer = this.bufferFrom(is);
    }

    @Override
    public RResult.ResultType getResultType() {
        return RResult.ResultType.BUFFER;
    }

    @Override
    protected ByteBuffer createByteBuffer() throws Exception {
        return this.buffer.asReadOnlyBuffer();
    }

    @Override
    public InputStream asInputStream() {
        return this.streamFrom(this.getByteBuffer());
    }

    @Override
    public Reader asReader() {
        return this.readerFrom(this.asInputStream());
    }

    @Override
    public String asString() {
        return this.stringFrom(this.getByteBuffer());
    }
}

