/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.resolve.results;

import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.cthul.resolve.RRequest;
import org.cthul.resolve.RResult;

public class URLResult
extends RResult {
    private final URL resourceUrl;

    public URLResult(RRequest request, Path path) throws MalformedURLException {
        this(request, path.toUri().toURL());
    }

    public URLResult(RRequest request, URL resourceUrl) {
        super(request, resourceUrl.toString());
        this.resourceUrl = resourceUrl;
    }

    @Override
    public RResult.ResultType getResultType() {
        return RResult.ResultType.URL;
    }

    @Override
    public URL getResourceURL() throws Exception {
        return this.resourceUrl;
    }

    @Override
    protected InputStream createInputStream() throws Exception {
        return this.streamFromURLConnection();
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return this.bufferFrom(this.getInputStream());
    }

    @Override
    public Reader asReader() {
        return this.readerFrom(this.getInputStream());
    }

    @Override
    public String asString() {
        return this.stringFrom(this.asReader());
    }
}

