/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.xml.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ValidatingSAXParser {
    private SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");

    public ValidatingSAXParser(LSResourceResolver resolver) {
        this.schemaFactory.setResourceResolver(resolver);
    }

    public void parse(File file, ContentHandler handler) throws FileNotFoundException, SAXException, IOException {
        this.parse(new FileInputStream(file), file.getCanonicalPath(), handler);
    }

    public void parse(InputStream input, String systemId, ContentHandler handler) throws SAXException, IOException {
        InputSource is = new InputSource(input);
        is.setSystemId(systemId);
        this.parse(is, handler);
    }

    public void parse(InputSource input, ContentHandler handler) throws SAXException, IOException {
        Validator v = this.schemaFactory.newSchema().newValidator();
        v.setResourceResolver(this.schemaFactory.getResourceResolver());
        v.validate(new SAXSource(input), new SAXResult(handler));
    }
}

