/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.xml.validation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ValidatingXMLInputFactory
extends XMLInputFactory {
    private static XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
    private final XMLInputFactory inputFactory;
    private final SchemaFactory schemaFactory;
    static final SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();

    public ValidatingXMLInputFactory(LSResourceResolver resolver) {
        this(XMLInputFactory.newFactory(), SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema"));
        this.schemaFactory.setResourceResolver(resolver);
    }

    public ValidatingXMLInputFactory(XMLInputFactory inputFactory, SchemaFactory schemaFactory) {
        this.inputFactory = inputFactory;
        this.schemaFactory = schemaFactory;
    }

    private ByteArrayOutputStream buffer() {
        return new ByteArrayOutputStream(8192);
    }

    private InputStream is(ByteArrayOutputStream buf) {
        return this.is(buf.toByteArray());
    }

    private InputStream is(byte[] bytes) {
        int skip = this.skipWhitespace(bytes);
        return new ByteArrayInputStream(bytes, skip, bytes.length - skip);
    }

    private InputStream validate(XMLEventReader unvalidatedInput) throws XMLStreamException {
        return this.validate(new StAXSource(unvalidatedInput));
    }

    private InputStream validate(XMLStreamReader unvalidatedInput) throws XMLStreamException {
        return this.validate(new StAXSource(unvalidatedInput));
    }

    private InputStream validate(StAXSource unvalidatedInput) throws XMLStreamException {
        ByteArrayOutputStream buf = this.buffer();
        XMLStreamWriter validatedOutput = outputFactory.createXMLStreamWriter(buf);
        this.validate(unvalidatedInput, new StAXResult(validatedOutput));
        return this.is(buf);
    }

    private InputStream validate(InputStream is, String systemId, String encoding) throws XMLStreamException {
        InputSource input = new InputSource(is);
        input.setEncoding(encoding);
        input.setSystemId(systemId);
        return this.validate(input);
    }

    private InputStream validate(Reader r, String systemId) throws XMLStreamException {
        InputSource input = new InputSource(r);
        input.setSystemId(systemId);
        return this.validate(input);
    }

    private InputStream validate(InputSource unvalidatedInput) throws XMLStreamException {
        try {
            ByteArrayOutputStream buf = this.buffer();
            TransformerHandler t = tf.newTransformerHandler();
            t.setResult(new StreamResult(buf));
            this.validate(new SAXSource(unvalidatedInput), new SAXResult(t));
            return this.is(buf);
        }
        catch (TransformerConfigurationException e) {
            throw new XMLStreamException(e);
        }
    }

    private void validate(Source src, Result res) throws XMLStreamException {
        try {
            Validator v = this.schemaFactory.newSchema().newValidator();
            v.setResourceResolver(this.schemaFactory.getResourceResolver());
            v.validate(src, res);
        }
        catch (IOException | SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    private int skipWhitespace(byte[] bytes) {
        int len = bytes.length;
        block3: for (int i = 0; i < len; ++i) {
            switch (bytes[i]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
                default: {
                    return i;
                }
            }
        }
        return len;
    }

    private XMLStreamReader stream(String systemId, InputStream is) throws XMLStreamException {
        return this.inputFactory.createXMLStreamReader(systemId, is);
    }

    private XMLEventReader event(String systemId, InputStream is) throws XMLStreamException {
        return this.inputFactory.createXMLEventReader(systemId, is);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        return this.stream(null, this.validate(reader, null));
    }

    @Override
    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        return this.stream(null, this.validate(this.inputFactory.createXMLStreamReader(source)));
    }

    @Override
    public XMLStreamReader createXMLStreamReader(InputStream stream) throws XMLStreamException {
        return this.stream(null, this.validate(stream, null, null));
    }

    @Override
    public XMLStreamReader createXMLStreamReader(InputStream stream, String encoding) throws XMLStreamException {
        return this.stream(null, this.validate(stream, null, encoding));
    }

    @Override
    public XMLStreamReader createXMLStreamReader(String systemId, InputStream stream) throws XMLStreamException {
        return this.stream(systemId, this.validate(stream, systemId, null));
    }

    @Override
    public XMLStreamReader createXMLStreamReader(String systemId, Reader reader) throws XMLStreamException {
        return this.stream(systemId, this.validate(reader, systemId));
    }

    @Override
    public XMLEventReader createXMLEventReader(Reader reader) throws XMLStreamException {
        return this.event(null, this.validate(reader, null));
    }

    @Override
    public XMLEventReader createXMLEventReader(String systemId, Reader reader) throws XMLStreamException {
        return this.event(systemId, this.validate(reader, systemId));
    }

    @Override
    public XMLEventReader createXMLEventReader(XMLStreamReader reader) throws XMLStreamException {
        return this.event(null, this.validate(reader));
    }

    @Override
    public XMLEventReader createXMLEventReader(Source source) throws XMLStreamException {
        return this.event(null, this.validate(this.inputFactory.createXMLStreamReader(source)));
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream stream) throws XMLStreamException {
        return this.event(null, this.validate(stream, null, null));
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream stream, String encoding) throws XMLStreamException {
        return this.event(null, this.validate(stream, null, encoding));
    }

    @Override
    public XMLEventReader createXMLEventReader(String systemId, InputStream stream) throws XMLStreamException {
        return this.event(systemId, this.validate(stream, systemId, null));
    }

    @Override
    public XMLStreamReader createFilteredReader(XMLStreamReader reader, StreamFilter filter) throws XMLStreamException {
        return this.inputFactory.createFilteredReader(this.stream(null, this.validate(reader)), filter);
    }

    @Override
    public XMLEventReader createFilteredReader(XMLEventReader reader, EventFilter filter) throws XMLStreamException {
        return this.inputFactory.createFilteredReader(this.event(null, this.validate(reader)), filter);
    }

    @Override
    public XMLResolver getXMLResolver() {
        return this.inputFactory.getXMLResolver();
    }

    @Override
    public void setXMLResolver(XMLResolver resolver) {
        this.inputFactory.setXMLResolver(resolver);
    }

    @Override
    public XMLReporter getXMLReporter() {
        return this.inputFactory.getXMLReporter();
    }

    @Override
    public void setXMLReporter(XMLReporter reporter) {
        this.inputFactory.setXMLReporter(reporter);
    }

    @Override
    public void setProperty(String name, Object value) throws IllegalArgumentException {
        this.inputFactory.setProperty(name, value);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.inputFactory.getProperty(name);
    }

    @Override
    public boolean isPropertySupported(String name) {
        return this.inputFactory.isPropertySupported(name);
    }

    @Override
    public void setEventAllocator(XMLEventAllocator allocator) {
        this.inputFactory.setEventAllocator(allocator);
    }

    @Override
    public XMLEventAllocator getEventAllocator() {
        return this.inputFactory.getEventAllocator();
    }

    public XMLStreamReader createXMLStreamReader(File f) throws IOException, XMLStreamException {
        return this.createXMLStreamReader(f.getCanonicalPath(), new FileInputStream(f));
    }

    public XMLEventReader createXMLEventReader(File f) throws IOException, XMLStreamException {
        return this.createXMLEventReader(f.getCanonicalPath(), new FileInputStream(f));
    }
}

