/*
 * Decompiled with CFR 0.152.
 */
package org.cuberact.maven.proguard;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.maven.artifact.Artifact;

public class ArtifactFilter {
    private static final String WILDCARD = "*";
    protected String groupId;
    protected String artifactId;
    protected String classifier;

    public boolean match(Artifact artifact) {
        boolean artifactMatch = WILDCARD.equals(this.artifactId) || artifact.getArtifactId().equals(this.artifactId) || this.artifactId != null && this.getArtifactIdMatcher(artifact).matches();
        boolean groupMatch = artifact.getGroupId().equals(this.groupId) || this.groupId != null && this.getGroupIdMatcher(artifact).matches();
        boolean classifierMatch = this.classifier == null && artifact.getClassifier() == null || this.classifier != null && this.classifier.equals(artifact.getClassifier());
        return artifactMatch && groupMatch && classifierMatch;
    }

    private Matcher getArtifactIdMatcher(Artifact artifact) {
        try {
            Pattern compile = Pattern.compile(this.escapeRegex(this.artifactId));
            return compile.matcher(artifact.getArtifactId());
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Invalid regex artifactId filter: " + this, e);
        }
    }

    private Matcher getGroupIdMatcher(Artifact artifact) {
        try {
            Pattern compile = Pattern.compile(this.escapeRegex(this.groupId));
            return compile.matcher(artifact.getGroupId());
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Invalid regex groupId filter: " + this, e);
        }
    }

    private String escapeRegex(String str) {
        return Pattern.quote(str).replace(WILDCARD, "\\E.*\\Q");
    }

    public String toString() {
        return "groupId:" + this.groupId + ", artifactId:" + this.artifactId + ", classifier:" + this.classifier;
    }
}

