/*
 * Decompiled with CFR 0.152.
 */
package org.cukesalad.db.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class DynamicSQLQuery {
    private String sqlFileName;
    private Map<String, String> parameterMap;

    public String getSqlFileName() {
        return this.sqlFileName;
    }

    public void setSqlFileName(String sqlFileName) {
        this.sqlFileName = sqlFileName;
    }

    public Map<String, String> getParameterMap() {
        return this.parameterMap;
    }

    public void setParameterMap(Map<String, String> parameterMap) {
        this.parameterMap = parameterMap;
    }

    public String getSqlQuery() throws IOException {
        InputStream stream = DynamicSQLQuery.getInputStreamFromFile("sql/" + this.sqlFileName);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)stream, (Writer)writer);
        String rawSql = writer.toString();
        String batchQuery = DynamicSQLQuery.manipulateBatchQuery(rawSql, this.parameterMap);
        return batchQuery;
    }

    public static InputStream getInputStreamFromFile(String fileName) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream stream = loader.getResourceAsStream(fileName);
        return stream;
    }

    public List<String> getBatchQueryList() throws IOException {
        List<String> batchQueries = Arrays.asList(this.getSqlQuery().split(";"));
        return batchQueries;
    }

    private static String manipulateBatchQuery(String rawSql, Map<String, String> parameterMap) {
        String batchQuery = new String(rawSql);
        if (parameterMap != null) {
            for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
                batchQuery = batchQuery.replaceAll("[$]" + entry.getKey(), entry.getValue());
            }
        }
        return batchQuery;
    }
}

