/*
 * Decompiled with CFR 0.152.
 */
package org.curioswitch.gradle.helpers.platform;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.curioswitch.gradle.helpers.platform.OperatingSystem;
import org.curioswitch.gradle.helpers.platform.PlatformHelper;

public final class PathUtil {
    public static String toBashString(Path path) {
        return PathUtil.toBashString(path.toAbsolutePath().toString());
    }

    public static String toBashString(String path) {
        PlatformHelper helper = new PlatformHelper();
        if (helper.getOs() != OperatingSystem.WINDOWS) {
            return path;
        }
        if (path.contains("$")) {
            return "$(cygpath " + path + ")";
        }
        int colonIndex = (path = path.replace('\\', '/')).indexOf(58);
        if (colonIndex < 0) {
            return path;
        }
        return "/" + path.substring(0, colonIndex) + path.substring(colonIndex + 1);
    }

    public static String getExeName(String name) {
        PlatformHelper helper = new PlatformHelper();
        if (helper.getOs() == OperatingSystem.WINDOWS) {
            return name + ".exe";
        }
        return name;
    }

    public static String getBashExecutable() {
        String bashExecutable = System.getenv("MSYS_BASH_PATH");
        if (bashExecutable != null) {
            return bashExecutable;
        }
        bashExecutable = "C:\\tools\\msys64\\usr\\bin\\bash.exe";
        if (Files.exists(Paths.get(bashExecutable, new String[0]), new LinkOption[0])) {
            return bashExecutable;
        }
        return "bash";
    }

    private PathUtil() {
    }
}

