/*
 * Decompiled with CFR 0.152.
 */
package org.curioswitch.common.protobuf.json;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Descriptors;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.curioswitch.common.protobuf.json.ProtoFieldInfo;

final class CodeGenUtil {
    static List<Descriptors.FieldDescriptor> sorted(List<Descriptors.FieldDescriptor> fields) {
        return ImmutableList.sortedCopyOf((Comparator)new Comparator<Descriptors.FieldDescriptor>(){

            @Override
            public int compare(Descriptors.FieldDescriptor o1, Descriptors.FieldDescriptor o2) {
                return Integer.compare(o1.getNumber(), o2.getNumber());
            }
        }, fields);
    }

    static String fieldNameForNestedMarshaller(Descriptors.Descriptor descriptor) {
        return "MARSHALLER_" + descriptor.getFullName().replace('.', '_');
    }

    static String fieldNameForSerializedFieldName(ProtoFieldInfo field) {
        return "FIELD_NAME_" + field.descriptor().getNumber();
    }

    static StackManipulation invoke(Method method) {
        return MethodInvocation.invoke((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod(method));
    }

    static Map<String, FieldDescription> fieldsByName(Implementation.Context implementationContext) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (FieldDescription field : implementationContext.getInstrumentedType().getDeclaredFields()) {
            map.put((Object)field.getName(), (Object)field);
        }
        return map.build();
    }

    static StackManipulation getEnumDescriptor(ProtoFieldInfo info) {
        MethodDescription.ForLoadedMethod getDescriptor;
        Class<?> clz = info.enumClass();
        try {
            getDescriptor = new MethodDescription.ForLoadedMethod(clz.getDeclaredMethod("getDescriptor", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Not an enum class: " + clz, e);
        }
        return MethodInvocation.invoke((MethodDescription.InDefinedShape)getDescriptor);
    }

    private CodeGenUtil() {
    }
}

