/*
 * Decompiled with CFR 0.152.
 */
package org.curioswitch.common.protobuf.json;

import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.HashMap;
import java.util.Map;
import org.curioswitch.common.protobuf.json.TypeSpecificMarshaller;

final class MarshallerRegistry {
    private final Map<Descriptors.Descriptor, TypeSpecificMarshaller<?>> descriptorRegistry;
    private final Map<String, TypeSpecificMarshaller<?>> typeNameRegistry;

    MarshallerRegistry(Map<Descriptors.Descriptor, TypeSpecificMarshaller<?>> descriptorRegistry) {
        this.descriptorRegistry = new HashMap(descriptorRegistry);
        HashMap typeNameRegistry = new HashMap();
        for (Map.Entry<Descriptors.Descriptor, TypeSpecificMarshaller<?>> entry : descriptorRegistry.entrySet()) {
            typeNameRegistry.put(entry.getKey().getFullName(), entry.getValue());
        }
        this.typeNameRegistry = typeNameRegistry;
    }

    TypeSpecificMarshaller<?> findForPrototype(Message prototype) {
        TypeSpecificMarshaller<?> marshaller = this.descriptorRegistry.get(prototype.getDescriptorForType());
        if (marshaller == null) {
            throw new IllegalArgumentException("Could not find marshaller for type: " + prototype.getDescriptorForType() + ". Has it been registered?");
        }
        return marshaller;
    }

    TypeSpecificMarshaller<?> findByTypeUrl(String typeUrl) throws InvalidProtocolBufferException {
        String typeName = MarshallerRegistry.getTypeName(typeUrl);
        TypeSpecificMarshaller<?> marshaller = this.typeNameRegistry.get(typeName);
        if (marshaller == null) {
            throw new InvalidProtocolBufferException("Cannot find type for url: " + typeUrl);
        }
        return marshaller;
    }

    private static String getTypeName(String typeUrl) throws InvalidProtocolBufferException {
        String[] parts = typeUrl.split("/");
        if (parts.length == 1) {
            throw new InvalidProtocolBufferException("Invalid type url found: " + typeUrl);
        }
        return parts[parts.length - 1];
    }
}

