/*
 * Decompiled with CFR 0.152.
 */
package org.curioswitch.common.protobuf.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.exc.InputCoercionException;
import com.fasterxml.jackson.core.io.NumberInput;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.NullValue;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Base64;
import org.curioswitch.common.protobuf.json.TypeSpecificMarshaller;

public final class ParseSupport {
    static final int RECURSION_LIMIT = 100;
    private static final BigInteger MAX_UINT32 = new BigInteger("FFFFFFFF", 16);
    private static final BigInteger MAX_UINT64 = new BigInteger("FFFFFFFFFFFFFFFF", 16);
    private static final double EPSILON = 1.0E-6;
    private static final BigDecimal MORE_THAN_ONE = new BigDecimal(String.valueOf(1.000001));
    private static final BigDecimal MAX_DOUBLE = new BigDecimal(String.valueOf(Double.MAX_VALUE)).multiply(MORE_THAN_ONE);
    private static final BigDecimal MIN_DOUBLE = new BigDecimal(String.valueOf(-1.7976931348623157E308)).multiply(MORE_THAN_ONE);

    public static void parseObjectStart(JsonParser parser) throws IOException {
        JsonToken json = parser.currentToken();
        if (json != JsonToken.START_OBJECT) {
            throw new InvalidProtocolBufferException("Expected an object but found: " + json);
        }
        parser.nextToken();
    }

    public static boolean checkObjectEnd(JsonToken token) {
        return token == JsonToken.END_OBJECT;
    }

    public static void parseArrayStart(JsonParser parser) throws IOException {
        JsonToken json = parser.currentToken();
        if (json != JsonToken.START_ARRAY) {
            throw new InvalidProtocolBufferException("Expected an array but found: " + json);
        }
        parser.nextToken();
    }

    public static boolean checkArrayEnd(JsonParser parser) {
        JsonToken json = parser.currentToken();
        return json == JsonToken.END_ARRAY;
    }

    public static boolean checkNull(JsonParser parser) {
        return parser.currentToken() == JsonToken.VALUE_NULL;
    }

    public static void throwIfRepeatedValueNull(JsonParser parser) throws InvalidProtocolBufferException {
        if (parser.currentToken() == JsonToken.VALUE_NULL) {
            throw new InvalidProtocolBufferException("Repeated field elements cannot be null");
        }
    }

    public static int parseInt32(JsonParser parser) throws IOException {
        JsonToken token = parser.currentToken();
        if (token == JsonToken.VALUE_NUMBER_INT) {
            return parser.getIntValue();
        }
        try {
            BigDecimal value = new BigDecimal(parser.getTextCharacters(), parser.getTextOffset(), parser.getTextLength());
            return value.intValueExact();
        }
        catch (Exception e) {
            throw new InvalidProtocolBufferException("Not an int32 value: " + parser.getText());
        }
    }

    public static long parseInt64(JsonParser parser) throws IOException {
        try {
            return ParseSupport.parseLong(parser);
        }
        catch (JsonParseException | NumberFormatException throwable) {
            try {
                BigDecimal value = new BigDecimal(parser.getTextCharacters(), parser.getTextOffset(), parser.getTextLength());
                return value.longValueExact();
            }
            catch (ArithmeticException e) {
                throw new InvalidProtocolBufferException("Not an int64 value: " + parser.getText());
            }
        }
    }

    public static int parseUInt32(JsonParser parser) throws IOException {
        try {
            long result = ParseSupport.parseLong(parser);
            if (result < 0L || result > 0xFFFFFFFFL) {
                throw new InvalidProtocolBufferException("Out of range uint32 value: " + parser.getText());
            }
            return (int)result;
        }
        catch (JsonParseException | NumberFormatException result) {
            try {
                BigDecimal decimalValue = new BigDecimal(parser.getTextCharacters(), parser.getTextOffset(), parser.getTextLength());
                BigInteger value = decimalValue.toBigIntegerExact();
                if (value.signum() < 0 || value.compareTo(MAX_UINT32) > 0) {
                    throw new InvalidProtocolBufferException("Out of range uint32 value: " + parser.getText());
                }
                return value.intValue();
            }
            catch (ArithmeticException | NumberFormatException e) {
                throw new InvalidProtocolBufferException("Not an uint32 value: " + parser.getText());
            }
        }
    }

    public static long parseUInt64(JsonParser parser) throws IOException {
        BigInteger value;
        try {
            long result = ParseSupport.parseLong(parser);
            if (result >= 0L) {
                return result;
            }
        }
        catch (JsonParseException | InputCoercionException | NumberFormatException result) {
            // empty catch block
        }
        try {
            BigDecimal decimal = new BigDecimal(parser.getTextCharacters(), parser.getTextOffset(), parser.getTextLength());
            value = decimal.toBigIntegerExact();
        }
        catch (ArithmeticException | NumberFormatException e) {
            throw new InvalidProtocolBufferException("Not an uint64 value: " + parser.getText());
        }
        if (value.compareTo(BigInteger.ZERO) < 0 || value.compareTo(MAX_UINT64) > 0) {
            throw new InvalidProtocolBufferException("Out of range uint64 value: " + parser.getText());
        }
        return value.longValue();
    }

    public static boolean parseBool(JsonParser parser) throws IOException {
        JsonToken token = parser.currentToken();
        if (token.isBoolean()) {
            return parser.getBooleanValue();
        }
        String json = parser.getText();
        if (json.equals("true")) {
            return true;
        }
        if (json.equals("false")) {
            return false;
        }
        throw new InvalidProtocolBufferException("Invalid bool value: " + json);
    }

    public static float parseFloat(JsonParser parser) throws IOException {
        String json;
        JsonToken current = parser.currentToken();
        if (!current.isNumeric()) {
            json = parser.getText();
            if (json.equals("NaN")) {
                return Float.NaN;
            }
            if (json.equals("Infinity")) {
                return Float.POSITIVE_INFINITY;
            }
            if (json.equals("-Infinity")) {
                return Float.NEGATIVE_INFINITY;
            }
        }
        json = parser.getText();
        try {
            double value = Double.parseDouble(json);
            if (value > 3.402826869208755E38 || value < -3.402826869208755E38) {
                throw new InvalidProtocolBufferException("Out of range float value: " + json);
            }
            return (float)value;
        }
        catch (NumberFormatException e) {
            throw new InvalidProtocolBufferException("Not a float value: " + json);
        }
    }

    public static double parseDouble(JsonParser parser) throws IOException {
        JsonToken current = parser.currentToken();
        if (!current.isNumeric()) {
            String json = parser.getText();
            if (json.equals("NaN")) {
                return Double.NaN;
            }
            if (json.equals("Infinity")) {
                return Double.POSITIVE_INFINITY;
            }
            if (json.equals("-Infinity")) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        try {
            BigDecimal value = new BigDecimal(parser.getTextCharacters(), parser.getTextOffset(), parser.getTextLength());
            if (value.compareTo(MAX_DOUBLE) > 0 || value.compareTo(MIN_DOUBLE) < 0) {
                throw new InvalidProtocolBufferException("Out of range double value: " + parser.getText());
            }
            return value.doubleValue();
        }
        catch (NumberFormatException e) {
            throw new InvalidProtocolBufferException("Not an double value: " + parser.getText());
        }
    }

    public static String parseString(JsonParser parser) throws IOException {
        JsonToken json = parser.currentToken();
        String result = null;
        try {
            result = parser.getValueAsString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result == null) {
            throw new InvalidProtocolBufferException("Not a string value: " + json);
        }
        return result;
    }

    public static ByteString parseBytes(JsonParser parser) throws IOException {
        JsonToken json = parser.currentToken();
        byte[] result = null;
        try {
            result = Base64.getDecoder().decode(parser.getText());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (result == null) {
            throw new InvalidProtocolBufferException("Not a bytes value: " + json);
        }
        return ByteString.copyFrom((byte[])result);
    }

    public static int parseEnum(JsonParser parser, Descriptors.EnumDescriptor descriptor, boolean ignoringUnknownFields) throws IOException {
        JsonToken json;
        block9: {
            json = parser.currentToken();
            if (json == JsonToken.VALUE_NULL) {
                if (descriptor == NullValue.getDescriptor()) {
                    return 0;
                }
                return -1;
            }
            if (json.isNumeric()) {
                try {
                    return parser.getIntValue();
                }
                catch (IOException iOException) {
                    break block9;
                }
            }
            try {
                String value = parser.getValueAsString();
                Descriptors.EnumValueDescriptor enumValue = descriptor.findValueByName(value);
                if (enumValue != null) {
                    return enumValue.getNumber();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!ignoringUnknownFields) {
            throw new InvalidProtocolBufferException("Invalid enum value: " + json + " for enum type: " + descriptor.getFullName());
        }
        return -1;
    }

    public static int mapUnknownEnumValue(int value) {
        return value == -1 ? 0 : value;
    }

    public static <T extends Message> T parseMessage(JsonParser parser, TypeSpecificMarshaller<T> marshaller, int currentDepth) throws IOException {
        return marshaller.readValue(parser, currentDepth + 1);
    }

    public static int throwIfFieldAlreadyWritten(int setFieldsBits, int fieldBitMask, String fullName) throws InvalidProtocolBufferException {
        if ((setFieldsBits & fieldBitMask) != 0) {
            throw new InvalidProtocolBufferException("Field " + fullName + " has already been set.");
        }
        return setFieldsBits | fieldBitMask;
    }

    public static void throwIfOneofAlreadyWritten(JsonParser parser, Object oneofCase, String fieldName, boolean ignoreNull) throws InvalidProtocolBufferException {
        if (ignoreNull && parser.currentToken() == JsonToken.VALUE_NULL) {
            return;
        }
        if (((Internal.EnumLite)oneofCase).getNumber() != 0) {
            throw new InvalidProtocolBufferException("Cannot set field " + fieldName + " because another field " + oneofCase + " belonging to the same oneof has already been set.");
        }
    }

    public static void throwIfUnknownField(String fieldName, String messageName) throws InvalidProtocolBufferException {
        throw new InvalidProtocolBufferException("Cannot find field: " + fieldName + " in message " + messageName);
    }

    public static void checkRecursionLimit(int currentDepth) throws InvalidProtocolBufferException {
        if (currentDepth >= 100) {
            throw new InvalidProtocolBufferException("Hit recursion limit.");
        }
    }

    private static long parseLong(JsonParser parser) throws IOException {
        if (parser.currentToken() == JsonToken.VALUE_NUMBER_INT) {
            return parser.getLongValue();
        }
        return NumberInput.parseLong((String)parser.getText());
    }

    private ParseSupport() {
    }
}

