/*
 * Decompiled with CFR 0.152.
 */
package org.curioswitch.common.protobuf.json;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;

class ProtoFieldInfo {
    private final Descriptors.FieldDescriptor field;
    private final Message containingPrototype;
    private final Class<? extends Message.Builder> builderClass;
    private final String camelCaseName;
    @Nullable
    private final ProtoFieldInfo mapKeyField;
    @Nullable
    private final ProtoFieldInfo mapValueField;

    ProtoFieldInfo(Descriptors.FieldDescriptor field, Message containingPrototype) {
        this.field = Objects.requireNonNull(field, "field");
        this.containingPrototype = Objects.requireNonNull(containingPrototype, "containingPrototype");
        this.builderClass = containingPrototype.newBuilderForType().getClass();
        this.camelCaseName = ProtoFieldInfo.underscoresToUpperCamelCase(field.getName());
        if (field.isMapField()) {
            Descriptors.Descriptor mapType = field.getMessageType();
            this.mapKeyField = new ProtoFieldInfo(mapType.findFieldByName("key"), containingPrototype);
            this.mapValueField = new ProtoFieldInfo(mapType.findFieldByName("value"), containingPrototype);
        } else {
            this.mapKeyField = null;
            this.mapValueField = null;
        }
    }

    Descriptors.FieldDescriptor descriptor() {
        return this.field;
    }

    @EnsuresNonNullIf(expression={"mapKeyField", "mapValueField"}, result=true)
    boolean isMapField() {
        return this.field.isMapField();
    }

    boolean isRepeated() {
        return this.field.isRepeated();
    }

    @Nullable
    ProtoFieldInfo mapKeyField() {
        if (!this.isMapField()) {
            throw new IllegalStateException("Not a map field:" + this.field);
        }
        return this.mapKeyField;
    }

    ProtoFieldInfo valueField() {
        return this.mapValueField != null ? this.mapValueField : this;
    }

    Descriptors.FieldDescriptor.Type valueType() {
        return this.valueField().descriptor().getType();
    }

    Descriptors.FieldDescriptor.JavaType valueJavaType() {
        return this.valueField().descriptor().getJavaType();
    }

    Message valuePrototype() {
        Message nestedPrototype = this.containingPrototype.newBuilderForType().newBuilderForField(this.field).buildPartial();
        if (this.isMapField()) {
            nestedPrototype = (Message)nestedPrototype.getField(this.mapValueField.descriptor());
        }
        return nestedPrototype;
    }

    Method getValueMethod() {
        StringBuilder methodName = new StringBuilder().append("get").append(this.camelCaseName);
        if (this.valueJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
            methodName.append("Value");
        }
        if (this.isMapField()) {
            methodName.append("Map");
        } else if (this.field.isRepeated()) {
            methodName.append("List");
        }
        try {
            return this.containingPrototype.getClass().getDeclaredMethod(methodName.toString(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not find generated getter method.", e);
        }
    }

    Method oneOfCaseMethod() {
        if (!this.isInOneof()) {
            throw new IllegalStateException("field is not in a oneof");
        }
        String methodName = "get" + ProtoFieldInfo.underscoresToUpperCamelCase(this.field.getContainingOneof().getName()) + "Case";
        try {
            return this.containingPrototype.getClass().getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not find generated oneof case method.", e);
        }
    }

    Method hasValueMethod() {
        String methodName = "has" + this.camelCaseName;
        try {
            return this.containingPrototype.getClass().getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not find generated has method.", e);
        }
    }

    Method repeatedValueCountMethod() {
        String methodName = "get" + this.camelCaseName + "Count";
        try {
            return this.containingPrototype.getClass().getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not find repeated field count method.", e);
        }
    }

    Method setValueMethod() {
        Class[] args;
        StringBuilder setter = new StringBuilder();
        if (this.isMapField()) {
            setter.append("put");
            args = new Class[]{this.mapKeyField.javaClass(), this.javaClass()};
        } else {
            args = new Class[]{this.javaClass()};
            if (this.field.isRepeated()) {
                setter.append("add");
            } else {
                setter.append("set");
            }
        }
        setter.append(this.camelCaseName);
        if (this.valueType() == Descriptors.FieldDescriptor.Type.ENUM) {
            setter.append("Value");
        }
        try {
            return this.builderClass.getDeclaredMethod(setter.toString(), args);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not find setter.", e);
        }
    }

    boolean isInOneof() {
        return this.field.getContainingOneof() != null;
    }

    String getOneOfCaseMethodName() {
        if (!this.isInOneof()) {
            throw new IllegalStateException("field is not in a oneof");
        }
        return "get" + ProtoFieldInfo.underscoresToUpperCamelCase(this.field.getContainingOneof().getName()) + "Case";
    }

    Class<?> enumClass() {
        Class<?> messageClass = this.containingPrototype.getClass();
        if (!this.field.isRepeated()) {
            return this.getEnumAsClassMethod().getReturnType();
        }
        if (this.isMapField()) {
            if (this.valueJavaType() != Descriptors.FieldDescriptor.JavaType.ENUM) {
                throw new IllegalStateException("Trying to determine enum class of non-enum type: " + this.field);
            }
            Message msgWithEnumValue = this.containingPrototype.newBuilderForType().addRepeatedField(this.field, (Object)this.containingPrototype.newBuilderForType().newBuilderForField(this.field).setField(this.mapKeyField.descriptor(), this.mapKeyField.descriptor().getDefaultValue()).setField(this.mapValueField.descriptor(), this.mapValueField.descriptor().getDefaultValue()).build()).build();
            try {
                return messageClass.getDeclaredMethod(this.getMapValueOrThrowMethodName(), new ProtoFieldInfo(this.mapKeyField.descriptor(), this.containingPrototype).javaClass()).invoke((Object)msgWithEnumValue, this.mapKeyField.descriptor().getDefaultValue()).getClass();
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Could not find or invoke map item getter.", e);
            }
        }
        Message msgWithEnumValue = this.containingPrototype.newBuilderForType().addRepeatedField(this.valueField().descriptor(), this.valueField().descriptor().getEnumType().getValues().get(0)).build();
        try {
            return ((List)this.getEnumAsClassMethod().invoke((Object)msgWithEnumValue, new Object[0])).get(0).getClass();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Could not invoke enum getter for determining type.", e);
        }
    }

    Class<?> javaClass() {
        if (this.isMapField() && this.valueJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            Message mapEntry = this.containingPrototype.newBuilderForType().newBuilderForField(this.field).build();
            return mapEntry.getField(mapEntry.getDescriptorForType().findFieldByName("value")).getClass();
        }
        switch (this.valueJavaType()) {
            case INT: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case STRING: {
                return String.class;
            }
            case BYTE_STRING: {
                return ByteString.class;
            }
            case ENUM: {
                return Integer.TYPE;
            }
            case MESSAGE: {
                return this.containingPrototype.newBuilderForType().newBuilderForField(this.valueField().descriptor()).buildPartial().getClass();
            }
        }
        throw new IllegalArgumentException("Unknown field type: " + this.valueJavaType());
    }

    private String getMapValueOrThrowMethodName() {
        if (!this.isMapField()) {
            throw new IllegalStateException("field is not a map");
        }
        return "get" + this.camelCaseName + "OrThrow";
    }

    private Method getEnumAsClassMethod() {
        String getter = "get" + this.camelCaseName;
        if (this.field.isMapField()) {
            getter = getter + "Map";
        } else if (this.field.isRepeated()) {
            getter = getter + "List";
        }
        try {
            return this.containingPrototype.getClass().getDeclaredMethod(getter, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not find getter for enum field.", e);
        }
    }

    private static String underscoresToUpperCamelCase(String input) {
        boolean capitalizeNextLetter = true;
        StringBuilder result = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c >= 'a' && c <= 'z') {
                if (capitalizeNextLetter) {
                    result.append((char)(c + -32));
                } else {
                    result.append(c);
                }
                capitalizeNextLetter = false;
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                result.append(c);
                capitalizeNextLetter = false;
                continue;
            }
            if (c >= '0' && c <= '9') {
                result.append(c);
                capitalizeNextLetter = true;
                continue;
            }
            capitalizeNextLetter = true;
        }
        return result.toString();
    }
}

