/*
 * Decompiled with CFR 0.152.
 */
package org.curioswitch.common.protobuf.json;

import com.google.protobuf.Duration;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

final class ProtobufUtil {
    static final long DURATION_SECONDS_MIN = -315576000000L;
    static final long DURATION_SECONDS_MAX = 315576000000L;
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private static final long NANOS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final long NANOS_PER_MICROSECOND = TimeUnit.MICROSECONDS.toNanos(1L);
    private static final long MILLIS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    private static final String FIELD_PATH_SEPARATOR = ",";
    private static final ThreadLocal<SimpleDateFormat> timestampFormat = ThreadLocal.withInitial(ProtobufUtil::createTimestampFormat);

    private static SimpleDateFormat createTimestampFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setGregorianChange(new Date(Long.MIN_VALUE));
        sdf.setCalendar(calendar);
        return sdf;
    }

    static String formatTimestamp(Timestamp timestamp) {
        ProtobufUtil.checkValid(timestamp);
        long seconds = timestamp.getSeconds();
        int nanos = timestamp.getNanos();
        StringBuilder result = new StringBuilder();
        Date date = new Date(seconds * MILLIS_PER_SECOND);
        result.append(timestampFormat.get().format(date));
        if (nanos != 0) {
            result.append(".");
            result.append(ProtobufUtil.formatNanos(nanos));
        }
        result.append("Z");
        return result.toString();
    }

    static Timestamp parseTimestamp(String value) throws ParseException {
        int nanos;
        String timeValue;
        int dayOffset = value.indexOf(84);
        if (dayOffset == -1) {
            throw new ParseException("Failed to parse timestamp: invalid timestamp \"" + value + "\"", 0);
        }
        int timezoneOffsetPosition = value.indexOf(90, dayOffset);
        if (timezoneOffsetPosition == -1) {
            timezoneOffsetPosition = value.indexOf(43, dayOffset);
        }
        if (timezoneOffsetPosition == -1) {
            timezoneOffsetPosition = value.indexOf(45, dayOffset);
        }
        if (timezoneOffsetPosition == -1) {
            throw new ParseException("Failed to parse timestamp: missing valid timezone offset.", 0);
        }
        String secondValue = timeValue = value.substring(0, timezoneOffsetPosition);
        String nanoValue = "";
        int pointPosition = timeValue.indexOf(46);
        if (pointPosition != -1) {
            secondValue = timeValue.substring(0, pointPosition);
            nanoValue = timeValue.substring(pointPosition + 1);
        }
        Date date = timestampFormat.get().parse(secondValue);
        long seconds = date.getTime() / MILLIS_PER_SECOND;
        int n = nanos = nanoValue.isEmpty() ? 0 : ProtobufUtil.parseNanos(nanoValue);
        if (value.charAt(timezoneOffsetPosition) == 'Z') {
            if (value.length() != timezoneOffsetPosition + 1) {
                throw new ParseException("Failed to parse timestamp: invalid trailing data \"" + value.substring(timezoneOffsetPosition) + "\"", 0);
            }
        } else {
            String offsetValue = value.substring(timezoneOffsetPosition + 1);
            long offset = ProtobufUtil.parseTimezoneOffset(offsetValue);
            seconds = value.charAt(timezoneOffsetPosition) == '+' ? (seconds -= offset) : (seconds += offset);
        }
        try {
            return ProtobufUtil.normalizedTimestamp(seconds, nanos);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Failed to parse timestamp: timestamp is out of range.", 0);
        }
    }

    static String formatDuration(Duration duration) {
        ProtobufUtil.checkValid(duration);
        long seconds = duration.getSeconds();
        int nanos = duration.getNanos();
        StringBuilder result = new StringBuilder();
        if (seconds < 0L || nanos < 0) {
            result.append("-");
            seconds = -seconds;
            nanos = -nanos;
        }
        result.append(seconds);
        if (nanos != 0) {
            result.append(".");
            result.append(ProtobufUtil.formatNanos(nanos));
        }
        result.append("s");
        return result.toString();
    }

    static Duration parseDuration(String value) throws ParseException {
        int nanos;
        if (value.isEmpty() || value.charAt(value.length() - 1) != 's') {
            throw new ParseException("Invalid duration string: " + value, 0);
        }
        boolean negative = false;
        if (value.charAt(0) == '-') {
            negative = true;
            value = value.substring(1);
        }
        String secondValue = value.substring(0, value.length() - 1);
        String nanoValue = "";
        int pointPosition = secondValue.indexOf(46);
        if (pointPosition != -1) {
            nanoValue = secondValue.substring(pointPosition + 1);
            secondValue = secondValue.substring(0, pointPosition);
        }
        long seconds = Long.parseLong(secondValue);
        int n = nanos = nanoValue.isEmpty() ? 0 : ProtobufUtil.parseNanos(nanoValue);
        if (seconds < 0L) {
            throw new ParseException("Invalid duration string: " + value, 0);
        }
        if (negative) {
            seconds = -seconds;
            nanos = -nanos;
        }
        try {
            return ProtobufUtil.normalizedDuration(seconds, nanos);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Duration value is out of range.", 0);
        }
    }

    static String fieldMaskToJson(FieldMask fieldMask) {
        StringBuilder out = new StringBuilder();
        for (String path : fieldMask.getPathsList()) {
            if (path.isEmpty()) continue;
            out.append(ProtobufUtil.snakeToCamel(path));
            out.append(FIELD_PATH_SEPARATOR);
        }
        if (out.length() > 0) {
            out.setLength(out.length() - 1);
        }
        return out.toString();
    }

    static FieldMask fieldMaskFromJson(String s) {
        FieldMask.Builder builder = FieldMask.newBuilder();
        int i = 0;
        int j = -1;
        while (true) {
            ++j;
            if ((j = s.indexOf(FIELD_PATH_SEPARATOR, j)) == -1) break;
            if (i == j) continue;
            builder.addPaths(ProtobufUtil.camelToSnake(s.substring(i, j)));
            i = j + 1;
        }
        if (i < s.length()) {
            builder.addPaths(ProtobufUtil.camelToSnake(s.substring(i)));
        }
        return builder.build();
    }

    static String snakeToCamel(String s) {
        StringBuilder out = null;
        int i = 0;
        int j = -1;
        while (true) {
            ++j;
            if ((j = s.indexOf(95, j)) == -1) break;
            if (i == 0) {
                out = new StringBuilder(s.length());
                if (i != j) {
                    out.append(ProtobufUtil.toLowerCase(s.charAt(i)));
                    out.append(s, i + 1, j);
                }
            } else if (i != j) {
                out.append(ProtobufUtil.toUpperCase(s.charAt(i)));
                out.append(s, i + 1, j);
            }
            i = j + 1;
        }
        if (i == 0) {
            return s.toLowerCase(Locale.ROOT);
        }
        if (i < s.length()) {
            out.append(ProtobufUtil.toUpperCase(s.charAt(i)));
            out.append(s, i + 1, s.length());
        }
        return out.toString();
    }

    static String camelToSnake(String s) {
        StringBuilder out = null;
        int i = 0;
        for (int j = 0; j < s.length(); ++j) {
            char c = s.charAt(j);
            if (c < 'A' || c > 'Z') continue;
            if (i == 0) {
                out = new StringBuilder(s.length() + 4);
            }
            if (i != j) {
                out.append(ProtobufUtil.toLowerCase(s.charAt(i)));
                out.append(s, i + 1, j);
            }
            out.append('_');
            i = j;
        }
        if (i == 0) {
            return s.toLowerCase(Locale.ROOT);
        }
        out.append(ProtobufUtil.toLowerCase(s.charAt(i)));
        out.append(s, i + 1, s.length());
        return out.toString();
    }

    private static char toLowerCase(char c) {
        if (c < 'A' || c > 'Z') {
            return c;
        }
        return (char)(c - -32);
    }

    private static char toUpperCase(char c) {
        if (c < 'a' || c > 'z') {
            return c;
        }
        return (char)(c + -32);
    }

    private static Duration normalizedDuration(long seconds, int nanos) {
        if ((long)nanos <= -NANOS_PER_SECOND || (long)nanos >= NANOS_PER_SECOND) {
            seconds = ProtobufUtil.checkedAdd(seconds, (long)nanos / NANOS_PER_SECOND);
            nanos = (int)((long)nanos % NANOS_PER_SECOND);
        }
        if (seconds > 0L && nanos < 0) {
            nanos = (int)((long)nanos + NANOS_PER_SECOND);
            --seconds;
        }
        if (seconds < 0L && nanos > 0) {
            nanos = (int)((long)nanos - NANOS_PER_SECOND);
            ++seconds;
        }
        Duration duration = Duration.newBuilder().setSeconds(seconds).setNanos(nanos).build();
        return ProtobufUtil.checkValid(duration);
    }

    private static boolean isValid(long seconds, int nanos) {
        if (seconds < -315576000000L || seconds > 315576000000L) {
            return false;
        }
        if ((long)nanos < -999999999L || (long)nanos >= NANOS_PER_SECOND) {
            return false;
        }
        return seconds >= 0L && nanos >= 0 || seconds <= 0L && nanos <= 0;
    }

    static String formatNanos(int nanos) {
        if ((long)nanos % NANOS_PER_MILLISECOND == 0L) {
            return String.format(Locale.ENGLISH, "%1$03d", (long)nanos / NANOS_PER_MILLISECOND);
        }
        if ((long)nanos % NANOS_PER_MICROSECOND == 0L) {
            return String.format(Locale.ENGLISH, "%1$06d", (long)nanos / NANOS_PER_MICROSECOND);
        }
        return String.format(Locale.ENGLISH, "%1$09d", nanos);
    }

    private static int parseNanos(String value) throws ParseException {
        int result = 0;
        for (int i = 0; i < 9; ++i) {
            result *= 10;
            if (i >= value.length()) continue;
            if (value.charAt(i) < '0' || value.charAt(i) > '9') {
                throw new ParseException("Invalid nanoseconds.", 0);
            }
            result += value.charAt(i) - 48;
        }
        return result;
    }

    private static long parseTimezoneOffset(String value) throws ParseException {
        int pos = value.indexOf(58);
        if (pos == -1) {
            throw new ParseException("Invalid offset value: " + value, 0);
        }
        String hours = value.substring(0, pos);
        String minutes = value.substring(pos + 1);
        return (Long.parseLong(hours) * 60L + Long.parseLong(minutes)) * 60L;
    }

    private static Timestamp normalizedTimestamp(long seconds, int nanos) {
        if ((long)nanos <= -NANOS_PER_SECOND || (long)nanos >= NANOS_PER_SECOND) {
            seconds = ProtobufUtil.checkedAdd(seconds, (long)nanos / NANOS_PER_SECOND);
            nanos = (int)((long)nanos % NANOS_PER_SECOND);
        }
        if (nanos < 0) {
            nanos = (int)((long)nanos + NANOS_PER_SECOND);
            seconds = ProtobufUtil.checkedSubtract(seconds, 1L);
        }
        Timestamp timestamp = Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build();
        return ProtobufUtil.checkValid(timestamp);
    }

    private static Duration checkValid(Duration duration) {
        int nanos;
        long seconds = duration.getSeconds();
        if (!ProtobufUtil.isValid(seconds, nanos = duration.getNanos())) {
            throw new IllegalArgumentException(String.format("Duration is not valid. See proto definition for valid values. Seconds (%s) must be in range [-315,576,000,000, +315,576,000,000]. Nanos (%s) must be in range [-999,999,999, +999,999,999]. Nanos must have the same sign as seconds", seconds, nanos));
        }
        return duration;
    }

    private static Timestamp checkValid(Timestamp timestamp) {
        int nanos;
        long seconds = timestamp.getSeconds();
        if (!ProtobufUtil.isValid(seconds, nanos = timestamp.getNanos())) {
            throw new IllegalArgumentException(String.format("Timestamp is not valid. See proto definition for valid values. Seconds (%s) must be in range [-62,135,596,800, +253,402,300,799]. Nanos (%s) must be in range [0, +999,999,999].", seconds, nanos));
        }
        return timestamp;
    }

    private static long checkedAdd(long a, long b) {
        long result;
        if ((a ^ b) < 0L | (a ^ (result = a + b)) >= 0L) {
            return result;
        }
        throw new ArithmeticException("overflow: checkedAdd(" + a + ", " + b + ")");
    }

    private static long checkedSubtract(long a, long b) {
        long result;
        if ((a ^ b) >= 0L | (a ^ (result = a - b)) >= 0L) {
            return result;
        }
        throw new ArithmeticException("overflow: checkedSubtract(" + a + ", " + b + ")");
    }

    private ProtobufUtil() {
    }
}

