/*
 * Decompiled with CFR 0.152.
 */
package org.curioswitch.common.protobuf.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.NullValue;
import com.google.protobuf.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import org.curioswitch.common.protobuf.json.CodeGenUtil;
import org.curioswitch.common.protobuf.json.LocalVariables;
import org.curioswitch.common.protobuf.json.ParseSupport;
import org.curioswitch.common.protobuf.json.ProtoFieldInfo;
import org.curioswitch.common.protobuf.json.TypeSpecificMarshaller;
import org.curioswitch.common.protobuf.json.bytebuddy.Goto;
import org.curioswitch.common.protobuf.json.bytebuddy.IfEqual;
import org.curioswitch.common.protobuf.json.bytebuddy.IfRefsEqual;
import org.curioswitch.common.protobuf.json.bytebuddy.IfRefsNotEqual;
import org.curioswitch.common.protobuf.json.bytebuddy.IfTrue;
import org.curioswitch.common.protobuf.json.bytebuddy.SetJumpTargetLabel;

final class DoParse
implements ByteCodeAppender,
Implementation {
    private static final StackManipulation Parser_getCurrentName;
    private static final StackManipulation Parser_currentToken;
    private static final StackManipulation Parser_nextValue;
    private static final StackManipulation Parser_nextToken;
    private static final StackManipulation ParseSupport_parseArrayStart;
    private static final StackManipulation ParseSupport_checkArrayEnd;
    private static final StackManipulation ParseSupport_parseObjectStart;
    private static final StackManipulation ParseSupport_checkObjectEnd;
    private static final StackManipulation ParseSupport_checkNull;
    private static final StackManipulation ParseSupport_throwIfRepeatedNull;
    private static final StackManipulation ParseSupport_throwIfFieldAlreadyWritten;
    private static final StackManipulation ParseSupport_throwIfOneofAlreadyWritten;
    private static final StackManipulation ParseSupport_throwIfUnknownField;
    private static final StackManipulation ParseSupport_parseInt32;
    private static final StackManipulation ParseSupport_parseInt64;
    private static final StackManipulation ParseSupport_parseUint32;
    private static final StackManipulation ParseSupport_parseUint64;
    private static final StackManipulation ParseSupport_parseBool;
    private static final StackManipulation ParseSupport_parseFloat;
    private static final StackManipulation ParseSupport_parseDouble;
    private static final StackManipulation ParseSupport_parseString;
    private static final StackManipulation ParseSupport_parseBytes;
    private static final StackManipulation ParseSupport_parseEnum;
    private static final StackManipulation ParseSupport_mapUnknownEnumValue;
    private static final StackManipulation ParseSupport_parseMessage;
    private final Message prototype;
    private final Class<? extends Message.Builder> builderClass;
    private final Descriptors.Descriptor descriptor;
    private final boolean ignoringUnknownFields;

    DoParse(Message prototype, boolean ignoringUnknownFields) {
        this.prototype = prototype;
        this.builderClass = prototype.newBuilderForType().getClass();
        this.descriptor = prototype.getDescriptorForType();
        this.ignoringUnknownFields = ignoringUnknownFields;
    }

    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
        Map<String, FieldDescription> fieldsByName = CodeGenUtil.fieldsByName(implementationContext);
        List<Descriptors.FieldDescriptor> sortedFields = CodeGenUtil.sorted(this.descriptor.getFields());
        Descriptors.FieldDescriptor lastField = !sortedFields.isEmpty() ? sortedFields.get(sortedFields.size() - 1) : null;
        int lastFieldNumber = lastField != null ? lastField.getNumber() : 0;
        int numFieldPresenceWords = lastFieldNumber / 32;
        if (lastFieldNumber % 32 > 0) {
            ++numFieldPresenceWords;
        }
        LocalVariable[] fieldPresenceVars = new LocalVariable[numFieldPresenceWords];
        for (int i = 0; i < numFieldPresenceWords; ++i) {
            fieldPresenceVars[i] = new LocalVariable("setFieldBits" + i);
        }
        LocalVariables.VariableHandle[] handles = Arrays.copyOf(LocalVariable.values(), LocalVariable.values().length + fieldPresenceVars.length);
        System.arraycopy(fieldPresenceVars, 0, handles, LocalVariable.values().length, fieldPresenceVars.length);
        LocalVariables.Builder<LocalVariable> localsBuilder = LocalVariables.builderForMethod((MethodDescription)instrumentedMethod, (LocalVariables.VariableHandle[])handles).add(this.builderClass, LocalVariable.builder).add(String.class, LocalVariable.fieldName).add(Integer.TYPE, LocalVariable.intvalue).add(Integer.TYPE, LocalVariable.intMapKey).add(Long.TYPE, LocalVariable.longMapKey).add(Boolean.TYPE, LocalVariable.boolMapKey).add(String.class, LocalVariable.stringMapKey);
        for (LocalVariable fieldPresenceVar : fieldPresenceVars) {
            localsBuilder.add(Integer.TYPE, fieldPresenceVar);
        }
        LocalVariables<LocalVariable> locals = localsBuilder.build();
        ArrayList<Object> stackManipulations = new ArrayList<Object>();
        Label beforeReadField = new Label();
        Label finished = new Label();
        stackManipulations.addAll(Arrays.asList(locals.initialize(), locals.load(LocalVariable.messageBuilder), TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(this.builderClass)), locals.store(LocalVariable.builder)));
        stackManipulations.addAll(Arrays.asList(new SetJumpTargetLabel(beforeReadField), locals.load(LocalVariable.parser), Parser_nextValue, ParseSupport_checkObjectEnd, new IfTrue(finished), locals.load(LocalVariable.parser), Parser_getCurrentName, locals.store(LocalVariable.fieldName)));
        for (Descriptors.FieldDescriptor f : sortedFields) {
            Label afterNameCheck = new Label();
            Label afterField = new Label();
            ProtoFieldInfo field = new ProtoFieldInfo(f, this.prototype);
            int fieldNumberZeroBased = field.descriptor().getNumber() - 1;
            LocalVariable fieldPresenceVar = fieldPresenceVars[fieldNumberZeroBased / 32];
            int fieldPreserveVarBitIndex = fieldNumberZeroBased % 32;
            stackManipulations.addAll(Arrays.asList(locals.load(LocalVariable.fieldName), new TextConstant(field.descriptor().getJsonName()), new IfRefsEqual(afterNameCheck), locals.load(LocalVariable.fieldName), new TextConstant(field.descriptor().getName()), new IfRefsNotEqual(afterField), new SetJumpTargetLabel(afterNameCheck)));
            stackManipulations.addAll(Arrays.asList(locals.load(fieldPresenceVar), IntegerConstant.forValue((int)(1 << fieldPreserveVarBitIndex)), new TextConstant(field.descriptor().getFullName()), ParseSupport_throwIfFieldAlreadyWritten, locals.store(fieldPresenceVar)));
            if (field.isInOneof()) {
                try {
                    stackManipulations.addAll(Arrays.asList(locals.load(LocalVariable.parser), locals.load(LocalVariable.builder), CodeGenUtil.invoke(this.builderClass.getDeclaredMethod(field.getOneOfCaseMethodName(), new Class[0])), new TextConstant(field.descriptor().getFullName()), IntegerConstant.forValue((boolean)DoParse.mustSkipNull(field.descriptor())), ParseSupport_throwIfOneofAlreadyWritten));
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Could not find oneof case method.", e);
                }
            }
            if (DoParse.mustSkipNull(field.descriptor())) {
                stackManipulations.addAll(Arrays.asList(locals.load(LocalVariable.parser), ParseSupport_checkNull, new IfTrue(beforeReadField)));
            }
            StackManipulation setValue = this.setFieldValue(field, beforeReadField, locals, fieldsByName);
            stackManipulations.add(setValue);
            stackManipulations.add(new SetJumpTargetLabel(afterField));
        }
        if (this.ignoringUnknownFields) {
            stackManipulations.add(new Goto(beforeReadField));
        } else {
            stackManipulations.addAll(Arrays.asList(locals.load(LocalVariable.fieldName), new TextConstant(this.descriptor.getFullName()), ParseSupport_throwIfUnknownField));
        }
        stackManipulations.add(new SetJumpTargetLabel(finished));
        stackManipulations.add(MethodReturn.VOID);
        StackManipulation.Size operandStackSize = new StackManipulation.Compound(stackManipulations).apply(methodVisitor, implementationContext);
        return new ByteCodeAppender.Size(operandStackSize.getMaximalSize(), locals.stackSize());
    }

    private StackManipulation setFieldValue(ProtoFieldInfo info, Label beforeReadField, LocalVariables<LocalVariable> locals, Map<String, FieldDescription> fieldsByName) {
        if (info.isMapField()) {
            return this.setMapFieldValue(info, beforeReadField, locals, fieldsByName);
        }
        StackManipulation setConcreteValue = CodeGenUtil.invoke(info.setValueMethod());
        Object setSingleValue = info.valueJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? new StackManipulation.Compound(new StackManipulation[]{TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(info.javaClass())), setConcreteValue}) : (info.valueType() == Descriptors.FieldDescriptor.Type.ENUM && !info.isRepeated() ? new StackManipulation.Compound(new StackManipulation[]{ParseSupport_mapUnknownEnumValue, setConcreteValue}) : setConcreteValue);
        if (info.descriptor().isRepeated()) {
            return this.setRepeatedFieldValue(info, beforeReadField, locals, fieldsByName, (StackManipulation)setSingleValue);
        }
        return new StackManipulation.Compound(new StackManipulation[]{locals.load(LocalVariable.builder), locals.load(LocalVariable.parser), this.readValue(info, fieldsByName, locals), setSingleValue, Removal.SINGLE, new Goto(beforeReadField)});
    }

    private StackManipulation setRepeatedFieldValue(ProtoFieldInfo info, Label beforeReadField, LocalVariables<LocalVariable> locals, Map<String, FieldDescription> fieldsByName, StackManipulation setSingleValue) {
        Label arrayStart = new Label();
        StackManipulation.Compound beforeRead = new StackManipulation.Compound(new StackManipulation[]{locals.load(LocalVariable.parser), ParseSupport_parseArrayStart, new SetJumpTargetLabel(arrayStart), locals.load(LocalVariable.parser), ParseSupport_throwIfRepeatedNull, locals.load(LocalVariable.parser), ParseSupport_checkArrayEnd, new IfTrue(beforeReadField)});
        Label afterSet = new Label();
        StackManipulation.Compound setValueAndPrepareForNext = new StackManipulation.Compound(new StackManipulation[]{setSingleValue, Removal.SINGLE, new SetJumpTargetLabel(afterSet), locals.load(LocalVariable.parser), Parser_nextValue, Removal.SINGLE, new Goto(arrayStart)});
        if (info.valueType() == Descriptors.FieldDescriptor.Type.ENUM) {
            return new StackManipulation.Compound(new StackManipulation[]{beforeRead, locals.load(LocalVariable.parser), this.readValue(info, fieldsByName, locals), locals.store(LocalVariable.intvalue), locals.load(LocalVariable.intvalue), IntegerConstant.forValue((int)-1), new IfEqual(Integer.TYPE, afterSet), locals.load(LocalVariable.builder), locals.load(LocalVariable.intvalue), setValueAndPrepareForNext});
        }
        return new StackManipulation.Compound(new StackManipulation[]{beforeRead, locals.load(LocalVariable.builder), locals.load(LocalVariable.parser), this.readValue(info, fieldsByName, locals), setValueAndPrepareForNext});
    }

    private StackManipulation setMapFieldValue(ProtoFieldInfo info, Label beforeReadField, LocalVariables<LocalVariable> locals, Map<String, FieldDescription> fieldsByName) {
        StackManipulation setConcreteValue = CodeGenUtil.invoke(info.setValueMethod());
        Object setMapEntry = info.valueJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? new StackManipulation.Compound(new StackManipulation[]{TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(info.javaClass())), setConcreteValue}) : setConcreteValue;
        Label mapStart = new Label();
        Label afterSet = new Label();
        StackManipulation.Compound beforeReadKey = new StackManipulation.Compound(new StackManipulation[]{locals.load(LocalVariable.parser), ParseSupport_parseObjectStart, new SetJumpTargetLabel(mapStart), locals.load(LocalVariable.parser), Parser_currentToken, ParseSupport_checkObjectEnd, new IfTrue(beforeReadField)});
        StackManipulation.Compound setValueAndPrepareForNext = new StackManipulation.Compound(new StackManipulation[]{setMapEntry, Removal.SINGLE, new SetJumpTargetLabel(afterSet), locals.load(LocalVariable.parser), Parser_nextToken, Removal.SINGLE, new Goto(mapStart)});
        if (info.valueType() == Descriptors.FieldDescriptor.Type.ENUM) {
            LocalVariable keyVar;
            switch (info.mapKeyField().valueJavaType()) {
                case INT: {
                    keyVar = LocalVariable.intMapKey;
                    break;
                }
                case LONG: {
                    keyVar = LocalVariable.longMapKey;
                    break;
                }
                case BOOLEAN: {
                    keyVar = LocalVariable.boolMapKey;
                    break;
                }
                case STRING: {
                    keyVar = LocalVariable.stringMapKey;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid map key type");
                }
            }
            return new StackManipulation.Compound(new StackManipulation[]{beforeReadKey, locals.load(LocalVariable.parser), this.readValue(info.mapKeyField(), fieldsByName, locals), locals.store(keyVar), locals.load(LocalVariable.parser), Parser_nextToken, Removal.SINGLE, locals.load(LocalVariable.parser), this.readValue(info, fieldsByName, locals), locals.store(LocalVariable.intvalue), locals.load(LocalVariable.intvalue), IntegerConstant.forValue((int)-1), new IfEqual(Integer.TYPE, afterSet), locals.load(LocalVariable.builder), locals.load(keyVar), locals.load(LocalVariable.intvalue), setValueAndPrepareForNext});
        }
        return new StackManipulation.Compound(new StackManipulation[]{beforeReadKey, locals.load(LocalVariable.builder), locals.load(LocalVariable.parser), this.readValue(info.mapKeyField(), fieldsByName, locals), locals.load(LocalVariable.parser), Parser_nextToken, Removal.SINGLE, locals.load(LocalVariable.parser), this.readValue(info, fieldsByName, locals), setValueAndPrepareForNext});
    }

    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return this;
    }

    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    private StackManipulation readValue(ProtoFieldInfo field, Map<String, FieldDescription> fieldsByName, LocalVariables<LocalVariable> locals) {
        switch (field.valueType()) {
            case INT32: 
            case SINT32: 
            case SFIXED32: {
                return ParseSupport_parseInt32;
            }
            case INT64: 
            case SINT64: 
            case SFIXED64: {
                return ParseSupport_parseInt64;
            }
            case BOOL: {
                return ParseSupport_parseBool;
            }
            case FLOAT: {
                return ParseSupport_parseFloat;
            }
            case DOUBLE: {
                return ParseSupport_parseDouble;
            }
            case UINT32: 
            case FIXED32: {
                return ParseSupport_parseUint32;
            }
            case UINT64: 
            case FIXED64: {
                return ParseSupport_parseUint64;
            }
            case STRING: {
                return ParseSupport_parseString;
            }
            case BYTES: {
                return ParseSupport_parseBytes;
            }
            case ENUM: {
                return new StackManipulation.Compound(new StackManipulation[]{CodeGenUtil.getEnumDescriptor(field), IntegerConstant.forValue((boolean)this.ignoringUnknownFields), ParseSupport_parseEnum});
            }
            case MESSAGE: 
            case GROUP: {
                return new StackManipulation.Compound(new StackManipulation[]{FieldAccess.forField((FieldDescription)fieldsByName.get(CodeGenUtil.fieldNameForNestedMarshaller(field.valueField().descriptor().getMessageType()))).read(), locals.load(LocalVariable.currentDepth), ParseSupport_parseMessage});
            }
        }
        throw new IllegalStateException("Unknown field type: " + field.valueType());
    }

    private static boolean mustSkipNull(Descriptors.FieldDescriptor field) {
        if (field.isRepeated()) {
            return true;
        }
        if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE && field.getMessageType() == Value.getDescriptor()) {
            return false;
        }
        return field.getJavaType() != Descriptors.FieldDescriptor.JavaType.ENUM || field.getEnumType() != NullValue.getDescriptor();
    }

    static {
        try {
            Parser_getCurrentName = CodeGenUtil.invoke(JsonParser.class.getDeclaredMethod("getCurrentName", new Class[0]));
            Parser_currentToken = CodeGenUtil.invoke(JsonParser.class.getDeclaredMethod("currentToken", new Class[0]));
            Parser_nextValue = CodeGenUtil.invoke(JsonParser.class.getDeclaredMethod("nextValue", new Class[0]));
            Parser_nextToken = CodeGenUtil.invoke(JsonParser.class.getDeclaredMethod("nextToken", new Class[0]));
            ParseSupport_parseArrayStart = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("parseArrayStart", JsonParser.class));
            ParseSupport_checkArrayEnd = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("checkArrayEnd", JsonParser.class));
            ParseSupport_parseObjectStart = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("parseObjectStart", JsonParser.class));
            ParseSupport_checkObjectEnd = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("checkObjectEnd", JsonToken.class));
            ParseSupport_checkNull = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("checkNull", JsonParser.class));
            ParseSupport_throwIfRepeatedNull = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("throwIfRepeatedValueNull", JsonParser.class));
            ParseSupport_throwIfFieldAlreadyWritten = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("throwIfFieldAlreadyWritten", Integer.TYPE, Integer.TYPE, String.class));
            ParseSupport_throwIfOneofAlreadyWritten = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("throwIfOneofAlreadyWritten", JsonParser.class, Object.class, String.class, Boolean.TYPE));
            ParseSupport_throwIfUnknownField = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("throwIfUnknownField", String.class, String.class));
            ParseSupport_parseInt32 = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("parseInt32", JsonParser.class));
            ParseSupport_parseInt64 = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("parseInt64", JsonParser.class));
            ParseSupport_parseUint32 = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("parseUInt32", JsonParser.class));
            ParseSupport_parseUint64 = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("parseUInt64", JsonParser.class));
            ParseSupport_parseBool = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("parseBool", JsonParser.class));
            ParseSupport_parseFloat = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("parseFloat", JsonParser.class));
            ParseSupport_parseDouble = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("parseDouble", JsonParser.class));
            ParseSupport_parseString = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("parseString", JsonParser.class));
            ParseSupport_parseBytes = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("parseBytes", JsonParser.class));
            ParseSupport_parseEnum = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("parseEnum", JsonParser.class, Descriptors.EnumDescriptor.class, Boolean.TYPE));
            ParseSupport_mapUnknownEnumValue = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("mapUnknownEnumValue", Integer.TYPE));
            ParseSupport_parseMessage = CodeGenUtil.invoke(ParseSupport.class.getDeclaredMethod("parseMessage", JsonParser.class, TypeSpecificMarshaller.class, Integer.TYPE));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not find expected method.", e);
        }
    }

    private static class LocalVariable
    implements LocalVariables.VariableHandle {
        private static final LocalVariable parser = new LocalVariable("parser");
        private static final LocalVariable currentDepth = new LocalVariable("currentDepth");
        private static final LocalVariable messageBuilder = new LocalVariable("messageBuilder");
        private static final LocalVariable builder = new LocalVariable("builder");
        private static final LocalVariable fieldName = new LocalVariable("fieldName");
        private static final LocalVariable intvalue = new LocalVariable("intValue");
        private static final LocalVariable intMapKey = new LocalVariable("intMapKey");
        private static final LocalVariable longMapKey = new LocalVariable("longMapKey");
        private static final LocalVariable boolMapKey = new LocalVariable("boolMapKey");
        private static final LocalVariable stringMapKey = new LocalVariable("stringMapKey");
        private final String name;

        private LocalVariable(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        static LocalVariable[] values() {
            return new LocalVariable[]{parser, currentDepth, messageBuilder, builder, fieldName, intvalue, intMapKey, longMapKey, boolMapKey, stringMapKey};
        }
    }
}

