/*
 * Decompiled with CFR 0.152.
 */
package org.curioswitch.common.protobuf.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.SerializedString;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.curioswitch.common.protobuf.json.CodeGenUtil;
import org.curioswitch.common.protobuf.json.DoParse;
import org.curioswitch.common.protobuf.json.DoWrite;
import org.curioswitch.common.protobuf.json.ParseSupport;
import org.curioswitch.common.protobuf.json.ProtoFieldInfo;
import org.curioswitch.common.protobuf.json.SetSerializedFieldName;

public abstract class TypeSpecificMarshaller<T extends Message> {
    private final T prototype;

    protected TypeSpecificMarshaller(T prototype) {
        this.prototype = prototype;
    }

    T readValue(JsonParser parser, int currentDepth) throws IOException {
        Message.Builder builder = this.prototype.newBuilderForType();
        this.mergeValue(parser, currentDepth, builder);
        Message built = builder.build();
        return (T)built;
    }

    void mergeValue(JsonParser parser, int currentDepth, Message.Builder builder) throws IOException {
        ParseSupport.checkRecursionLimit(currentDepth);
        JsonToken json = parser.currentToken();
        if (json == null) {
            json = parser.nextToken();
        }
        if (json != JsonToken.START_OBJECT) {
            throw new InvalidProtocolBufferException("Expected start of object, got: " + parser.getText());
        }
        this.doMerge(parser, currentDepth, builder);
    }

    final T parseRemainingFieldsOfObjectAsMessage(JsonParser parser, int currentDepth) throws IOException {
        Message.Builder builder = this.prototype.newBuilderForType();
        this.doMerge(parser, currentDepth, builder);
        Message built = builder.build();
        return (T)built;
    }

    void writeValue(T message, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        this.doWrite(message, gen);
        gen.writeEndObject();
    }

    void writeValue(ByteString encodedMessage, JsonGenerator gen) throws IOException {
        Parser parser = this.prototype.getParserForType();
        this.writeValue((Message)parser.parseFrom(encodedMessage), gen);
    }

    void doWrite(ByteString encodedMessage, JsonGenerator gen) throws IOException {
        Parser parser = this.prototype.getParserForType();
        this.doWrite((Message)parser.parseFrom(encodedMessage), gen);
    }

    protected void doWrite(T message, JsonGenerator gen) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void doMerge(JsonParser parser, int currentDepth, Message.Builder messageBuilder) throws IOException {
        throw new UnsupportedOperationException();
    }

    Descriptors.Descriptor getDescriptorForMarshalledType() {
        return this.prototype.getDescriptorForType();
    }

    T getMarshalledPrototype() {
        return this.prototype;
    }

    static <T extends Message> void buildAndAdd(T prototype, boolean includingDefaultValueFields, Set<Descriptors.FieldDescriptor> fieldsToAlwaysOutput, boolean preservingProtoFieldNames, boolean ignoringUnknownFields, boolean printingEnumsAsInts, boolean sortingMapKeys, Map<Descriptors.Descriptor, TypeSpecificMarshaller<?>> builtMarshallers) {
        if (builtMarshallers.containsKey(prototype.getDescriptorForType())) {
            return;
        }
        TypeSpecificMarshaller.buildOrFindMarshaller(prototype, includingDefaultValueFields, fieldsToAlwaysOutput, preservingProtoFieldNames, ignoringUnknownFields, printingEnumsAsInts, sortingMapKeys, builtMarshallers);
        HashMap builtMarshallersByFieldName = new HashMap();
        for (Map.Entry<Descriptors.Descriptor, TypeSpecificMarshaller<?>> entry : builtMarshallers.entrySet()) {
            builtMarshallersByFieldName.put(CodeGenUtil.fieldNameForNestedMarshaller(entry.getKey()), entry.getValue());
        }
        for (TypeSpecificMarshaller typeSpecificMarshaller : builtMarshallers.values()) {
            for (Field field : typeSpecificMarshaller.getClass().getDeclaredFields()) {
                if (!field.getName().startsWith("MARSHALLER_")) continue;
                try {
                    TypeSpecificMarshaller nested = (TypeSpecificMarshaller)builtMarshallersByFieldName.get(field.getName());
                    if (nested == null) {
                        throw new IllegalStateException("nested marshaller could not be found for field: + field.getName()");
                    }
                    field.set(typeSpecificMarshaller, nested);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Could not set marshaller field, which we know is accessible.", e);
                }
            }
        }
    }

    private static <T extends Message> void buildOrFindMarshaller(T prototype, boolean includingDefaultValueFields, Set<Descriptors.FieldDescriptor> fieldsToAlwaysOutput, boolean preservingProtoFieldNames, boolean ignoringUnknownFields, boolean printingEnumsAsInts, boolean sortingMapKeys, Map<Descriptors.Descriptor, TypeSpecificMarshaller<?>> alreadyBuiltMarshallers) {
        TypeSpecificMarshaller marshaller;
        Descriptors.Descriptor descriptor = prototype.getDescriptorForType();
        if (alreadyBuiltMarshallers.containsKey(descriptor)) {
            return;
        }
        TypeDescription.Generic superType = TypeDescription.Generic.Builder.parameterizedType(TypeSpecificMarshaller.class, (Type[])new Type[]{prototype.getClass()}).build();
        DynamicType.Builder buddy = new ByteBuddy().subclass((TypeDefinition)superType).modifiers(17).visit((AsmVisitorWrapper)new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2));
        ArrayList<Message> nestedMessagePrototypes = new ArrayList<Message>();
        for (Descriptors.FieldDescriptor f : descriptor.getFields()) {
            Message nestedPrototype;
            ProtoFieldInfo field = new ProtoFieldInfo(f, prototype);
            String fieldName = CodeGenUtil.fieldNameForSerializedFieldName(field);
            buddy = buddy.defineField(fieldName, SerializedString.class, 26).initializer((ByteCodeAppender)new SetSerializedFieldName(fieldName, preservingProtoFieldNames ? f.getName() : f.getJsonName()));
            if (field.valueJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE || nestedMessagePrototypes.contains(nestedPrototype = field.valuePrototype())) continue;
            nestedMessagePrototypes.add(nestedPrototype);
            TypeDescription.Generic nestedMarshallerType = TypeDescription.Generic.Builder.parameterizedType(TypeSpecificMarshaller.class, (Type[])new Type[]{nestedPrototype.getClass()}).build();
            buddy = buddy.defineField(CodeGenUtil.fieldNameForNestedMarshaller(nestedPrototype.getDescriptorForType()), (TypeDefinition)nestedMarshallerType, 9);
        }
        buddy = buddy.defineMethod("doMerge", Void.TYPE, 20).withParameter(JsonParser.class, "parser", new ModifierContributor.ForParameter[0]).withParameter(Integer.TYPE, "currentDepth", new ModifierContributor.ForParameter[0]).withParameter(Message.Builder.class, "messageBuilder", new ModifierContributor.ForParameter[0]).throwing(new Type[]{IOException.class}).intercept((Implementation)new DoParse(prototype, ignoringUnknownFields)).defineMethod("doWrite", Void.TYPE, 20).withParameter(prototype.getClass(), "message", new ModifierContributor.ForParameter[0]).withParameter(JsonGenerator.class, "gen", new ModifierContributor.ForParameter[0]).throwing(new Type[]{IOException.class}).intercept((Implementation)new DoWrite(prototype, includingDefaultValueFields, fieldsToAlwaysOutput, printingEnumsAsInts, sortingMapKeys));
        try {
            marshaller = (TypeSpecificMarshaller)buddy.make().load(TypeSpecificMarshaller.class.getClassLoader()).getLoaded().getConstructor(prototype.getClass()).newInstance(prototype);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Could not generate marshaller, this is generally a bug in this library. Please file a report at https://github.com/curioswitch/curiostack with this stack trace and an example proto to reproduce.", e);
        }
        alreadyBuiltMarshallers.put(descriptor, marshaller);
        for (Message nestedPrototype : nestedMessagePrototypes) {
            TypeSpecificMarshaller.buildOrFindMarshaller(nestedPrototype, includingDefaultValueFields, fieldsToAlwaysOutput, preservingProtoFieldNames, ignoringUnknownFields, printingEnumsAsInts, sortingMapKeys, alreadyBuiltMarshallers);
        }
    }
}

