/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.util.LicenseResolver;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.logging.Logger;

class MavenHelper {
    private Logger logger;
    private CycloneDxSchema.Version schemaVersion;

    public MavenHelper(Logger logger, CycloneDxSchema.Version schemaVersion) {
        this.logger = logger;
        this.schemaVersion = schemaVersion;
    }

    void getClosestMetadata(ResolvedArtifact artifact, MavenProject project, Component component) {
        MavenProject parentProject;
        this.extractMetadata(project, component);
        if (project.getParent() != null) {
            this.getClosestMetadata(artifact, project.getParent(), component);
        } else if (project.getModel().getParent() != null && (parentProject = this.retrieveParentProject(artifact, project)) != null) {
            this.getClosestMetadata(artifact, parentProject, component);
        }
    }

    private void extractMetadata(MavenProject project, Component component) {
        if (component.getPublisher() == null && project.getOrganization() != null) {
            component.setPublisher(project.getOrganization().getName());
        }
        if (component.getDescription() == null) {
            component.setDescription(project.getDescription());
        }
        if ((component.getLicenseChoice() == null || component.getLicenseChoice().getLicenses() == null || component.getLicenseChoice().getLicenses().isEmpty()) && project.getLicenses() != null) {
            component.setLicenseChoice(this.resolveMavenLicenses(project.getLicenses()));
        }
    }

    private LicenseChoice resolveMavenLicenses(List<License> projectLicenses) {
        LicenseChoice licenseChoice = new LicenseChoice();
        for (License artifactLicense : projectLicenses) {
            LicenseChoice resolvedByUrl;
            LicenseChoice resolvedByName;
            boolean resolved = false;
            if (artifactLicense.getName() != null && (resolvedByName = LicenseResolver.resolve((String)artifactLicense.getName())) != null) {
                if (resolvedByName.getLicenses() != null && !resolvedByName.getLicenses().isEmpty()) {
                    resolved = true;
                    licenseChoice.addLicense((org.cyclonedx.model.License)resolvedByName.getLicenses().get(0));
                } else if (resolvedByName.getExpression() != null && CycloneDxSchema.Version.VERSION_10 != this.schemaVersion) {
                    resolved = true;
                    licenseChoice.setExpression(resolvedByName.getExpression());
                }
            }
            if (artifactLicense.getUrl() != null && !resolved && (resolvedByUrl = LicenseResolver.resolve((String)artifactLicense.getUrl())) != null) {
                if (resolvedByUrl.getLicenses() != null && !resolvedByUrl.getLicenses().isEmpty()) {
                    resolved = true;
                    licenseChoice.addLicense((org.cyclonedx.model.License)resolvedByUrl.getLicenses().get(0));
                } else if (resolvedByUrl.getExpression() != null && CycloneDxSchema.Version.VERSION_10 != this.schemaVersion) {
                    resolved = true;
                    licenseChoice.setExpression(resolvedByUrl.getExpression());
                }
            }
            if (artifactLicense.getName() == null || resolved) continue;
            org.cyclonedx.model.License license = new org.cyclonedx.model.License();
            license.setName(artifactLicense.getName());
            licenseChoice.addLicense(license);
        }
        return licenseChoice;
    }

    private MavenProject retrieveParentProject(ResolvedArtifact artifact, MavenProject project) {
        if (artifact.getFile() == null || artifact.getFile().getParentFile() == null || !this.isDescribedArtifact(artifact)) {
            return null;
        }
        Model model = project.getModel();
        if (model.getParent() != null) {
            Parent parent = model.getParent();
            StringBuilder getout = new StringBuilder("../../../");
            ModuleVersionIdentifier mid = artifact.getModuleVersion().getId();
            int periods = mid.getGroup().length() - mid.getGroup().replace(".", "").length();
            for (int i = 0; i < periods; ++i) {
                getout.append("../");
            }
            File parentFile = new File(artifact.getFile().getParentFile(), getout + parent.getGroupId().replace(".", "/") + "/" + parent.getArtifactId() + "/" + parent.getVersion() + "/" + parent.getArtifactId() + "-" + parent.getVersion() + ".pom");
            if (parentFile.exists() && parentFile.isFile()) {
                try {
                    return this.readPom(parentFile.getCanonicalFile());
                }
                catch (Exception e) {
                    this.logger.error("An error occurred retrieving an artifacts parent pom", (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MavenProject extractPom(ResolvedArtifact artifact) {
        if (!this.isDescribedArtifact(artifact)) {
            return null;
        }
        if (artifact.getFile() == null) return null;
        try {
            JarFile jarFile = new JarFile(artifact.getFile());
            ModuleVersionIdentifier mid = artifact.getModuleVersion().getId();
            JarEntry entry = jarFile.getJarEntry("META-INF/maven/" + mid.getGroup() + "/" + mid.getName() + "/pom.xml");
            if (entry == null) return null;
            try (InputStream input = jarFile.getInputStream(entry);){
                MavenProject mavenProject = this.readPom(input);
                return mavenProject;
            }
        }
        catch (IOException e) {
            this.logger.error("An error occurred attempting to extract POM from artifact", (Throwable)e);
        }
        return null;
    }

    MavenProject readPom(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            MavenProject mavenProject = this.readPom(in);
            return mavenProject;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MavenProject readPom(InputStream in) {
        try {
            MavenXpp3Reader mavenreader = new MavenXpp3Reader();
            try (InputStreamReader reader = new InputStreamReader(in);){
                Model model = mavenreader.read((Reader)reader);
                MavenProject mavenProject = new MavenProject(model);
                return mavenProject;
            }
        }
        catch (IOException | XmlPullParserException e) {
            this.logger.error("An error occurred attempting to read POM", e);
            return null;
        }
    }

    private boolean isDescribedArtifact(Artifact artifact) {
        return artifact.getType().equalsIgnoreCase("jar");
    }

    boolean isDescribedArtifact(ResolvedArtifact artifact) {
        return artifact.getType().equalsIgnoreCase("jar");
    }
}

