/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.cyclonedx.BomGenerator;
import org.cyclonedx.BomGeneratorFactory;
import org.cyclonedx.BomParser;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.gradle.MavenHelper;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.util.BomUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.tasks.TaskAction;

public class CycloneDxTask
extends DefaultTask {
    private static final String MESSAGE_RESOLVING_DEPS = "CycloneDX: Resolving Dependencies";
    private static final String MESSAGE_CREATING_BOM = "CycloneDX: Creating BOM";
    private static final String MESSAGE_CALCULATING_HASHES = "CycloneDX: Calculating Hashes";
    private static final String MESSAGE_WRITING_BOM = "CycloneDX: Writing BOM";
    private static final String MESSAGE_VALIDATING_BOM = "CycloneDX: Validating BOM";
    private static final String MESSAGE_VALIDATION_FAILURE = "The BOM does not conform to the CycloneDX BOM standard as defined by the XSD";
    private static final String MESSAGE_SKIPPING = "Skipping CycloneDX";
    private File buildDir;
    private MavenHelper mavenHelper;
    private CycloneDxSchema.Version schemaVersion = CycloneDxSchema.Version.VERSION_11;
    private boolean includeBomSerialNumber;
    private boolean skip;
    private final List<String> skipConfigs = new ArrayList<String>();

    public List<String> getSkipConfigs() {
        return this.skipConfigs;
    }

    public void setSkipConfigs(Collection<String> skipConfigs) {
        this.skipConfigs.clear();
        this.skipConfigs.addAll(skipConfigs);
    }

    public void setBuildDir(File buildDir) {
        this.buildDir = buildDir;
    }

    private void initialize() {
        this.schemaVersion = this.schemaVersion();
        this.mavenHelper = new MavenHelper(this.getLogger(), this.schemaVersion);
        this.includeBomSerialNumber = this.schemaVersion == CycloneDxSchema.Version.VERSION_10 ? false : this.getBooleanParameter("cyclonedx.includeBomSerialNumber", true);
        this.skip = this.getBooleanParameter("cyclonedx.skip", false);
    }

    @TaskAction
    public void createBom() {
        this.initialize();
        if (this.skip) {
            this.getLogger().info(MESSAGE_SKIPPING);
            return;
        }
        this.logParameters();
        this.getLogger().info(MESSAGE_RESOLVING_DEPS);
        Set builtDependencies = this.getProject().getRootProject().getSubprojects().stream().map(p -> p.getGroup() + ":" + p.getName() + ":" + p.getVersion()).collect(Collectors.toSet());
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        for (Project p2 : this.getProject().getAllprojects()) {
            for (Configuration configuration : p2.getConfigurations()) {
                ResolvedConfiguration resolvedConfiguration;
                if (this.shouldSkipConfiguration(configuration) || !this.canBeResolved(configuration) || (resolvedConfiguration = configuration.getResolvedConfiguration()) == null) continue;
                ArrayList<String> depsFromConfig = new ArrayList<String>();
                for (ResolvedArtifact artifact : resolvedConfiguration.getResolvedArtifacts()) {
                    String dependencyName = this.getDependencyName(artifact);
                    if (builtDependencies.stream().anyMatch(c -> c.equals(dependencyName))) continue;
                    depsFromConfig.add(dependencyName);
                    Component component = this.convertArtifact(artifact);
                    this.augmentComponentMetadata(component, dependencyName);
                    components.add(component);
                }
                Collections.sort(depsFromConfig);
                this.getLogger().info("BOM inclusion for configuration {} : {}", (Object)configuration.getName(), depsFromConfig);
            }
        }
        this.writeBom(components);
    }

    private boolean canBeResolved(Configuration configuration) {
        try {
            Method method = Configuration.class.getMethod("isCanBeResolved", new Class[0]);
            try {
                return (Boolean)method.invoke((Object)configuration, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.getLogger().warn("Failed to check resolvability of configuration {} -- assuming resolvability. Exception was: {}", (Object)configuration.getName(), (Object)e);
                return true;
            }
        }
        catch (NoSuchMethodException e) {
            return true;
        }
    }

    private String getDependencyName(ResolvedArtifact artifact) {
        ModuleVersionIdentifier m = artifact.getModuleVersion().getId();
        return m.getGroup() + ":" + m.getName() + ":" + m.getVersion();
    }

    private void augmentComponentMetadata(Component component, String dependencyName) {
        Dependency pomDep = this.getProject().getDependencies().create((Object)(dependencyName + "@pom"));
        Configuration pomCfg = this.getProject().getConfigurations().detachedConfiguration(new Dependency[]{pomDep});
        MavenProject project = null;
        try {
            File pomFile = pomCfg.resolve().stream().findFirst().orElse(null);
            project = this.mavenHelper.readPom(pomFile);
        }
        catch (IOException err) {
            this.getLogger().error("Unable to resolve POM for " + component + ": " + err);
        }
        catch (ResolveException err) {
            this.getLogger().error("Unable to resolve POM for " + component + ": " + (Object)((Object)err));
        }
        if (project != null) {
            if (project.getOrganization() != null) {
                component.setPublisher(project.getOrganization().getName());
            }
            component.setDescription(project.getDescription());
            if (project.getLicenses() != null) {
                ArrayList<org.cyclonedx.model.License> licenses = new ArrayList<org.cyclonedx.model.License>();
                for (License artifactLicense : project.getLicenses()) {
                    org.cyclonedx.model.License license = new org.cyclonedx.model.License();
                    if (artifactLicense.getName() != null) {
                        license.setName(artifactLicense.getName());
                        licenses.add(license);
                        continue;
                    }
                    if (artifactLicense.getUrl() == null) continue;
                    license.setName(artifactLicense.getUrl());
                    licenses.add(license);
                }
                if (licenses.size() > 0) {
                    // empty if block
                }
            }
        }
    }

    private Component convertArtifact(ResolvedArtifact artifact) {
        MavenProject project;
        Component component = new Component();
        component.setGroup(artifact.getModuleVersion().getId().getGroup());
        component.setName(artifact.getModuleVersion().getId().getName());
        component.setVersion(artifact.getModuleVersion().getId().getVersion());
        component.setType(Component.Type.LIBRARY);
        try {
            this.getLogger().debug(MESSAGE_CALCULATING_HASHES);
            component.setHashes(BomUtils.calculateHashes((File)artifact.getFile()));
        }
        catch (IOException e) {
            this.getLogger().error("Error encountered calculating hashes", (Throwable)e);
        }
        if (CycloneDxSchema.Version.VERSION_10 == this.schemaVersion) {
            component.setModified(false);
        }
        try {
            TreeMap<String, String> qualifiers = null;
            if (artifact.getType() != null || artifact.getClassifier() != null) {
                qualifiers = new TreeMap<String, String>();
                if (artifact.getType() != null) {
                    qualifiers.put("type", artifact.getType());
                }
                if (artifact.getClassifier() != null) {
                    qualifiers.put("classifier", artifact.getClassifier());
                }
            }
            PackageURL purl = new PackageURL("maven", component.getGroup(), component.getName(), component.getVersion(), qualifiers, null);
            component.setPurl(purl.canonicalize());
        }
        catch (MalformedPackageURLException e) {
            this.getLogger().warn("An unexpected issue occurred attempting to create a PackageURL for " + component.getName(), (Throwable)e);
        }
        if (this.mavenHelper.isDescribedArtifact(artifact) && (project = this.mavenHelper.extractPom(artifact)) != null) {
            this.mavenHelper.getClosestMetadata(artifact, project, component);
        }
        return component;
    }

    private boolean shouldSkipConfiguration(Configuration configuration) {
        return this.skipConfigs.contains(configuration.getName());
    }

    protected void writeBom(Set<Component> components) throws GradleException {
        try {
            this.getLogger().info(MESSAGE_CREATING_BOM);
            Bom bom = new Bom();
            if (CycloneDxSchema.Version.VERSION_10 != this.schemaVersion && this.includeBomSerialNumber) {
                bom.setSerialNumber("urn:uuid:" + UUID.randomUUID().toString());
            }
            bom.setComponents(new ArrayList<Component>(components));
            BomGenerator bomGenerator = BomGeneratorFactory.create((CycloneDxSchema.Version)this.schemaVersion, (Bom)bom);
            bomGenerator.generate();
            String bomString = bomGenerator.toXmlString();
            File bomFile = new File(this.buildDir, "reports/bom.xml");
            this.getLogger().info(MESSAGE_WRITING_BOM);
            FileUtils.write((File)bomFile, (CharSequence)bomString, (Charset)Charset.forName("UTF-8"), (boolean)false);
            this.getLogger().info(MESSAGE_VALIDATING_BOM);
            BomParser bomParser = new BomParser();
            if (!bomParser.isValid(bomFile)) {
                throw new GradleException(MESSAGE_VALIDATION_FAILURE);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            throw new GradleException("An error occurred executing " + ((Object)((Object)this)).getClass().getName(), (Throwable)e);
        }
    }

    private boolean getBooleanParameter(String parameter, boolean defaultValue) {
        Object o;
        Project project = super.getProject();
        if (project.hasProperty(parameter) && (o = project.getProperties().get(parameter)) instanceof String) {
            return Boolean.valueOf((String)o);
        }
        return defaultValue;
    }

    private CycloneDxSchema.Version schemaVersion() {
        String s;
        Project project = super.getProject();
        if (project.hasProperty("cyclonedx.schemaVersion") && "1.0".equals(s = (String)project.getProperties().get("cyclonedx.schemaVersion"))) {
            return CycloneDxSchema.Version.VERSION_10;
        }
        return CycloneDxSchema.Version.VERSION_11;
    }

    protected void logParameters() {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("CycloneDX: Parameters");
            this.getLogger().info("------------------------------------------------------------------------");
            this.getLogger().info("schemaVersion          : " + this.schemaVersion.name());
            this.getLogger().info("includeBomSerialNumber : " + this.includeBomSerialNumber);
            this.getLogger().info("------------------------------------------------------------------------");
        }
    }
}

