/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.project.MavenProject;
import org.cyclonedx.BomGeneratorFactory;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.generators.json.BomJsonGenerator;
import org.cyclonedx.generators.xml.BomXmlGenerator;
import org.cyclonedx.gradle.MavenHelper;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.Tool;
import org.cyclonedx.parsers.JsonParser;
import org.cyclonedx.parsers.XmlParser;
import org.cyclonedx.util.BomUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

public class CycloneDxTask
extends DefaultTask {
    private static final String MESSAGE_RESOLVING_DEPS = "CycloneDX: Resolving Dependencies";
    private static final String MESSAGE_CREATING_BOM = "CycloneDX: Creating BOM";
    private static final String MESSAGE_CALCULATING_HASHES = "CycloneDX: Calculating Hashes";
    private static final String MESSAGE_WRITING_BOM_XML = "CycloneDX: Writing BOM XML";
    private static final String MESSAGE_WRITING_BOM_JSON = "CycloneDX: Writing BOM JSON";
    private static final String MESSAGE_VALIDATING_BOM = "CycloneDX: Validating BOM";
    private static final String MESSAGE_VALIDATION_FAILURE = "The BOM does not conform to the CycloneDX BOM standard";
    private static final String MESSAGE_SKIPPING = "Skipping CycloneDX";
    private File buildDir;
    private MavenHelper mavenHelper;
    private CycloneDxSchema.Version schemaVersion = CycloneDxSchema.Version.VERSION_12;
    private boolean includeBomSerialNumber;
    private boolean skip;
    private String projectType;
    private final List<String> skipConfigs = new ArrayList<String>();
    private final Map<File, List<Hash>> artifactHashes = Collections.synchronizedMap(new HashMap());
    private final Map<String, MavenProject> resolvedMavenProjects = Collections.synchronizedMap(new HashMap());

    @Input
    public List<String> getSkipConfigs() {
        return this.skipConfigs;
    }

    public void setSkipConfigs(Collection<String> skipConfigs) {
        this.skipConfigs.clear();
        this.skipConfigs.addAll(skipConfigs);
    }

    public void setBuildDir(File buildDir) {
        this.buildDir = buildDir;
    }

    private void initialize() {
        this.schemaVersion = this.schemaVersion();
        this.mavenHelper = new MavenHelper(this.getLogger(), this.schemaVersion);
        this.includeBomSerialNumber = this.schemaVersion == CycloneDxSchema.Version.VERSION_10 ? false : this.getBooleanParameter("cyclonedx.includeBomSerialNumber", true);
        this.skip = this.getBooleanParameter("cyclonedx.skip", false);
        this.projectType = this.getStringParameter("projectType", "library");
    }

    @TaskAction
    public void createBom() {
        this.initialize();
        if (this.skip) {
            this.getLogger().info(MESSAGE_SKIPPING);
            return;
        }
        this.logParameters();
        this.getLogger().info(MESSAGE_RESOLVING_DEPS);
        Set builtDependencies = this.getProject().getRootProject().getSubprojects().stream().map(p -> p.getGroup() + ":" + p.getName() + ":" + p.getVersion()).collect(Collectors.toSet());
        Metadata metadata = this.createMetadata();
        Set<Component> components = this.getProject().getAllprojects().stream().flatMap(p -> p.getConfigurations().stream()).filter(configuration -> !this.shouldSkipConfiguration((Configuration)configuration) && this.canBeResolved((Configuration)configuration)).flatMap(configuration -> {
            Set componentsFromConfig = Collections.synchronizedSet(new LinkedHashSet());
            ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
            if (resolvedConfiguration != null) {
                List depsFromConfig = Collections.synchronizedList(new ArrayList());
                resolvedConfiguration.getResolvedArtifacts().stream().forEach(artifact -> {
                    String dependencyName = this.getDependencyName((ResolvedArtifact)artifact);
                    if (builtDependencies.contains(dependencyName)) {
                        return;
                    }
                    depsFromConfig.add(dependencyName);
                    Component component = this.convertArtifact((ResolvedArtifact)artifact);
                    this.augmentComponentMetadata(component, dependencyName);
                    componentsFromConfig.add(component);
                });
                Collections.sort(depsFromConfig);
                this.getLogger().info("BOM inclusion for configuration {} : {}", (Object)configuration.getName(), depsFromConfig);
            }
            return componentsFromConfig.stream();
        }).collect(Collectors.toSet());
        this.writeBom(metadata, components);
    }

    private boolean canBeResolved(Configuration configuration) {
        try {
            Method method = Configuration.class.getMethod("isCanBeResolved", new Class[0]);
            try {
                return (Boolean)method.invoke((Object)configuration, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.getLogger().warn("Failed to check resolvability of configuration {} -- assuming resolvability. Exception was: {}", (Object)configuration.getName(), (Object)e);
                return true;
            }
        }
        catch (NoSuchMethodException e) {
            return true;
        }
    }

    private String getDependencyName(ResolvedArtifact artifact) {
        ModuleVersionIdentifier m = artifact.getModuleVersion().getId();
        return m.getGroup() + ":" + m.getName() + ":" + m.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenProject getResolvedMavenProject(String dependencyName) {
        Map<String, MavenProject> map = this.resolvedMavenProjects;
        synchronized (map) {
            if (this.resolvedMavenProjects.containsKey(dependencyName)) {
                return this.resolvedMavenProjects.get(dependencyName);
            }
        }
        Dependency pomDep = this.getProject().getDependencies().create((Object)(dependencyName + "@pom"));
        Configuration pomCfg = this.getProject().getConfigurations().detachedConfiguration(new Dependency[]{pomDep});
        try {
            File pomFile = pomCfg.resolve().stream().findFirst().orElse(null);
            if (pomFile != null) {
                MavenProject project = this.mavenHelper.readPom(pomFile);
                this.resolvedMavenProjects.put(dependencyName, project);
                return project;
            }
        }
        catch (Exception err) {
            this.getLogger().error("Unable to resolve POM for " + dependencyName + ": " + err);
        }
        this.resolvedMavenProjects.put(dependencyName, null);
        return null;
    }

    private void augmentComponentMetadata(Component component, String dependencyName) {
        MavenProject project = this.getResolvedMavenProject(dependencyName);
        if (project != null) {
            if (project.getOrganization() != null) {
                component.setPublisher(project.getOrganization().getName());
            }
            component.setDescription(project.getDescription());
            component.setLicenseChoice(this.mavenHelper.resolveMavenLicenses(project.getLicenses()));
        }
    }

    protected Metadata createMetadata() {
        Project project = this.getProject().getRootProject();
        Properties properties = this.readPluginProperties();
        Metadata metadata = new Metadata();
        Tool tool = new Tool();
        tool.setVendor(properties.getProperty("vendor"));
        tool.setName(properties.getProperty("name"));
        tool.setVersion(properties.getProperty("version"));
        metadata.addTool(tool);
        Component component = new Component();
        component.setGroup(StringUtils.trimToNull((String)project.getGroup().toString()) != null ? project.getGroup().toString() : null);
        component.setName(project.getName());
        component.setVersion(project.getVersion().toString());
        component.setType(this.resolveProjectType());
        component.setPurl(this.generatePackageUrl(project.getGroup().toString(), project.getName(), project.getVersion().toString(), null, null));
        component.setBomRef(component.getPurl());
        metadata.setComponent(component);
        return metadata;
    }

    private Properties readPluginProperties() {
        Properties props = new Properties();
        try {
            props.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("plugin.properties"));
        }
        catch (IOException | NullPointerException e) {
            this.getLogger().warn("Unable to load plugin.properties", (Throwable)e);
        }
        return props;
    }

    private Component.Type resolveProjectType() {
        for (Component.Type type : Component.Type.values()) {
            if (!type.getTypeName().equalsIgnoreCase(this.projectType)) continue;
            return type;
        }
        this.getLogger().warn("Invalid project type. Defaulting to 'library'");
        this.getLogger().warn("Valid types are:");
        for (Component.Type type : Component.Type.values()) {
            this.getLogger().warn("  " + type.getTypeName());
        }
        return Component.Type.LIBRARY;
    }

    private Component convertArtifact(ResolvedArtifact artifact) {
        MavenProject project;
        Component component = new Component();
        component.setGroup(artifact.getModuleVersion().getId().getGroup());
        component.setName(artifact.getModuleVersion().getId().getName());
        component.setVersion(artifact.getModuleVersion().getId().getVersion());
        component.setType(Component.Type.LIBRARY);
        this.getLogger().debug(MESSAGE_CALCULATING_HASHES);
        List hashes = this.artifactHashes.computeIfAbsent(artifact.getFile(), f -> {
            try {
                return BomUtils.calculateHashes((File)f, (CycloneDxSchema.Version)this.schemaVersion);
            }
            catch (IOException e) {
                this.getLogger().error("Error encountered calculating hashes", (Throwable)e);
                return Collections.emptyList();
            }
        });
        component.setHashes(hashes);
        if (this.schemaVersion().getVersion() >= 1.1) {
            component.setModified(this.mavenHelper.isModified(artifact));
        }
        component.setPurl(this.generatePackageUrl(artifact));
        if (this.mavenHelper.isDescribedArtifact(artifact) && (project = this.mavenHelper.extractPom(artifact)) != null) {
            this.mavenHelper.getClosestMetadata(artifact, project, component);
        }
        return component;
    }

    private boolean shouldSkipConfiguration(Configuration configuration) {
        return this.skipConfigs.contains(configuration.getName());
    }

    private String generatePackageUrl(ResolvedArtifact artifact) {
        TreeMap<String, String> qualifiers = null;
        if (artifact.getType() != null || artifact.getClassifier() != null) {
            qualifiers = new TreeMap<String, String>();
            if (artifact.getType() != null) {
                qualifiers.put("type", artifact.getType());
            }
            if (artifact.getClassifier() != null) {
                qualifiers.put("classifier", artifact.getClassifier());
            }
        }
        return this.generatePackageUrl(artifact.getModuleVersion().getId().getGroup(), artifact.getModuleVersion().getId().getName(), artifact.getModuleVersion().getId().getVersion(), qualifiers, null);
    }

    private String generatePackageUrl(String groupId, String artifactId, String version, TreeMap<String, String> qualifiers, String subpath) {
        try {
            return new PackageURL("maven", groupId, artifactId, version, qualifiers, subpath).canonicalize();
        }
        catch (MalformedPackageURLException e) {
            this.getLogger().warn("An unexpected issue occurred attempting to create a PackageURL for " + groupId + ":" + artifactId + ":" + version, (Throwable)e);
            return null;
        }
    }

    protected void writeBom(Metadata metadata, Set<Component> components) throws GradleException {
        try {
            this.getLogger().info(MESSAGE_CREATING_BOM);
            Bom bom = new Bom();
            if (CycloneDxSchema.Version.VERSION_10 != this.schemaVersion && this.includeBomSerialNumber) {
                bom.setSerialNumber("urn:uuid:" + UUID.randomUUID().toString());
            }
            bom.setMetadata(metadata);
            bom.setComponents(new ArrayList<Component>(components));
            this.writeXMLBom(this.schemaVersion, bom);
            if (this.schemaVersion().getVersion() >= 1.2) {
                this.writeJSONBom(this.schemaVersion, bom);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            throw new GradleException("An error occurred executing " + ((Object)((Object)this)).getClass().getName(), (Throwable)e);
        }
    }

    private void writeXMLBom(CycloneDxSchema.Version schemaVersion, Bom bom) throws ParserConfigurationException, TransformerException, IOException {
        BomXmlGenerator bomGenerator = BomGeneratorFactory.createXml((CycloneDxSchema.Version)schemaVersion, (Bom)bom);
        bomGenerator.generate();
        String bomString = bomGenerator.toXmlString();
        File bomFile = new File(this.buildDir, "reports/bom.xml");
        this.getLogger().info(MESSAGE_WRITING_BOM_XML);
        FileUtils.write((File)bomFile, (CharSequence)bomString, (Charset)StandardCharsets.UTF_8, (boolean)false);
        this.getLogger().info(MESSAGE_VALIDATING_BOM);
        XmlParser bomParser = new XmlParser();
        try {
            if (!bomParser.isValid(bomFile)) {
                throw new GradleException(MESSAGE_VALIDATION_FAILURE);
            }
        }
        catch (Exception e) {
            throw new GradleException(MESSAGE_VALIDATION_FAILURE, (Throwable)e);
        }
    }

    private void writeJSONBom(CycloneDxSchema.Version schemaVersion, Bom bom) throws IOException {
        BomJsonGenerator bomGenerator = BomGeneratorFactory.createJson((CycloneDxSchema.Version)schemaVersion, (Bom)bom);
        bomGenerator.generate();
        String bomString = bomGenerator.toJsonString();
        File bomFile = new File(this.buildDir, "reports/bom.json");
        this.getLogger().info(MESSAGE_WRITING_BOM_JSON);
        FileUtils.write((File)bomFile, (CharSequence)bomString, (Charset)StandardCharsets.UTF_8, (boolean)false);
        this.getLogger().info(MESSAGE_VALIDATING_BOM);
        JsonParser bomParser = new JsonParser();
        try {
            if (!bomParser.isValid(bomFile)) {
                throw new GradleException(MESSAGE_VALIDATION_FAILURE);
            }
        }
        catch (Exception e) {
            throw new GradleException(MESSAGE_VALIDATION_FAILURE, (Throwable)e);
        }
    }

    private boolean getBooleanParameter(String parameter, boolean defaultValue) {
        Object o;
        Project project = super.getProject();
        if (project.hasProperty(parameter) && (o = project.getProperties().get(parameter)) instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        return defaultValue;
    }

    private String getStringParameter(String parameter, String defaultValue) {
        Object o;
        Project project = super.getProject();
        if (project.hasProperty(parameter) && (o = project.getProperties().get(parameter)) instanceof String) {
            return (String)o;
        }
        return defaultValue;
    }

    private CycloneDxSchema.Version schemaVersion() {
        Project project = super.getProject();
        String version = project.hasProperty("cyclonedx.schemaVersion") ? (String)project.getProperties().get("cyclonedx.schemaVersion") : this.getStringParameter("schemaVersion", CycloneDxSchema.Version.VERSION_12.getVersionString());
        if ("1.0".equals(version)) {
            return CycloneDxSchema.Version.VERSION_10;
        }
        if ("1.1".equals(version)) {
            return CycloneDxSchema.Version.VERSION_11;
        }
        return CycloneDxSchema.Version.VERSION_12;
    }

    protected void logParameters() {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("CycloneDX: Parameters");
            this.getLogger().info("------------------------------------------------------------------------");
            this.getLogger().info("schemaVersion          : " + this.schemaVersion.name());
            this.getLogger().info("includeBomSerialNumber : " + this.includeBomSerialNumber);
            this.getLogger().info("------------------------------------------------------------------------");
        }
    }
}

