/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.gradle;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.util.LicenseResolver;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.logging.Logger;

class MavenHelper {
    private Logger logger;
    private CycloneDxSchema.Version schemaVersion;

    public MavenHelper(Logger logger, CycloneDxSchema.Version schemaVersion) {
        this.logger = logger;
        this.schemaVersion = schemaVersion;
    }

    void getClosestMetadata(ResolvedArtifact artifact, MavenProject project, Component component) {
        MavenProject parentProject;
        this.extractMetadata(project, component);
        if (project.getParent() != null) {
            this.getClosestMetadata(artifact, project.getParent(), component);
        } else if (project.getModel().getParent() != null && (parentProject = this.retrieveParentProject(artifact, project)) != null) {
            this.getClosestMetadata(artifact, parentProject, component);
        }
    }

    private void extractMetadata(MavenProject project, Component component) {
        if (component.getPublisher() == null && project.getOrganization() != null) {
            component.setPublisher(project.getOrganization().getName());
        }
        if (component.getDescription() == null) {
            component.setDescription(project.getDescription());
        }
        if ((component.getLicenseChoice() == null || component.getLicenseChoice().getLicenses() == null || component.getLicenseChoice().getLicenses().isEmpty()) && project.getLicenses() != null) {
            component.setLicenseChoice(this.resolveMavenLicenses(project.getLicenses()));
        }
        if (CycloneDxSchema.Version.VERSION_10 != this.schemaVersion) {
            if (project.getOrganization() != null && project.getOrganization().getUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.WEBSITE)) {
                this.addExternalReference(ExternalReference.Type.WEBSITE, project.getOrganization().getUrl(), component);
            }
            if (project.getCiManagement() != null && project.getCiManagement().getUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.BUILD_SYSTEM)) {
                this.addExternalReference(ExternalReference.Type.BUILD_SYSTEM, project.getCiManagement().getUrl(), component);
            }
            if (project.getDistributionManagement() != null && project.getDistributionManagement().getDownloadUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.DISTRIBUTION)) {
                this.addExternalReference(ExternalReference.Type.DISTRIBUTION, project.getDistributionManagement().getDownloadUrl(), component);
            }
            if (project.getDistributionManagement() != null && project.getDistributionManagement().getRepository() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.DISTRIBUTION)) {
                this.addExternalReference(ExternalReference.Type.DISTRIBUTION, project.getDistributionManagement().getRepository().getUrl(), component);
            }
            if (project.getIssueManagement() != null && project.getIssueManagement().getUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.ISSUE_TRACKER)) {
                this.addExternalReference(ExternalReference.Type.ISSUE_TRACKER, project.getIssueManagement().getUrl(), component);
            }
            if (project.getMailingLists() != null && project.getMailingLists().size() > 0) {
                for (MailingList list : project.getMailingLists()) {
                    if (list.getArchive() != null) {
                        if (this.doesComponentHaveExternalReference(component, ExternalReference.Type.MAILING_LIST)) continue;
                        this.addExternalReference(ExternalReference.Type.MAILING_LIST, list.getArchive(), component);
                        continue;
                    }
                    if (list.getSubscribe() == null || this.doesComponentHaveExternalReference(component, ExternalReference.Type.MAILING_LIST)) continue;
                    this.addExternalReference(ExternalReference.Type.MAILING_LIST, list.getSubscribe(), component);
                }
            }
            if (project.getScm() != null && project.getScm().getUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.VCS)) {
                this.addExternalReference(ExternalReference.Type.VCS, project.getScm().getUrl(), component);
            }
        }
    }

    private void addExternalReference(ExternalReference.Type referenceType, String url, Component component) {
        ExternalReference ref = new ExternalReference();
        ref.setType(referenceType);
        ref.setUrl(url);
        try {
            new URL(ref.getUrl());
            component.addExternalReference(ref);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private boolean doesComponentHaveExternalReference(Component component, ExternalReference.Type type) {
        if (component.getExternalReferences() != null && !component.getExternalReferences().isEmpty()) {
            for (ExternalReference ref : component.getExternalReferences()) {
                if (type != ref.getType()) continue;
                return true;
            }
        }
        return false;
    }

    LicenseChoice resolveMavenLicenses(List<License> projectLicenses) {
        boolean includeLicenseText = true;
        LicenseChoice licenseChoice = new LicenseChoice();
        for (License artifactLicense : projectLicenses) {
            LicenseChoice resolvedByUrl;
            LicenseChoice resolvedByName;
            boolean resolved = false;
            if (artifactLicense.getName() != null && (resolvedByName = LicenseResolver.resolve((String)artifactLicense.getName(), (boolean)true)) != null) {
                if (resolvedByName.getLicenses() != null && !resolvedByName.getLicenses().isEmpty()) {
                    resolved = true;
                    licenseChoice.addLicense((org.cyclonedx.model.License)resolvedByName.getLicenses().get(0));
                } else if (resolvedByName.getExpression() != null && CycloneDxSchema.Version.VERSION_10 != this.schemaVersion) {
                    resolved = true;
                    licenseChoice.setExpression(resolvedByName.getExpression());
                }
            }
            if (artifactLicense.getUrl() != null && !resolved && (resolvedByUrl = LicenseResolver.resolve((String)artifactLicense.getUrl(), (boolean)true)) != null) {
                if (resolvedByUrl.getLicenses() != null && !resolvedByUrl.getLicenses().isEmpty()) {
                    resolved = true;
                    licenseChoice.addLicense((org.cyclonedx.model.License)resolvedByUrl.getLicenses().get(0));
                } else if (resolvedByUrl.getExpression() != null && CycloneDxSchema.Version.VERSION_10 != this.schemaVersion) {
                    resolved = true;
                    licenseChoice.setExpression(resolvedByUrl.getExpression());
                }
            }
            if (artifactLicense.getName() == null || resolved) continue;
            org.cyclonedx.model.License license = new org.cyclonedx.model.License();
            license.setName(artifactLicense.getName().trim());
            if (StringUtils.isNotBlank((CharSequence)artifactLicense.getUrl())) {
                try {
                    new URL(artifactLicense.getUrl());
                    license.setUrl(artifactLicense.getUrl().trim());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            licenseChoice.addLicense(license);
        }
        return licenseChoice;
    }

    private MavenProject retrieveParentProject(ResolvedArtifact artifact, MavenProject project) {
        if (artifact.getFile() == null || artifact.getFile().getParentFile() == null || !this.isDescribedArtifact(artifact)) {
            return null;
        }
        Model model = project.getModel();
        if (model.getParent() != null) {
            Parent parent = model.getParent();
            StringBuilder getout = new StringBuilder("../../../");
            ModuleVersionIdentifier mid = artifact.getModuleVersion().getId();
            int periods = mid.getGroup().length() - mid.getGroup().replace(".", "").length();
            for (int i = 0; i < periods; ++i) {
                getout.append("../");
            }
            File parentFile = new File(artifact.getFile().getParentFile(), getout + parent.getGroupId().replace(".", "/") + "/" + parent.getArtifactId() + "/" + parent.getVersion() + "/" + parent.getArtifactId() + "-" + parent.getVersion() + ".pom");
            if (parentFile.exists() && parentFile.isFile()) {
                try {
                    return this.readPom(parentFile.getCanonicalFile());
                }
                catch (Exception e) {
                    this.logger.error("An error occurred retrieving an artifacts parent pom", (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MavenProject extractPom(ResolvedArtifact artifact) {
        if (!this.isDescribedArtifact(artifact)) {
            return null;
        }
        if (artifact.getFile() == null) return null;
        try {
            JarFile jarFile = new JarFile(artifact.getFile());
            ModuleVersionIdentifier mid = artifact.getModuleVersion().getId();
            JarEntry entry = jarFile.getJarEntry("META-INF/maven/" + mid.getGroup() + "/" + mid.getName() + "/pom.xml");
            if (entry == null) return null;
            try (InputStream input = jarFile.getInputStream(entry);){
                MavenProject mavenProject = this.readPom(input);
                return mavenProject;
            }
        }
        catch (IOException e) {
            this.logger.error("An error occurred attempting to extract POM from artifact", (Throwable)e);
        }
        return null;
    }

    MavenProject readPom(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            MavenProject mavenProject = this.readPom(in);
            return mavenProject;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MavenProject readPom(InputStream in) {
        try {
            MavenXpp3Reader mavenreader = new MavenXpp3Reader();
            try (InputStreamReader reader = new InputStreamReader(in);){
                Model model = mavenreader.read((Reader)reader);
                MavenProject mavenProject = new MavenProject(model);
                return mavenProject;
            }
        }
        catch (IOException | XmlPullParserException e) {
            this.logger.error("An error occurred attempting to read POM", e);
            return null;
        }
    }

    boolean isDescribedArtifact(Artifact artifact) {
        return artifact.getType().equalsIgnoreCase("jar");
    }

    boolean isDescribedArtifact(ResolvedArtifact artifact) {
        return artifact.getType().equalsIgnoreCase("jar");
    }

    boolean isModified(ResolvedArtifact artifact) {
        return false;
    }
}

