/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.cyclonedx.maven.model.Attribute;
import org.cyclonedx.maven.model.Component;
import org.cyclonedx.maven.model.Hash;
import org.cyclonedx.maven.model.License;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class BaseCycloneDxMojo
extends AbstractMojo {
    private static final String NS_BOM = "http://cyclonedx.org/schema/bom/1.0";
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="reactorProjects", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="includeCompileScope", defaultValue="true", required=false)
    private Boolean includeCompileScope;
    @Parameter(property="includeProvidedScope", defaultValue="true", required=false)
    private Boolean includeProvidedScope;
    @Parameter(property="includeRuntimeScope", defaultValue="true", required=false)
    private Boolean includeRuntimeScope;
    @Parameter(property="includeTestScope", defaultValue="false", required=false)
    private Boolean includeTestScope;
    @Parameter(property="includeSystemScope", defaultValue="true", required=false)
    private Boolean includeSystemScope;
    protected static final String MESSAGE_RESOLVING_DEPS = "CycloneDX: Resolving Dependencies";
    protected static final String MESSAGE_SKIPPING_POM = "CycloneDX: Skipping pom package";
    protected static final String MESSAGE_CREATING_BOM = "CycloneDX: Creating BOM";
    protected static final String MESSAGE_CALCULATING_HASHES = "CycloneDX: Calculating Hashes";
    protected static final String MESSAGE_WRITING_BOM = "CycloneDX: Writing BOM";
    protected static final String MESSAGE_VALIDATING_BOM = "CycloneDX: Validating BOM";
    protected static final String MESSAGE_VALIDATION_FAILURE = "The BOM does not conform to the CycloneDX BOM standard as defined by the XSD";

    public MavenSession getSession() {
        return this.session;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    protected Boolean getIncludeCompileScope() {
        return this.includeCompileScope;
    }

    protected Boolean getIncludeProvidedScope() {
        return this.includeProvidedScope;
    }

    protected Boolean getIncludeRuntimeScope() {
        return this.includeRuntimeScope;
    }

    protected Boolean getIncludeTestScope() {
        return this.includeTestScope;
    }

    protected Boolean getIncludeSystemScope() {
        return this.includeSystemScope;
    }

    protected boolean shouldInclude(Artifact artifact) {
        if (artifact.getScope() == null) {
            return false;
        }
        if (this.includeCompileScope.booleanValue() && "compile".equals(artifact.getScope())) {
            return true;
        }
        if (this.includeProvidedScope.booleanValue() && "provided".equals(artifact.getScope())) {
            return true;
        }
        if (this.includeRuntimeScope.booleanValue() && "runtime".equals(artifact.getScope())) {
            return true;
        }
        if (this.includeTestScope.booleanValue() && "test".equals(artifact.getScope())) {
            return true;
        }
        return this.includeSystemScope != false && "system".equals(artifact.getScope());
    }

    protected Component convert(Artifact artifact) {
        Component component = new Component();
        component.setGroup(artifact.getGroupId());
        component.setName(artifact.getArtifactId());
        component.setVersion(artifact.getVersion());
        component.setType("library");
        component.setHashes(this.calculateHashes(artifact.getFile()));
        component.setModified(this.isModified(artifact));
        try {
            TreeMap<String, String> qualifiers = null;
            if (artifact.getType() != null || artifact.getClassifier() != null) {
                qualifiers = new TreeMap<String, String>();
                if (artifact.getType() != null) {
                    qualifiers.put("type", artifact.getType());
                }
                if (artifact.getClassifier() != null) {
                    qualifiers.put("classifier", artifact.getClassifier());
                }
            }
            PackageURL purl = new PackageURL("maven", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), qualifiers, null);
            component.setPurl(purl.canonicalize());
        }
        catch (MalformedPackageURLException qualifiers) {
            // empty catch block
        }
        MavenProject project = this.extractPom(artifact);
        if (project != null) {
            if (project.getOrganization() != null) {
                component.setPublisher(project.getOrganization().getName());
            }
            component.setDescription(project.getDescription());
            if (project.getLicenses() != null) {
                ArrayList<License> licenses = new ArrayList<License>();
                for (org.apache.maven.model.License artifactLicense : project.getLicenses()) {
                    License license = new License();
                    if (artifactLicense.getName() != null) {
                        license.setName(artifactLicense.getName());
                        licenses.add(license);
                        continue;
                    }
                    if (artifactLicense.getUrl() == null) continue;
                    license.setName(artifactLicense.getUrl());
                    licenses.add(license);
                }
                if (licenses.size() > 0) {
                    component.setLicenses(licenses);
                }
            }
        }
        return component;
    }

    /*
     * Exception decompiling
     */
    private MavenProject extractPom(Artifact artifact) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void execute(Set<Component> components) throws MojoExecutionException {
        try {
            Document doc = this.createBom(components);
            String bomString = this.toString(doc);
            File bomFile = new File(this.project.getBasedir(), "target/bom.xml");
            this.getLog().info((CharSequence)MESSAGE_WRITING_BOM);
            FileUtils.write((File)bomFile, (CharSequence)bomString, (Charset)Charset.forName("UTF-8"), (boolean)false);
            boolean isValid = this.validateBom(bomFile);
            if (!isValid) {
                throw new MojoExecutionException(MESSAGE_VALIDATION_FAILURE);
            }
        }
        catch (IOException | ParserConfigurationException e) {
            throw new MojoExecutionException("An error occurred executing " + ((Object)((Object)this)).getClass().getName(), e);
        }
    }

    protected Document createBom(Set<Component> components) throws ParserConfigurationException {
        this.getLog().info((CharSequence)MESSAGE_CREATING_BOM);
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        doc.setXmlStandalone(true);
        Element bomNode = this.createRootElement(doc, "bom", null, new Attribute("xmlns", NS_BOM), new Attribute("version", "1"));
        Element componentsNode = this.createElement(doc, bomNode, "components");
        if (components != null) {
            for (Component component : components) {
                Element componentNode = this.createElement(doc, componentsNode, "component", null, new Attribute("type", component.getType()));
                this.createElement(doc, componentNode, "publisher", this.stripBreaks(component.getPublisher()));
                this.createElement(doc, componentNode, "group", this.stripBreaks(component.getGroup()));
                this.createElement(doc, componentNode, "name", this.stripBreaks(component.getName()));
                this.createElement(doc, componentNode, "version", this.stripBreaks(component.getVersion()));
                this.createElement(doc, componentNode, "description", this.stripBreaks(component.getDescription()));
                if (component.getHashes() != null) {
                    Element hashesNode = this.createElement(doc, componentNode, "hashes");
                    for (Hash hash : component.getHashes()) {
                        this.createElement(doc, hashesNode, "hash", hash.getValue(), new Attribute("alg", hash.getAlgorithm()));
                    }
                }
                if (component.getLicenses() != null) {
                    Element licensesNode = doc.createElementNS(NS_BOM, "licenses");
                    componentNode.appendChild(licensesNode);
                    for (License license : component.getLicenses()) {
                        Element licenseNode = doc.createElementNS(NS_BOM, "license");
                        if (license.getId() != null) {
                            Element licenseIdNode = doc.createElementNS(NS_BOM, "id");
                            licenseIdNode.appendChild(doc.createTextNode(license.getId()));
                            licenseNode.appendChild(licenseIdNode);
                        } else if (license.getName() != null) {
                            Element licenseNameNode = doc.createElementNS(NS_BOM, "name");
                            licenseNameNode.appendChild(doc.createTextNode(license.getName()));
                            licenseNode.appendChild(licenseNameNode);
                        }
                        licensesNode.appendChild(licenseNode);
                    }
                }
                this.createElement(doc, componentNode, "cpe", this.stripBreaks(component.getCpe()));
                this.createElement(doc, componentNode, "purl", this.stripBreaks(component.getPurl()));
                this.createElement(doc, componentNode, "modified", String.valueOf(component.isModified()));
            }
        }
        return doc;
    }

    protected Element createElement(Document doc, Node parent, String name) {
        Element node = doc.createElementNS(NS_BOM, name);
        parent.appendChild(node);
        return node;
    }

    protected Element createElement(Document doc, Node parent, String name, Object value) {
        return this.createElement(doc, parent, name, value, new Attribute[0]);
    }

    protected Element createElement(Document doc, Node parent, String name, Object value, Attribute ... attributes) {
        Element node = null;
        if (value != null || attributes.length > 0) {
            node = doc.createElementNS(NS_BOM, name);
            for (Attribute attribute : attributes) {
                node.setAttribute(attribute.getKey(), attribute.getValue());
            }
            if (value != null) {
                node.appendChild(doc.createTextNode(value.toString()));
            }
            parent.appendChild(node);
        }
        return node;
    }

    protected Element createRootElement(Document doc, String name, Object value, Attribute ... attributes) {
        Element node = null;
        if (value != null || attributes.length > 0) {
            node = doc.createElementNS(NS_BOM, name);
            node.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            node.setAttribute("xsi:schemaLocation", "http://cyclonedx.org/schema/bom/1.0 http://cyclonedx.org/schema/bom/1.0");
            for (Attribute attribute : attributes) {
                node.setAttribute(attribute.getKey(), attribute.getValue());
            }
            if (value != null) {
                node.appendChild(doc.createTextNode(value.toString()));
            }
            doc.appendChild(node);
        }
        return node;
    }

    protected String toString(Document doc) {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("doctype-public", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(domSource, result);
        }
        catch (TransformerException e) {
            this.getLog().error((CharSequence)e.getMessage());
        }
        String bomString = writer.toString();
        this.getLog().debug((CharSequence)bomString);
        return bomString;
    }

    private boolean isModified(Artifact artifact) {
        return false;
    }

    protected boolean validateBom(File file) {
        this.getLog().info((CharSequence)MESSAGE_VALIDATING_BOM);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] schemaFiles = new Source[]{new StreamSource(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("spdx.xsd")), new StreamSource(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("bom-1.0.xsd"))};
        StreamSource xmlFile = new StreamSource(file);
        try {
            Schema schema = schemaFactory.newSchema(schemaFiles);
            Validator validator = schema.newValidator();
            final LinkedList exceptions = new LinkedList();
            validator.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    exceptions.add(exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    exceptions.add(exception);
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    exceptions.add(exception);
                }
            });
            validator.validate(xmlFile);
            if (exceptions.size() > 0) {
                this.getLog().error((CharSequence)"One or more errors encountered while parsing bom");
                for (SAXParseException exception : exceptions) {
                    this.getLog().error((CharSequence)exception.getMessage());
                }
                return false;
            }
            return true;
        }
        catch (IOException | SAXException e) {
            this.getLog().error((CharSequence)("An error occurred validating the BOM: " + e.getMessage()));
            return false;
        }
    }

    protected void logParameters() {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"CycloneDX: Parameters");
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
            this.getLog().info((CharSequence)("includeCompileScope   : " + this.includeCompileScope));
            this.getLog().info((CharSequence)("includeProvidedScope  : " + this.includeProvidedScope));
            this.getLog().info((CharSequence)("includeRuntimeScope   : " + this.includeRuntimeScope));
            this.getLog().info((CharSequence)("includeTestScope      : " + this.includeTestScope));
            this.getLog().info((CharSequence)("includeSystemScope    : " + this.includeSystemScope));
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        }
    }

    private List<Hash> calculateHashes(File file) {
        if (file == null || !file.exists() || !file.canRead()) {
            return null;
        }
        this.getLog().debug((CharSequence)MESSAGE_CALCULATING_HASHES);
        this.getLog().debug((CharSequence)file.getAbsolutePath());
        ArrayList<Hash> hashes = new ArrayList<Hash>();
        try {
            FileInputStream fis = new FileInputStream(file);
            hashes.add(new Hash("MD5", DigestUtils.md5Hex((InputStream)fis)));
            fis.close();
            fis = new FileInputStream(file);
            hashes.add(new Hash("SHA-1", DigestUtils.sha1Hex((InputStream)fis)));
            fis.close();
            fis = new FileInputStream(file);
            hashes.add(new Hash("SHA-256", DigestUtils.sha256Hex((InputStream)fis)));
            fis.close();
            fis = new FileInputStream(file);
            hashes.add(new Hash("SHA-384", DigestUtils.sha384Hex((InputStream)fis)));
            fis.close();
            fis = new FileInputStream(file);
            hashes.add(new Hash("SHA-512", DigestUtils.sha512Hex((InputStream)fis)));
            fis.close();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage());
        }
        return hashes;
    }

    private String stripBreaks(String in) {
        if (in == null) {
            return null;
        }
        return in.trim().replace("\r\n", " ").replace("\n", " ").replace("\t", " ").replace("\r", " ").replaceAll(" +", " ");
    }
}

