/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.cyclonedx.model.Component;
import org.cyclonedx.util.BomUtils;
import org.w3c.dom.Document;

public abstract class BaseCycloneDxMojo
extends AbstractMojo {
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="reactorProjects", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="includeCompileScope", defaultValue="true", required=false)
    private Boolean includeCompileScope;
    @Parameter(property="includeProvidedScope", defaultValue="true", required=false)
    private Boolean includeProvidedScope;
    @Parameter(property="includeRuntimeScope", defaultValue="true", required=false)
    private Boolean includeRuntimeScope;
    @Parameter(property="includeTestScope", defaultValue="false", required=false)
    private Boolean includeTestScope;
    @Parameter(property="includeSystemScope", defaultValue="true", required=false)
    private Boolean includeSystemScope;
    protected static final String MESSAGE_RESOLVING_DEPS = "CycloneDX: Resolving Dependencies";
    protected static final String MESSAGE_CREATING_BOM = "CycloneDX: Creating BOM";
    protected static final String MESSAGE_CALCULATING_HASHES = "CycloneDX: Calculating Hashes";
    protected static final String MESSAGE_WRITING_BOM = "CycloneDX: Writing BOM";
    protected static final String MESSAGE_VALIDATING_BOM = "CycloneDX: Validating BOM";
    protected static final String MESSAGE_VALIDATION_FAILURE = "The BOM does not conform to the CycloneDX BOM standard as defined by the XSD";

    public MavenSession getSession() {
        return this.session;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    protected Boolean getIncludeCompileScope() {
        return this.includeCompileScope;
    }

    protected Boolean getIncludeProvidedScope() {
        return this.includeProvidedScope;
    }

    protected Boolean getIncludeRuntimeScope() {
        return this.includeRuntimeScope;
    }

    protected Boolean getIncludeTestScope() {
        return this.includeTestScope;
    }

    protected Boolean getIncludeSystemScope() {
        return this.includeSystemScope;
    }

    protected boolean shouldInclude(Artifact artifact) {
        if (artifact.getScope() == null) {
            return false;
        }
        if (this.includeCompileScope.booleanValue() && "compile".equals(artifact.getScope())) {
            return true;
        }
        if (this.includeProvidedScope.booleanValue() && "provided".equals(artifact.getScope())) {
            return true;
        }
        if (this.includeRuntimeScope.booleanValue() && "runtime".equals(artifact.getScope())) {
            return true;
        }
        if (this.includeTestScope.booleanValue() && "test".equals(artifact.getScope())) {
            return true;
        }
        return this.includeSystemScope != false && "system".equals(artifact.getScope());
    }

    protected Component convert(Artifact artifact) {
        Component component = new Component();
        component.setGroup(artifact.getGroupId());
        component.setName(artifact.getArtifactId());
        component.setVersion(artifact.getVersion());
        component.setType("library");
        try {
            this.getLog().debug((CharSequence)MESSAGE_CALCULATING_HASHES);
            component.setHashes(BomUtils.calculateHashes((File)artifact.getFile()));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error encountered calculating hashes", (Throwable)e);
        }
        component.setModified(this.isModified(artifact));
        try {
            TreeMap<String, String> qualifiers = null;
            if (artifact.getType() != null || artifact.getClassifier() != null) {
                qualifiers = new TreeMap<String, String>();
                if (artifact.getType() != null) {
                    qualifiers.put("type", artifact.getType());
                }
                if (artifact.getClassifier() != null) {
                    qualifiers.put("classifier", artifact.getClassifier());
                }
            }
            PackageURL purl = new PackageURL("maven", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), qualifiers, null);
            component.setPurl(purl.canonicalize());
        }
        catch (MalformedPackageURLException qualifiers) {
            // empty catch block
        }
        MavenProject project = this.extractPom(artifact);
        if (project != null) {
            if (project.getOrganization() != null) {
                component.setPublisher(project.getOrganization().getName());
            }
            component.setDescription(project.getDescription());
            if (project.getLicenses() != null) {
                ArrayList<org.cyclonedx.model.License> licenses = new ArrayList<org.cyclonedx.model.License>();
                for (License artifactLicense : project.getLicenses()) {
                    org.cyclonedx.model.License license = new org.cyclonedx.model.License();
                    if (artifactLicense.getName() != null) {
                        license.setName(artifactLicense.getName());
                        licenses.add(license);
                        continue;
                    }
                    if (artifactLicense.getUrl() == null) continue;
                    license.setName(artifactLicense.getUrl());
                    licenses.add(license);
                }
                if (licenses.size() > 0) {
                    component.setLicenses(licenses);
                }
            }
        }
        return component;
    }

    /*
     * Exception decompiling
     */
    private MavenProject extractPom(Artifact artifact) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void execute(Set<Component> components) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)MESSAGE_CREATING_BOM);
            Document doc = BomUtils.createBom(components);
            String bomString = BomUtils.toString((Document)doc);
            File bomFile = new File(this.project.getBasedir(), "target/bom.xml");
            this.getLog().info((CharSequence)MESSAGE_WRITING_BOM);
            FileUtils.write((File)bomFile, (CharSequence)bomString, (Charset)Charset.forName("UTF-8"), (boolean)false);
            this.getLog().info((CharSequence)MESSAGE_VALIDATING_BOM);
            if (BomUtils.validateBom((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (File)bomFile).size() != 0) {
                throw new MojoExecutionException(MESSAGE_VALIDATION_FAILURE);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            throw new MojoExecutionException("An error occurred executing " + ((Object)((Object)this)).getClass().getName(), e);
        }
    }

    private boolean isModified(Artifact artifact) {
        return false;
    }

    protected void logParameters() {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"CycloneDX: Parameters");
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
            this.getLog().info((CharSequence)("includeCompileScope   : " + this.includeCompileScope));
            this.getLog().info((CharSequence)("includeProvidedScope  : " + this.includeProvidedScope));
            this.getLog().info((CharSequence)("includeRuntimeScope   : " + this.includeRuntimeScope));
            this.getLog().info((CharSequence)("includeTestScope      : " + this.includeTestScope));
            this.getLog().info((CharSequence)("includeSystemScope    : " + this.includeSystemScope));
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        }
    }
}

