/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.cyclonedx.model.Component;
import org.cyclonedx.util.BomUtils;
import org.w3c.dom.Document;

public abstract class BaseCycloneDxMojo
extends AbstractMojo {
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="reactorProjects", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="includeCompileScope", defaultValue="true", required=false)
    private Boolean includeCompileScope;
    @Parameter(property="includeProvidedScope", defaultValue="true", required=false)
    private Boolean includeProvidedScope;
    @Parameter(property="includeRuntimeScope", defaultValue="true", required=false)
    private Boolean includeRuntimeScope;
    @Parameter(property="includeTestScope", defaultValue="false", required=false)
    private Boolean includeTestScope;
    @Parameter(property="includeSystemScope", defaultValue="true", required=false)
    private Boolean includeSystemScope;
    protected static final String MESSAGE_RESOLVING_DEPS = "CycloneDX: Resolving Dependencies";
    protected static final String MESSAGE_CREATING_BOM = "CycloneDX: Creating BOM";
    protected static final String MESSAGE_CALCULATING_HASHES = "CycloneDX: Calculating Hashes";
    protected static final String MESSAGE_WRITING_BOM = "CycloneDX: Writing BOM";
    protected static final String MESSAGE_VALIDATING_BOM = "CycloneDX: Validating BOM";
    protected static final String MESSAGE_VALIDATION_FAILURE = "The BOM does not conform to the CycloneDX BOM standard as defined by the XSD";

    public MavenSession getSession() {
        return this.session;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    protected Boolean getIncludeCompileScope() {
        return this.includeCompileScope;
    }

    protected Boolean getIncludeProvidedScope() {
        return this.includeProvidedScope;
    }

    protected Boolean getIncludeRuntimeScope() {
        return this.includeRuntimeScope;
    }

    protected Boolean getIncludeTestScope() {
        return this.includeTestScope;
    }

    protected Boolean getIncludeSystemScope() {
        return this.includeSystemScope;
    }

    protected boolean shouldInclude(Artifact artifact) {
        if (artifact.getScope() == null) {
            return false;
        }
        if (this.includeCompileScope.booleanValue() && "compile".equals(artifact.getScope())) {
            return true;
        }
        if (this.includeProvidedScope.booleanValue() && "provided".equals(artifact.getScope())) {
            return true;
        }
        if (this.includeRuntimeScope.booleanValue() && "runtime".equals(artifact.getScope())) {
            return true;
        }
        if (this.includeTestScope.booleanValue() && "test".equals(artifact.getScope())) {
            return true;
        }
        return this.includeSystemScope != false && "system".equals(artifact.getScope());
    }

    protected Component convert(Artifact artifact) {
        Component component = new Component();
        component.setGroup(artifact.getGroupId());
        component.setName(artifact.getArtifactId());
        component.setVersion(artifact.getVersion());
        component.setType("library");
        try {
            this.getLog().debug((CharSequence)MESSAGE_CALCULATING_HASHES);
            component.setHashes(BomUtils.calculateHashes((File)artifact.getFile()));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error encountered calculating hashes", (Throwable)e);
        }
        component.setModified(this.isModified(artifact));
        try {
            TreeMap<String, String> qualifiers = null;
            if (artifact.getType() != null || artifact.getClassifier() != null) {
                qualifiers = new TreeMap<String, String>();
                if (artifact.getType() != null) {
                    qualifiers.put("type", artifact.getType());
                }
                if (artifact.getClassifier() != null) {
                    qualifiers.put("classifier", artifact.getClassifier());
                }
            }
            PackageURL purl = new PackageURL("maven", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), qualifiers, null);
            component.setPurl(purl.canonicalize());
        }
        catch (MalformedPackageURLException qualifiers) {
            // empty catch block
        }
        MavenProject project = this.extractPom(artifact);
        if (project != null) {
            if (project.getOrganization() != null) {
                component.setPublisher(project.getOrganization().getName());
            }
            component.setDescription(project.getDescription());
            if (project.getLicenses() != null) {
                ArrayList<org.cyclonedx.model.License> licenses = new ArrayList<org.cyclonedx.model.License>();
                for (License artifactLicense : project.getLicenses()) {
                    org.cyclonedx.model.License license = new org.cyclonedx.model.License();
                    if (artifactLicense.getName() != null) {
                        license.setName(artifactLicense.getName());
                        licenses.add(license);
                        continue;
                    }
                    if (artifactLicense.getUrl() == null) continue;
                    license.setName(artifactLicense.getUrl());
                    licenses.add(license);
                }
                if (licenses.size() > 0) {
                    component.setLicenses(licenses);
                }
            }
        }
        return component;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private MavenProject extractPom(Artifact artifact) {
        if (artifact.getFile() != null) {
            try {
                JarFile jarFile = new JarFile(artifact.getFile());
                JarEntry entry = jarFile.getJarEntry("META-INF/maven/" + artifact.getGroupId() + "/" + artifact.getArtifactId() + "/pom.xml");
                if (entry != null) {
                    MavenXpp3Reader mavenreader = new MavenXpp3Reader();
                    Throwable throwable = null;
                    try (InputStream input = jarFile.getInputStream(entry);){
                        MavenProject mavenProject;
                        InputStreamReader reader = new InputStreamReader(input);
                        Throwable throwable2 = null;
                        try {
                            Model model = mavenreader.read((Reader)reader);
                            mavenProject = new MavenProject(model);
                        }
                        catch (Throwable throwable3) {
                            try {
                                try {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    BaseCycloneDxMojo.$closeResource(throwable2, reader);
                                    throw throwable4;
                                }
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                        }
                        BaseCycloneDxMojo.$closeResource(throwable2, reader);
                        return mavenProject;
                    }
                }
            }
            catch (IOException | XmlPullParserException throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected void execute(Set<Component> components) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)MESSAGE_CREATING_BOM);
            Document doc = BomUtils.createBom(components);
            String bomString = BomUtils.toString((Document)doc);
            File bomFile = new File(this.project.getBasedir(), "target/bom.xml");
            this.getLog().info((CharSequence)MESSAGE_WRITING_BOM);
            FileUtils.write((File)bomFile, (CharSequence)bomString, (Charset)Charset.forName("UTF-8"), (boolean)false);
            this.getLog().info((CharSequence)MESSAGE_VALIDATING_BOM);
            if (BomUtils.validateBom((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (File)bomFile).size() != 0) {
                throw new MojoExecutionException(MESSAGE_VALIDATION_FAILURE);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            throw new MojoExecutionException("An error occurred executing " + ((Object)((Object)this)).getClass().getName(), e);
        }
    }

    private boolean isModified(Artifact artifact) {
        return false;
    }

    protected void logParameters() {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"CycloneDX: Parameters");
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
            this.getLog().info((CharSequence)("includeCompileScope   : " + this.includeCompileScope));
            this.getLog().info((CharSequence)("includeProvidedScope  : " + this.includeProvidedScope));
            this.getLog().info((CharSequence)("includeRuntimeScope   : " + this.includeRuntimeScope));
            this.getLog().info((CharSequence)("includeTestScope      : " + this.includeTestScope));
            this.getLog().info((CharSequence)("includeSystemScope    : " + this.includeSystemScope));
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        }
    }
}

