/*
 * Decompiled with CFR 0.152.
 */
package com.github.packageurl;

import com.github.packageurl.MalformedPackageURLException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class PackageURL
implements Serializable {
    private static final long serialVersionUID = 3243226021636427586L;
    private static final Pattern TYPE_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9.+-]+$");
    private String scheme;
    private String type;
    private String namespace;
    private String name;
    private String version;
    private Map<String, String> qualifiers;
    private String subpath;

    public PackageURL(String purl) throws MalformedPackageURLException {
        this.parse(purl);
    }

    public PackageURL(String type, String name) throws MalformedPackageURLException {
        this(type, null, name, null, null, null);
    }

    public PackageURL(String type, String namespace, String name, String version, TreeMap<String, String> qualifiers, String subpath) throws MalformedPackageURLException {
        this.scheme = this.validateScheme("pkg");
        this.type = this.validateType(type);
        this.namespace = this.validateNamespace(namespace);
        this.name = this.validateName(name);
        this.version = this.validateVersion(version);
        this.qualifiers = qualifiers;
        this.subpath = this.validateSubpath(subpath);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Map getQualifiers() {
        return this.qualifiers;
    }

    public String getSubpath() {
        return this.subpath;
    }

    private void parse(String purl) throws MalformedPackageURLException {
        if (purl == null || "".equals(purl.trim())) {
            throw new MalformedPackageURLException("Invalid purl: Contains an empty or null value");
        }
        try {
            String[] firstPartArray;
            int index;
            URI uri = new URI(purl);
            if (uri.getUserInfo() != null || uri.getPort() != -1) {
                throw new MalformedPackageURLException("Invalid purl: Contains parts not supported by the purl spec");
            }
            this.scheme = this.validateScheme(uri.getScheme());
            String remainder = purl.substring(4, purl.length());
            if (remainder.contains("#")) {
                index = remainder.lastIndexOf("#");
                this.subpath = this.validateSubpath(remainder.substring(index + 1, remainder.length()));
                remainder = remainder.substring(0, index);
            }
            if (remainder.contains("?")) {
                index = remainder.lastIndexOf("?");
                this.qualifiers = this.validateQualifiers(remainder.substring(index + 1, remainder.length()));
                remainder = remainder.substring(0, index);
            }
            if (remainder.contains("@")) {
                index = remainder.lastIndexOf("@");
                this.version = this.validateVersion(remainder.substring(index + 1, remainder.length()));
                remainder = remainder.substring(0, index);
            }
            if ((firstPartArray = (remainder = remainder.replaceAll("^[/]*", "")).split("/")).length < 2) {
                throw new MalformedPackageURLException("Invalid purl: Does not contain a minimum of a 'type' and a 'name'");
            }
            this.type = this.validateType(firstPartArray[0]);
            this.name = this.validateName(firstPartArray[firstPartArray.length - 1]);
            if (firstPartArray.length > 2) {
                CharSequence[] namespaces = Arrays.copyOfRange(firstPartArray, 1, firstPartArray.length - 1);
                String namespace = String.join((CharSequence)",", namespaces);
                this.namespace = this.validateNamespace(namespace);
            }
        }
        catch (URISyntaxException e) {
            throw new MalformedPackageURLException("Invalid purl: " + e.getMessage());
        }
    }

    private String validateScheme(String scheme) throws MalformedPackageURLException {
        if (scheme == null || !scheme.equals("pkg")) {
            throw new MalformedPackageURLException("The PackageURL scheme is invalid");
        }
        return scheme;
    }

    private String validateType(String type) throws MalformedPackageURLException {
        if (type == null || !TYPE_PATTERN.matcher(type).matches()) {
            throw new MalformedPackageURLException("The PackageURL type specified is invalid");
        }
        return type.toLowerCase();
    }

    private String validateNamespace(String namespace) {
        if (namespace == null) {
            return null;
        }
        switch (this.type) {
            case "bitbucket": {
                namespace = namespace.toLowerCase();
                break;
            }
            case "debian": {
                namespace = namespace.toLowerCase();
                break;
            }
            case "github": {
                namespace = namespace.toLowerCase();
                break;
            }
            case "golang": {
                namespace = namespace.toLowerCase();
                break;
            }
            case "npm": {
                namespace = namespace.toLowerCase();
                break;
            }
            case "rpm": {
                namespace = namespace.toLowerCase();
            }
        }
        return this.urldecode(namespace);
    }

    private String validateName(String name) throws MalformedPackageURLException {
        if (name == null) {
            throw new MalformedPackageURLException("The PackageURL name specified is invalid");
        }
        switch (this.type) {
            case "bitbucket": {
                name = name.toLowerCase();
                break;
            }
            case "debian": {
                name = name.toLowerCase();
                break;
            }
            case "github": {
                name = name.toLowerCase();
                break;
            }
            case "golang": {
                name = name.toLowerCase();
                break;
            }
            case "npm": {
                name = name.toLowerCase();
                break;
            }
            case "pypi": {
                name = name.replaceAll("_", "-").toLowerCase();
            }
        }
        return this.urldecode(name);
    }

    private String validateVersion(String version) {
        if (version == null) {
            return null;
        }
        return version;
    }

    private Map<String, String> validateQualifiers(String qualifiers) {
        String[] pairs;
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String pair : pairs = qualifiers.split("&")) {
            if (!pair.contains("=")) continue;
            String[] kvpair = pair.split("=");
            map.put(kvpair[0], kvpair[1]);
        }
        return map;
    }

    private String validateSubpath(String subpath) {
        if (subpath == null) {
            return null;
        }
        return this.stripLeadingAndTrailingSlash(subpath);
    }

    public String canonicalize() {
        StringBuilder purl = new StringBuilder();
        purl.append(this.scheme).append(":");
        if (this.type != null) {
            purl.append(this.type);
        }
        purl.append("/");
        if (this.namespace != null) {
            purl.append(this.urlencode(this.namespace));
            purl.append("/");
        }
        if (this.name != null) {
            purl.append(this.name);
        }
        if (this.version != null) {
            purl.append("@").append(this.version);
        }
        if (this.qualifiers != null && this.qualifiers.size() > 0) {
            purl.append("?");
            StringBuilder temp = new StringBuilder();
            for (Map.Entry<String, String> entry : this.qualifiers.entrySet()) {
                temp.append(entry.getKey().toLowerCase());
                temp.append("=");
                temp.append(entry.getValue());
                temp.append("&");
            }
            purl.append(temp.toString().substring(0, temp.toString().length() - 1));
        }
        if (this.subpath != null) {
            purl.append("#").append(this.subpath);
        }
        return purl.toString();
    }

    private String stripLeadingAndTrailingSlash(String input) {
        if (input == null) {
            return null;
        }
        if (input.startsWith("/")) {
            input = input.substring(1, input.length());
        }
        if (input.endsWith("/")) {
            input = input.substring(0, input.length() - 1);
        }
        return input;
    }

    private String urlencode(String input) {
        try {
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return input;
        }
    }

    private String urldecode(String input) {
        try {
            return URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return input;
        }
    }

    public static class StandardTypes {
        public static final String BITBUCKET = "bitbucket";
        public static final String COMPOSER = "composer";
        public static final String DEBIAN = "deb";
        public static final String DOCKER = "docker";
        public static final String GEM = "gem";
        public static final String GENERIC = "generic";
        public static final String GITHUB = "github";
        public static final String GOLANG = "golang";
        public static final String MAVEN = "maven";
        public static final String NPM = "npm";
        public static final String NUGET = "nuget";
        public static final String PYPI = "pypi";
        public static final String RPM = "rpm";
    }
}

