/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.cyclonedx.BomGenerator;
import org.cyclonedx.BomParser;
import org.cyclonedx.model.Component;
import org.cyclonedx.util.BomUtils;

public abstract class BaseCycloneDxMojo
extends AbstractMojo {
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="reactorProjects", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="includeCompileScope", defaultValue="true", required=false)
    private Boolean includeCompileScope;
    @Parameter(property="includeProvidedScope", defaultValue="true", required=false)
    private Boolean includeProvidedScope;
    @Parameter(property="includeRuntimeScope", defaultValue="true", required=false)
    private Boolean includeRuntimeScope;
    @Parameter(property="includeTestScope", defaultValue="false", required=false)
    private Boolean includeTestScope;
    @Parameter(property="includeSystemScope", defaultValue="true", required=false)
    private Boolean includeSystemScope;
    @Parameter(property="cyclonedx.skip", defaultValue="false", required=false)
    private boolean skip = false;
    protected static final String MESSAGE_RESOLVING_DEPS = "CycloneDX: Resolving Dependencies";
    protected static final String MESSAGE_CREATING_BOM = "CycloneDX: Creating BOM";
    protected static final String MESSAGE_CALCULATING_HASHES = "CycloneDX: Calculating Hashes";
    protected static final String MESSAGE_WRITING_BOM = "CycloneDX: Writing BOM";
    protected static final String MESSAGE_VALIDATING_BOM = "CycloneDX: Validating BOM";
    protected static final String MESSAGE_VALIDATION_FAILURE = "The BOM does not conform to the CycloneDX BOM standard as defined by the XSD";

    public MavenSession getSession() {
        return this.session;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    protected Boolean getIncludeCompileScope() {
        return this.includeCompileScope;
    }

    protected Boolean getIncludeProvidedScope() {
        return this.includeProvidedScope;
    }

    protected Boolean getIncludeRuntimeScope() {
        return this.includeRuntimeScope;
    }

    protected Boolean getIncludeTestScope() {
        return this.includeTestScope;
    }

    protected Boolean getIncludeSystemScope() {
        return this.includeSystemScope;
    }

    protected Boolean getSkip() {
        return this.skip;
    }

    protected boolean shouldInclude(Artifact artifact) {
        if (artifact.getScope() == null) {
            return false;
        }
        if (this.includeCompileScope.booleanValue() && "compile".equals(artifact.getScope())) {
            return true;
        }
        if (this.includeProvidedScope.booleanValue() && "provided".equals(artifact.getScope())) {
            return true;
        }
        if (this.includeRuntimeScope.booleanValue() && "runtime".equals(artifact.getScope())) {
            return true;
        }
        if (this.includeTestScope.booleanValue() && "test".equals(artifact.getScope())) {
            return true;
        }
        return this.includeSystemScope != false && "system".equals(artifact.getScope());
    }

    protected Component convert(Artifact artifact) {
        MavenProject project;
        Component component = new Component();
        component.setGroup(artifact.getGroupId());
        component.setName(artifact.getArtifactId());
        component.setVersion(artifact.getVersion());
        component.setType("library");
        try {
            this.getLog().debug((CharSequence)MESSAGE_CALCULATING_HASHES);
            component.setHashes(BomUtils.calculateHashes((File)artifact.getFile()));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error encountered calculating hashes", (Throwable)e);
        }
        component.setModified(this.isModified(artifact));
        try {
            TreeMap<String, String> qualifiers = null;
            if (artifact.getType() != null || artifact.getClassifier() != null) {
                qualifiers = new TreeMap<String, String>();
                if (artifact.getType() != null) {
                    qualifiers.put("type", artifact.getType());
                }
                if (artifact.getClassifier() != null) {
                    qualifiers.put("classifier", artifact.getClassifier());
                }
            }
            PackageURL purl = new PackageURL("maven", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), qualifiers, null);
            component.setPurl(purl.canonicalize());
        }
        catch (MalformedPackageURLException e) {
            this.getLog().warn((CharSequence)("An unexpected issue occurred attempting to create a PackageURL for " + component.getName()), (Throwable)e);
        }
        if (this.isDescribedArtifact(artifact) && (project = this.extractPom(artifact)) != null) {
            this.getClosestMetadata(artifact, project, component);
        }
        return component;
    }

    private void getClosestMetadata(Artifact artifact, MavenProject project, Component component) {
        MavenProject parentProject;
        this.extractMetadata(project, component);
        if (project.getParent() != null) {
            this.getClosestMetadata(artifact, project.getParent(), component);
        } else if (project.getModel().getParent() != null && (parentProject = this.retrieveParentProject(artifact, project)) != null) {
            this.getClosestMetadata(artifact, parentProject, component);
        }
    }

    private void extractMetadata(MavenProject project, Component component) {
        if (component.getPublisher() == null && project.getOrganization() != null) {
            component.setPublisher(project.getOrganization().getName());
        }
        if (component.getDescription() == null) {
            component.setDescription(project.getDescription());
        }
        if ((component.getLicenses() == null || component.getLicenses().size() == 0) && project.getLicenses() != null) {
            ArrayList<org.cyclonedx.model.License> licenses = new ArrayList<org.cyclonedx.model.License>();
            for (License artifactLicense : project.getLicenses()) {
                org.cyclonedx.model.License license = new org.cyclonedx.model.License();
                if (artifactLicense.getName() != null) {
                    license.setName(artifactLicense.getName());
                    licenses.add(license);
                    continue;
                }
                if (artifactLicense.getUrl() == null) continue;
                license.setName(artifactLicense.getUrl());
                licenses.add(license);
            }
            if (licenses.size() > 0) {
                component.setLicenses(licenses);
            }
        }
    }

    private MavenProject retrieveParentProject(Artifact artifact, MavenProject project) {
        if (artifact.getFile() == null || artifact.getFile().getParentFile() == null || !this.isDescribedArtifact(artifact)) {
            return null;
        }
        Model model = project.getModel();
        if (model.getParent() != null) {
            Parent parent = model.getParent();
            StringBuilder getout = new StringBuilder("../../../");
            int periods = artifact.getGroupId().length() - artifact.getGroupId().replace(".", "").length();
            for (int i = 0; i < periods; ++i) {
                getout.append("../");
            }
            File parentFile = new File(artifact.getFile().getParentFile(), getout + parent.getGroupId().replace(".", "/") + "/" + parent.getArtifactId() + "/" + parent.getVersion() + "/" + parent.getArtifactId() + "-" + parent.getVersion() + ".pom");
            if (parentFile.exists() && parentFile.isFile()) {
                try {
                    return this.readPom(parentFile.getCanonicalFile());
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)"An error occurred retrieving an artifacts parent pom", (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MavenProject extractPom(Artifact artifact) {
        if (!this.isDescribedArtifact(artifact)) {
            return null;
        }
        if (artifact.getFile() == null) return null;
        try {
            JarFile jarFile = new JarFile(artifact.getFile());
            JarEntry entry = jarFile.getJarEntry("META-INF/maven/" + artifact.getGroupId() + "/" + artifact.getArtifactId() + "/pom.xml");
            if (entry == null) return null;
            try (InputStream input = jarFile.getInputStream(entry);){
                MavenProject mavenProject = this.readPom(input);
                return mavenProject;
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"An error occurred attempting to extract POM from artifact", (Throwable)e);
        }
        return null;
    }

    private MavenProject readPom(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            MavenProject mavenProject = this.readPom(in);
            return mavenProject;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MavenProject readPom(InputStream in) {
        try {
            MavenXpp3Reader mavenreader = new MavenXpp3Reader();
            try (InputStreamReader reader = new InputStreamReader(in);){
                Model model = mavenreader.read((Reader)reader);
                MavenProject mavenProject = new MavenProject(model);
                return mavenProject;
            }
        }
        catch (IOException | XmlPullParserException e) {
            this.getLog().error((CharSequence)"An error occurred attempting to read POM", e);
            return null;
        }
    }

    protected void execute(Set<Component> components) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)MESSAGE_CREATING_BOM);
            BomGenerator bomGenerator = new BomGenerator(components);
            bomGenerator.generate();
            String bomString = bomGenerator.toXmlString();
            File bomFile = new File(this.project.getBasedir(), "target/bom.xml");
            this.getLog().info((CharSequence)MESSAGE_WRITING_BOM);
            FileUtils.write((File)bomFile, (CharSequence)bomString, (Charset)Charset.forName("UTF-8"), (boolean)false);
            this.getLog().info((CharSequence)MESSAGE_VALIDATING_BOM);
            BomParser bomParser = new BomParser();
            if (!bomParser.isValid(bomFile)) {
                throw new MojoExecutionException(MESSAGE_VALIDATION_FAILURE);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            throw new MojoExecutionException("An error occurred executing " + ((Object)((Object)this)).getClass().getName(), e);
        }
    }

    private boolean isModified(Artifact artifact) {
        return false;
    }

    private boolean isDescribedArtifact(Artifact artifact) {
        return artifact.getType().equalsIgnoreCase("jar");
    }

    protected void logParameters() {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"CycloneDX: Parameters");
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
            this.getLog().info((CharSequence)("includeCompileScope   : " + this.includeCompileScope));
            this.getLog().info((CharSequence)("includeProvidedScope  : " + this.includeProvidedScope));
            this.getLog().info((CharSequence)("includeRuntimeScope   : " + this.includeRuntimeScope));
            this.getLog().info((CharSequence)("includeTestScope      : " + this.includeTestScope));
            this.getLog().info((CharSequence)("includeSystemScope    : " + this.includeSystemScope));
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        }
    }
}

