/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.cyclonedx.maven.BaseCycloneDxMojo;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;

@Mojo(name="makeBom", defaultPhase=LifecyclePhase.VERIFY, requiresOnline=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CycloneDxMojo
extends BaseCycloneDxMojo {
    public void execute() throws MojoExecutionException {
        boolean shouldSkip = Boolean.parseBoolean(System.getProperty("cyclonedx.skip", Boolean.toString(this.getSkip())));
        if (shouldSkip) {
            this.getLog().info((CharSequence)"Skipping CycloneDX");
            return;
        }
        this.logParameters();
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        LinkedHashSet<String> componentRefs = new LinkedHashSet<String>();
        Set<Dependency> dependencies = new LinkedHashSet<Dependency>();
        this.getLog().info((CharSequence)"CycloneDX: Resolving Dependencies");
        if (this.getProject() != null && this.getProject().getArtifacts() != null) {
            for (Artifact artifact : this.getProject().getArtifacts()) {
                if (!this.shouldInclude(artifact)) continue;
                Component component = this.convert(artifact);
                boolean found = false;
                for (String s : componentRefs) {
                    if (s == null || !s.equals(component.getBomRef())) continue;
                    found = true;
                }
                if (found) continue;
                componentRefs.add(component.getBomRef());
                components.add(component);
            }
        }
        if (this.schemaVersion().getVersion() >= 1.2) {
            dependencies = this.buildDependencyGraph(componentRefs, null);
        }
        super.execute(components, dependencies);
    }
}

