/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import java.util.LinkedHashSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.cyclonedx.maven.BaseCycloneDxMojo;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;

@Mojo(name="makeAggregateBom", defaultPhase=LifecyclePhase.VERIFY, aggregator=true, requiresOnline=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CycloneDxAggregateMojo
extends BaseCycloneDxMojo {
    public void execute() throws MojoExecutionException {
        boolean shouldSkip = Boolean.parseBoolean(System.getProperty("cyclonedx.skip", Boolean.toString(this.getSkip())));
        if (shouldSkip) {
            this.getLog().info((CharSequence)"Skipping CycloneDX");
            return;
        }
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        LinkedHashSet<String> componentRefs = new LinkedHashSet<String>();
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        this.dependencyAnalyzer = this.createProjectDependencyAnalyzer();
        for (MavenProject mavenProject : this.getReactorProjects()) {
            ProjectDependencyAnalysis dependencyAnalysis = null;
            try {
                dependencyAnalysis = this.dependencyAnalyzer.analyze(mavenProject);
            }
            catch (Exception e) {
                this.getLog().debug((Throwable)e);
            }
            for (Artifact artifact : mavenProject.getArtifacts()) {
                if (!this.shouldInclude(artifact)) continue;
                Component component = this.convert(artifact);
                boolean found = false;
                for (String s : componentRefs) {
                    if (s == null || !s.equals(component.getBomRef())) continue;
                    found = true;
                }
                if (found) continue;
                component.setScope(this.getComponentScope(component, artifact, dependencyAnalysis));
                componentRefs.add(component.getBomRef());
                components.add(component);
            }
            if (!(this.schemaVersion().getVersion() >= 1.2)) continue;
            dependencies.addAll(this.buildDependencyGraph(componentRefs, mavenProject));
        }
        super.execute(components, dependencies);
    }
}

