/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.cyclonedx.maven.BaseCycloneDxMojo;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;

@Mojo(name="makeAggregateBom", defaultPhase=LifecyclePhase.PACKAGE, aggregator=true, requiresOnline=true, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class CycloneDxAggregateMojo
extends BaseCycloneDxMojo {
    protected boolean shouldExclude(MavenProject mavenProject) {
        boolean shouldExclude = false;
        if (this.excludeArtifactId != null && this.excludeArtifactId.length > 0) {
            shouldExclude = Arrays.asList(this.excludeArtifactId).contains(mavenProject.getArtifactId());
        }
        if (this.excludeTestProject.booleanValue() && mavenProject.getArtifactId().contains("test")) {
            shouldExclude = true;
        }
        return shouldExclude;
    }

    public void execute() throws MojoExecutionException {
        boolean shouldSkip = Boolean.parseBoolean(System.getProperty("cyclonedx.skip", Boolean.toString(this.getSkip())));
        if (shouldSkip) {
            this.getLog().info((CharSequence)"Skipping CycloneDX");
            return;
        }
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        LinkedHashSet<String> componentRefs = new LinkedHashSet<String>();
        LinkedHashMap<String, ProjectDependencyAnalysis> dependencyAnalysisMap = new LinkedHashMap<String, ProjectDependencyAnalysis>();
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        this.dependencyAnalyzer = this.createProjectDependencyAnalyzer();
        for (MavenProject mavenProject : this.getReactorProjects()) {
            if (this.shouldExclude(mavenProject)) continue;
            try {
                ProjectDependencyAnalysis dependencyAnalysis = this.dependencyAnalyzer.analyze(mavenProject);
                dependencyAnalysisMap.put(mavenProject.getArtifactId(), dependencyAnalysis);
            }
            catch (Exception e) {
                this.getLog().debug((Throwable)e);
            }
        }
        Component bomComponent = this.convert(this.getProject().getArtifact());
        componentRefs.add(bomComponent.getBomRef());
        for (MavenProject mavenProject : this.getReactorProjects()) {
            if (this.shouldExclude(mavenProject)) {
                this.getLog().info((CharSequence)("Skipping " + mavenProject.getArtifactId()));
                continue;
            }
            LinkedHashSet<Component> projectComponents = new LinkedHashSet<Component>();
            LinkedHashSet<String> projectComponentRefs = new LinkedHashSet<String>();
            LinkedHashSet<Dependency> projectDependencies = new LinkedHashSet<Dependency>();
            Component projectBomComponent = this.convert(mavenProject.getArtifact());
            if (!mavenProject.isExecutionRoot()) {
                boolean found = false;
                for (String s : componentRefs) {
                    if (s == null || !s.equals(projectBomComponent.getBomRef())) continue;
                    found = true;
                }
                if (!found) {
                    components.add(projectBomComponent);
                }
            }
            componentRefs.add(projectBomComponent.getBomRef());
            for (Artifact artifact : mavenProject.getArtifacts()) {
                if (!this.shouldInclude(artifact)) continue;
                Component component = this.convert(artifact);
                boolean found = false;
                for (String s : componentRefs) {
                    if (s == null || !s.equals(component.getBomRef())) continue;
                    found = true;
                }
                if (found) continue;
                Component.Scope componentScope = null;
                for (String projectId : dependencyAnalysisMap.keySet()) {
                    ProjectDependencyAnalysis dependencyAnalysis = (ProjectDependencyAnalysis)dependencyAnalysisMap.get(projectId);
                    Component.Scope currentProjectScope = this.getComponentScope(component, artifact, dependencyAnalysis);
                    if (Component.Scope.REQUIRED.equals((Object)currentProjectScope)) {
                        componentScope = currentProjectScope;
                        break;
                    }
                    if (componentScope != null || currentProjectScope == null) continue;
                    componentScope = currentProjectScope;
                }
                component.setScope(componentScope);
                componentRefs.add(component.getBomRef());
                components.add(component);
                projectComponentRefs.add(component.getBomRef());
                projectComponents.add(component);
            }
            if (this.schemaVersion().getVersion() >= 1.2) {
                projectDependencies.addAll(this.buildDependencyGraph(componentRefs, mavenProject));
                dependencies.addAll(projectDependencies);
            }
            if (mavenProject.isExecutionRoot()) continue;
            super.execute(projectComponents, projectDependencies, mavenProject);
        }
        this.addMavenProjectsAsDependencies(this.getReactorProjects(), dependencies);
        super.execute(components, dependencies, this.getProject());
    }
}

