/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.cyclonedx.maven.BaseCycloneDxMojo;
import org.cyclonedx.maven.CycloneDxMojo;
import org.cyclonedx.maven.ProjectDependenciesConverter;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;

@Mojo(name="makeAggregateBom", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, aggregator=true, requiresOnline=true)
public class CycloneDxAggregateMojo
extends CycloneDxMojo {
    @Parameter(property="reactorProjects", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="outputReactorProjects", defaultValue="true", required=false)
    private Boolean outputReactorProjects;
    @Parameter(property="excludeArtifactId", required=false)
    protected String[] excludeArtifactId;
    @Parameter(property="excludeGroupId", required=false)
    protected String[] excludeGroupId;
    @Parameter(property="excludeTestProject", defaultValue="false", required=false)
    protected Boolean excludeTestProject;

    protected boolean shouldExclude(MavenProject mavenProject) {
        boolean shouldExclude = false;
        if (this.excludeArtifactId != null && this.excludeArtifactId.length > 0) {
            shouldExclude = Arrays.asList(this.excludeArtifactId).contains(mavenProject.getArtifactId());
        }
        if (!shouldExclude && this.excludeGroupId != null && this.excludeGroupId.length > 0) {
            shouldExclude = Arrays.asList(this.excludeGroupId).contains(mavenProject.getGroupId());
        }
        if (this.excludeTestProject.booleanValue() && mavenProject.getArtifactId().contains("test")) {
            shouldExclude = true;
        }
        if (this.skipNotDeployed && !BaseCycloneDxMojo.isDeployable(mavenProject)) {
            shouldExclude = true;
        }
        return shouldExclude;
    }

    @Override
    protected void logAdditionalParameters() {
        this.getLog().info((CharSequence)("outputReactorProjects  : " + this.outputReactorProjects));
    }

    @Override
    protected String extractComponentsAndDependencies(Set<String> topLevelComponents, Map<String, Component> components, Map<String, Dependency> dependencies) throws MojoExecutionException {
        if (!this.getProject().isExecutionRoot()) {
            if (this.outputReactorProjects.booleanValue()) {
                return super.extractComponentsAndDependencies(topLevelComponents, components, dependencies);
            }
            this.getLog().info((CharSequence)"Skipping CycloneDX on non-execution root");
            return null;
        }
        this.getLog().info((CharSequence)(this.reactorProjects.size() <= 1 ? "CycloneDX: Resolving Dependencies" : "CycloneDX: Resolving Aggregated Dependencies"));
        for (MavenProject mavenProject : this.reactorProjects) {
            if (this.shouldExclude(mavenProject)) {
                this.getLog().info((CharSequence)("Excluding " + mavenProject.getArtifactId()));
                continue;
            }
            ProjectDependenciesConverter.BomDependencies bomDependencies = this.extractBOMDependencies(mavenProject);
            Map<String, Dependency> projectDependencies = bomDependencies.getDependencies();
            Component projectBomComponent = this.convertMavenDependency(mavenProject.getArtifact());
            components.put(projectBomComponent.getPurl(), projectBomComponent);
            topLevelComponents.add(projectBomComponent.getPurl());
            this.populateComponents(topLevelComponents, components, bomDependencies.getArtifacts(), this.doProjectDependencyAnalysis(mavenProject, bomDependencies));
            projectDependencies.forEach(dependencies::putIfAbsent);
        }
        this.addMavenProjectsAsParentDependencies(this.reactorProjects, dependencies);
        return "makeAggregateBom";
    }

    private void addMavenProjectsAsParentDependencies(List<MavenProject> reactorProjects, Map<String, Dependency> dependencies) {
        for (MavenProject project : reactorProjects) {
            String parentRef;
            Dependency parentDependency;
            if (!project.hasParent() || this.shouldExclude(project) || (parentDependency = dependencies.get(parentRef = this.generatePackageUrl(project.getParent().getArtifact()))) == null) continue;
            String projectRef = this.generatePackageUrl(project.getArtifact());
            parentDependency.addDependency(new Dependency(projectRef));
        }
    }
}

