/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.cyclonedx.maven.BaseCycloneDxMojo;
import org.cyclonedx.maven.ProjectDependenciesConverter;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;

@Mojo(name="makeBom", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresOnline=true)
public class CycloneDxMojo
extends BaseCycloneDxMojo {
    @Parameter(property="cyclonedx.skipNotDeployed", defaultValue="true", required=false)
    protected boolean skipNotDeployed = true;
    @Parameter(property="analyzer", defaultValue="default")
    private String analyzer;
    @org.apache.maven.plugins.annotations.Component
    private PlexusContainer plexusContainer;
    protected ProjectDependencyAnalyzer dependencyAnalyzer;

    private ProjectDependencyAnalyzer getProjectDependencyAnalyzer() throws MojoExecutionException {
        if (this.dependencyAnalyzer == null) {
            try {
                this.dependencyAnalyzer = (ProjectDependencyAnalyzer)this.plexusContainer.lookup(ProjectDependencyAnalyzer.class, this.analyzer);
            }
            catch (ComponentLookupException cle) {
                throw new MojoExecutionException("Failed to instantiate ProjectDependencyAnalyser with role-hint " + this.analyzer, (Exception)((Object)cle));
            }
        }
        return this.dependencyAnalyzer;
    }

    protected ProjectDependencyAnalysis doProjectDependencyAnalysis(MavenProject mavenProject, ProjectDependenciesConverter.BomDependencies bomDependencies) throws MojoExecutionException {
        if (this.detectUnusedForOptionalScope) {
            MavenProject localMavenProject = new MavenProject(mavenProject);
            localMavenProject.setArtifacts(new LinkedHashSet<Artifact>(bomDependencies.getArtifacts().values()));
            localMavenProject.setDependencyArtifacts(new LinkedHashSet<Artifact>(bomDependencies.getDependencyArtifacts().values()));
            try {
                return this.getProjectDependencyAnalyzer().analyze(localMavenProject);
            }
            catch (ProjectDependencyAnalyzerException pdae) {
                this.getLog().debug((CharSequence)("Could not analyze " + mavenProject.getId()), (Throwable)pdae);
            }
        }
        return null;
    }

    @Override
    protected boolean shouldSkip() {
        return super.shouldSkip() || this.skipNotDeployed && !CycloneDxMojo.isDeployable(this.getProject());
    }

    @Override
    protected String getSkipReason() {
        if (super.shouldSkip()) {
            return super.getSkipReason();
        }
        return "module skips deploy";
    }

    @Override
    protected String extractComponentsAndDependencies(Set<String> topLevelComponents, Map<String, Component> components, Map<String, Dependency> dependencies) throws MojoExecutionException {
        this.getLog().info((CharSequence)"CycloneDX: Resolving Dependencies");
        ProjectDependenciesConverter.BomDependencies bomDependencies = this.extractBOMDependencies(this.getProject());
        Map<String, Dependency> projectDependencies = bomDependencies.getDependencies();
        Component projectBomComponent = this.convertMavenDependency(this.getProject().getArtifact());
        components.put(projectBomComponent.getPurl(), projectBomComponent);
        topLevelComponents.add(projectBomComponent.getPurl());
        this.populateComponents(topLevelComponents, components, bomDependencies.getArtifacts(), this.doProjectDependencyAnalysis(this.getProject(), bomDependencies));
        projectDependencies.forEach(dependencies::putIfAbsent);
        return "makeBom";
    }
}

