/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.cyclonedx.maven.CycloneDxMojo;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;

@Mojo(name="makeAggregateBom", defaultPhase=LifecyclePhase.PACKAGE, aggregator=true, requiresOnline=true, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class CycloneDxAggregateMojo
extends CycloneDxMojo {
    @Parameter(property="reactorProjects", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="outputReactorProjects", defaultValue="true", required=false)
    private Boolean outputReactorProjects;

    protected boolean shouldExclude(MavenProject mavenProject) {
        boolean shouldExclude = false;
        if (this.excludeArtifactId != null && this.excludeArtifactId.length > 0) {
            shouldExclude = Arrays.asList(this.excludeArtifactId).contains(mavenProject.getArtifactId());
        }
        if (!shouldExclude && this.excludeGroupId != null && this.excludeGroupId.length > 0) {
            shouldExclude = Arrays.asList(this.excludeGroupId).contains(mavenProject.getGroupId());
        }
        if (this.excludeTestProject.booleanValue() && mavenProject.getArtifactId().contains("test")) {
            shouldExclude = true;
        }
        return shouldExclude;
    }

    @Override
    protected void logAdditionalParameters() {
        this.getLog().info((CharSequence)("outputReactorProjects  : " + this.outputReactorProjects));
    }

    @Override
    protected boolean analyze(Set<Component> components, Set<Dependency> dependencies) throws MojoExecutionException {
        if (!this.getProject().isExecutionRoot()) {
            if (this.outputReactorProjects.booleanValue()) {
                return super.analyze(components, dependencies);
            }
            this.getLog().info((CharSequence)"Skipping aggregate CycloneDX on non-execution root");
            return false;
        }
        LinkedHashSet<String> componentRefs = new LinkedHashSet<String>();
        LinkedHashMap<String, ProjectDependencyAnalysis> dependencyAnalysisMap = new LinkedHashMap<String, ProjectDependencyAnalysis>();
        this.dependencyAnalyzer = this.createProjectDependencyAnalyzer();
        for (MavenProject mavenProject : this.reactorProjects) {
            if (this.shouldExclude(mavenProject)) continue;
            try {
                ProjectDependencyAnalysis dependencyAnalysis = this.dependencyAnalyzer.analyze(mavenProject);
                dependencyAnalysisMap.put(mavenProject.getArtifactId(), dependencyAnalysis);
            }
            catch (Exception e) {
                this.getLog().debug((Throwable)e);
            }
        }
        Component bomComponent = this.convert(this.getProject().getArtifact());
        componentRefs.add(bomComponent.getBomRef());
        for (MavenProject mavenProject : this.reactorProjects) {
            if (this.shouldExclude(mavenProject)) {
                this.getLog().info((CharSequence)("Skipping " + mavenProject.getArtifactId()));
                continue;
            }
            LinkedHashSet<String> projectComponentRefs = new LinkedHashSet<String>();
            LinkedHashSet<Dependency> projectDependencies = new LinkedHashSet<Dependency>();
            Component projectBomComponent = this.convert(mavenProject.getArtifact());
            if (!mavenProject.isExecutionRoot()) {
                boolean found = false;
                for (String s : componentRefs) {
                    if (s == null || !s.equals(projectBomComponent.getBomRef())) continue;
                    found = true;
                }
                if (!found) {
                    components.add(projectBomComponent);
                }
            }
            componentRefs.add(projectBomComponent.getBomRef());
            for (Artifact artifact : mavenProject.getArtifacts()) {
                if (!this.shouldInclude(artifact)) continue;
                Component component = this.convert(artifact);
                boolean found = false;
                for (String s : componentRefs) {
                    if (s == null || !s.equals(component.getBomRef())) continue;
                    found = true;
                }
                if (found) continue;
                Component.Scope componentScope = null;
                for (String projectId : dependencyAnalysisMap.keySet()) {
                    ProjectDependencyAnalysis dependencyAnalysis = (ProjectDependencyAnalysis)dependencyAnalysisMap.get(projectId);
                    Component.Scope currentProjectScope = this.getComponentScope(component, artifact, dependencyAnalysis);
                    if (Component.Scope.REQUIRED.equals((Object)currentProjectScope)) {
                        componentScope = currentProjectScope;
                        break;
                    }
                    if (componentScope != null || currentProjectScope == null) continue;
                    componentScope = currentProjectScope;
                }
                component.setScope(componentScope);
                componentRefs.add(component.getBomRef());
                components.add(component);
                projectComponentRefs.add(component.getBomRef());
            }
            if (!(this.schemaVersion().getVersion() >= 1.2)) continue;
            projectDependencies.addAll(this.buildDependencyGraph(componentRefs, mavenProject));
            dependencies.addAll(projectDependencies);
        }
        this.addMavenProjectsAsDependencies(this.reactorProjects, dependencies);
        return true;
    }
}

