/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.cyclonedx.maven.BaseCycloneDxMojo;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;

@Mojo(name="makeBom", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresOnline=true, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class CycloneDxMojo
extends BaseCycloneDxMojo {
    @Parameter(property="analyzer", defaultValue="default")
    private String analyzer;
    @org.apache.maven.plugins.annotations.Component
    private PlexusContainer plexusContainer;
    protected ProjectDependencyAnalyzer dependencyAnalyzer;

    protected ProjectDependencyAnalyzer createProjectDependencyAnalyzer() throws MojoExecutionException {
        try {
            return (ProjectDependencyAnalyzer)this.plexusContainer.lookup(ProjectDependencyAnalyzer.class, this.analyzer);
        }
        catch (ComponentLookupException cle) {
            throw new MojoExecutionException("Failed to instantiate ProjectDependencyAnalyser with role-hint " + this.analyzer, (Exception)((Object)cle));
        }
    }

    @Override
    protected String analyze(Set<Component> components, Set<Dependency> dependencies) throws MojoExecutionException {
        LinkedHashSet<String> componentRefs = new LinkedHashSet<String>();
        this.dependencyAnalyzer = this.createProjectDependencyAnalyzer();
        this.getLog().info((CharSequence)"CycloneDX: Resolving Dependencies");
        if (this.getProject() != null && this.getProject().getArtifacts() != null) {
            ProjectDependencyAnalysis dependencyAnalysis = null;
            try {
                dependencyAnalysis = this.dependencyAnalyzer.analyze(this.getProject());
            }
            catch (Exception e) {
                this.getLog().debug((Throwable)e);
            }
            Component bomComponent = this.convert(this.getProject().getArtifact());
            componentRefs.add(bomComponent.getBomRef());
            for (Artifact artifact : this.getProject().getArtifacts()) {
                Component component = this.convert(artifact);
                if (componentRefs.contains(component.getBomRef())) continue;
                component.setScope(this.getComponentScope(component, artifact, dependencyAnalysis));
                componentRefs.add(component.getBomRef());
                components.add(component);
            }
        }
        if (this.schemaVersion().getVersion() >= 1.2) {
            dependencies.addAll(this.buildDependencyGraph(null));
        }
        return "makeBom";
    }

    protected Component.Scope getComponentScope(Component component, Artifact artifact, ProjectDependencyAnalysis dependencyAnalysis) {
        if (dependencyAnalysis == null) {
            return null;
        }
        Set usedDeclaredArtifacts = dependencyAnalysis.getUsedDeclaredArtifacts();
        Set usedUndeclaredArtifacts = dependencyAnalysis.getUsedUndeclaredArtifacts();
        Set unusedDeclaredArtifacts = dependencyAnalysis.getUnusedDeclaredArtifacts();
        Set testArtifactsWithNonTestScope = dependencyAnalysis.getTestArtifactsWithNonTestScope();
        if (usedDeclaredArtifacts.contains(artifact) || usedUndeclaredArtifacts.contains(artifact)) {
            return Component.Scope.REQUIRED;
        }
        if (unusedDeclaredArtifacts.contains(artifact) || testArtifactsWithNonTestScope.contains(artifact)) {
            return Component.Scope.OPTIONAL;
        }
        return null;
    }
}

